/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.swivelChair;

import android.content.Context;
import android.support.v4.util.LongSparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.StringUtils;
import com.yymobile.core.user.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SwivelChairMyRecordAdapter
extends BaseAdapter {
    private Context mContext;
    private LayoutInflater inflater;
    private ArrayList<Map<String, String>> records = new ArrayList();
    private LongSparseArray<String> headsUrl = new LongSparseArray();

    public SwivelChairMyRecordAdapter(Context mContext) {
        this.mContext = mContext;
        this.inflater = LayoutInflater.from((Context)mContext);
    }

    public void setData(ArrayList<Map<String, String>> datas, boolean isClear) {
        if (isClear) {
            this.records.clear();
        }
        if (null != datas && datas.size() > 0) {
            this.records.addAll(datas);
        }
        this.notifyDataSetChanged();
    }

    public void setHead(List<UserInfo> userInfoList) {
        if (userInfoList == null || userInfoList.isEmpty() || this.records.isEmpty()) {
            return;
        }
        int size = userInfoList.size();
        for (int i = 0; i < size; ++i) {
            UserInfo info = userInfoList.get(i);
            if (null == info) continue;
            this.headsUrl.put(info.userId, (Object)info.iconUrl);
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.records.size();
    }

    public Object getItem(int position) {
        return position < this.records.size() ? this.records.get(position) : null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        Map item2 = (Map)this.getItem(position);
        if (null == item2 || item2.containsKey("isLastPage") && "1".equals(item2.get("isLastPage"))) {
            return 0;
        }
        return 1;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.getItemViewType(position) == 0) {
            convertView = this.inflater.inflate(R.layout.item_transparent_no_data, null);
        } else {
            ViewHolder holder;
            if (null == convertView) {
                holder = new ViewHolder();
                convertView = this.inflater.inflate(R.layout.swivelchair_myrecord_itme_layout, null);
                holder.headImg = (CircleImageView)convertView.findViewById(R.id.record_head);
                holder.timeTxt = (TextView)convertView.findViewById(R.id.record_time);
                holder.betTxt = (TextView)convertView.findViewById(R.id.record_betting);
                holder.getTxt = (TextView)convertView.findViewById(R.id.record_reward);
                holder.multiple = (TextView)convertView.findViewById(R.id.record_multiple);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            Map map = (Map)this.getItem(position);
            if (null != map) {
                if (null != holder.headImg) {
                    String url = "";
                    if (map.containsKey("url")) {
                        url = (String)map.get("url");
                    } else if (map.containsKey("anchorUid") && this.headsUrl.indexOfKey(StringUtils.safeParseLong((String)((String)map.get("anchorUid")))) >= 0) {
                        url = (String)this.headsUrl.get(StringUtils.safeParseLong((String)((String)map.get("anchorUid"))));
                        map.put("url", url);
                    }
                    ImageLoader.loadImage((String)url, (RecycleImageView)holder.headImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                }
                if (null != holder.timeTxt) {
                    holder.timeTxt.setText((CharSequence)(map.containsKey("time") && null != map.get("time") ? (String)map.get("time") : ""));
                }
                if (null != holder.betTxt) {
                    holder.betTxt.setText((CharSequence)(map.containsKey("betNum") && null != map.get("betNum") ? (String)map.get("betNum") : ""));
                }
                if (null != holder.getTxt) {
                    holder.getTxt.setText((CharSequence)(map.containsKey("resNum") && null != map.get("resNum") ? (String)map.get("resNum") : ""));
                }
                if (null != holder.multiple) {
                    holder.multiple.setText((CharSequence)((map.containsKey("multiple") ? (String)map.get("multiple") : "") + "\u500d"));
                }
            }
        }
        return convertView;
    }

    public static class ViewHolder {
        public CircleImageView headImg;
        public TextView timeTxt;
        public TextView betTxt;
        public TextView getTxt;
        public TextView multiple;
    }
}

