/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.basic.module.management;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.duowan.mobile.entlive.domain.IEntModule;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.live.basic.ELAbsModule;
import com.yy.live.basic.ELModuleFactory;
import com.yy.live.basic.LiveComponent$$DiffSupplementsFactory;
import com.yy.live.basic.module.event.BaseModuleEvent;
import com.yy.live.basic.module.event.ModuleGoneEvent;
import com.yy.live.basic.module.event.ModuleInvisibleEvent;
import com.yy.live.basic.module.event.ModuleVisibleEvent;
import com.yy.live.basic.module.management.AddModuleEvent;
import com.yy.live.basic.module.management.AliveManagerReference;
import com.yy.live.basic.module.management.ELModuleContext;
import com.yy.live.basic.module.management.ELModulesManager$$EventBinder;
import com.yy.live.basic.module.management.ModuleManagerOperator;
import com.yy.live.basic.module.management.RemoveModuleEvent;
import com.yy.live.basic.module.management.differentsupplement.DiffCalculator;
import com.yy.live.basic.module.management.differentsupplement.DiffSupplement;
import com.yy.live.basic.module.management.differentsupplement.SupplementFeature;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ELModulesManager
implements EventCompat,
ModuleManagerOperator {
    private static final String TAG = "ELModulesManager";
    private static final long DEFAULT_DELAY_LOAD_MODULE_MILES = 500L;
    private Map<String, ELAbsModule> mElAbsModules = new LinkedHashMap<String, ELAbsModule>();
    private ELModuleContext mELModuleContext = null;
    private Disposable mLoadModulesDisposable;
    private Stack<WeakReference<ELAbsModule>> mBackInterceptStack = new Stack();
    private Stack<SupplementFeature> mDiffFeatureStack = new Stack();
    private String mAttachedComponentName;
    private long mDelayLoadModuleMiles;
    private EventBinder mELModulesManagerSniperEventBinder;

    private ELModulesManager(@NonNull String attachedComponentName) {
        this.mAttachedComponentName = attachedComponentName;
    }

    public static ModuleManagerOperator newInstance(@NonNull String attachedComponentName) {
        return new ELModulesManager(attachedComponentName);
    }

    @Override
    public void initManager(ELModuleContext elModuleContext) {
        this.initManager(elModuleContext, 500L);
    }

    @Override
    public void initManager(ELModuleContext elModuleContext, long delayLoadModuleMiles) {
        this.mELModuleContext = elModuleContext;
        this.mELModuleContext.setModulesManger(this);
        this.mDelayLoadModuleMiles = delayLoadModuleMiles;
    }

    @Override
    public void onCreateView() {
        if (FP.empty((CharSequence)this.mAttachedComponentName)) {
            MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onCreateView() moduleName is empty"), (Object[])new Object[0]);
            return;
        }
        if (this.mELModuleContext == null) {
            MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onCreateView() mELModuleContext is empty"), (Object[])new Object[0]);
            return;
        }
        this.mLoadModulesDisposable = Observable.just((Object)this.mAttachedComponentName).delay(this.mDelayLoadModuleMiles, TimeUnit.MILLISECONDS).map((Function)new Function<String, Map<String, IEntModule>>(){

            public Map<String, IEntModule> apply(String s) {
                MLog.info((Object)ELModulesManager.TAG, (String)("ModuleGroup:" + ELModulesManager.this.mAttachedComponentName + " onCreateView() ready to create"), (Object[])new Object[0]);
                return ELModulesManager.this.getFinalModuleGroup(s);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Map<String, IEntModule>>(){

            public void accept(Map<String, IEntModule> iEntModules) {
                if (!FP.empty(iEntModules)) {
                    for (Map.Entry<String, IEntModule> entry : iEntModules.entrySet()) {
                        ELAbsModule module = (ELAbsModule)entry.getValue();
                        module.onPreCreateView(ELModulesManager.this.mELModuleContext, "");
                        String moduleKey = entry.getKey();
                        ELModulesManager.this.mElAbsModules.put(moduleKey, module);
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onCreateView() module error")));
        this.onEventBind();
        AliveManagerReference.callWhenOnCreated(this);
    }

    @Override
    public void onResume() {
        for (Map.Entry<String, ELAbsModule> stringELAbsModuleEntry : this.mElAbsModules.entrySet()) {
            stringELAbsModuleEntry.getValue().onResume();
        }
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onResume()"), (Object[])new Object[0]);
    }

    @Override
    public void onPause() {
        for (Map.Entry<String, ELAbsModule> stringELAbsModuleEntry : this.mElAbsModules.entrySet()) {
            stringELAbsModuleEntry.getValue().onPause();
        }
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onPause()"), (Object[])new Object[0]);
    }

    @Override
    public void onDispose() {
        AliveManagerReference.callWhenOnDestoried(this);
        this.onEventUnBind();
        this.disposeLoadModules();
        for (Map.Entry<String, ELAbsModule> stringELAbsModuleEntry : this.mElAbsModules.entrySet()) {
            stringELAbsModuleEntry.getValue().onDispose();
        }
        this.mElAbsModules.clear();
        this.mBackInterceptStack.clear();
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onDestroyView()"), (Object[])new Object[0]);
    }

    private void disposeLoadModules() {
        if (this.mLoadModulesDisposable != null && !this.mLoadModulesDisposable.isDisposed()) {
            this.mLoadModulesDisposable.dispose();
            this.mLoadModulesDisposable = null;
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        for (Map.Entry<String, ELAbsModule> stringELAbsModuleEntry : this.mElAbsModules.entrySet()) {
            stringELAbsModuleEntry.getValue().onSaveInstanceState(outState);
        }
    }

    @Override
    public void onOrientationChanges(boolean isLandscape) {
        for (Map.Entry<String, ELAbsModule> stringELAbsModuleEntry : this.mElAbsModules.entrySet()) {
            stringELAbsModuleEntry.getValue().onOrientationChanges(isLandscape);
        }
    }

    @Override
    public boolean onBackPressed() {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onBackPressed()"), (Object[])new Object[0]);
        if (this.mBackInterceptStack != null && !this.mBackInterceptStack.isEmpty()) {
            ELAbsModule module = (ELAbsModule)this.mBackInterceptStack.peek().get();
            if (module == null) {
                this.mBackInterceptStack.pop();
                return this.onBackPressed();
            }
            return module.onBackPress() && !module.persist();
        }
        return false;
    }

    public void subscribeBackPressListener(ELAbsModule modudle) {
        this.mBackInterceptStack.push(new WeakReference<ELAbsModule>(modudle));
    }

    public void unSubscribeBackPressListener(ELAbsModule modudle) {
        if (!this.mBackInterceptStack.isEmpty()) {
            this.mBackInterceptStack.remove(modudle);
        }
    }

    @Override
    public ELAbsModule getModuleByName(String name) {
        return this.mElAbsModules.get(name);
    }

    @Override
    @NonNull
    public String getAttachedComponentName() {
        return this.mAttachedComponentName;
    }

    private void onRemoveModule(String moduleName) {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onRemoveModule() moduleName = " + moduleName), (Object[])new Object[0]);
        if (!FP.empty((CharSequence)moduleName) && this.mElAbsModules.containsKey(moduleName)) {
            ELAbsModule elAbsModule = this.mElAbsModules.remove(moduleName);
            elAbsModule.onPause();
            elAbsModule.onDispose();
        }
    }

    private void onAddModule(String moduleName) {
        ELAbsModule module;
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onAddModule() moduleName = " + moduleName), (Object[])new Object[0]);
        if (!FP.empty((CharSequence)moduleName) && !this.mElAbsModules.containsKey(moduleName) && this.mELModuleContext != null && (module = ELModuleFactory.newModuleInstance(moduleName)) != null) {
            module.onPreCreateView(this.mELModuleContext, "");
            module.onCreateView();
            this.mElAbsModules.put(moduleName, module);
        }
    }

    private void onModuleGone(@NonNull ELAbsModule module) {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onModuleGone() moduleName = " + module.getCurrentModuleName()), (Object[])new Object[0]);
        module.onModuleGone();
    }

    private void onModuleInvisible(@NonNull ELAbsModule module) {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onModuleInvisible() moduleName = " + module.getCurrentModuleName()), (Object[])new Object[0]);
        module.onModuleInvisible();
    }

    private void onModuleVisible(@NonNull ELAbsModule module) {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " onModuleVisible() moduleName = " + module.getCurrentModuleName()), (Object[])new Object[0]);
        module.onModuleVisible();
    }

    public boolean isComponentHit(String component) {
        return component.equals(this.mAttachedComponentName);
    }

    @Override
    public int applySupplement(@NotNull String diffName) {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " diffName = " + diffName), (Object[])new Object[0]);
        DiffSupplement supplement = LiveComponent$$DiffSupplementsFactory.getDiffSupplement(this.mAttachedComponentName, diffName);
        if (supplement == null) {
            return -1;
        }
        DiffSupplement currentSupplement = this.mDiffFeatureStack.isEmpty() ? null : this.mDiffFeatureStack.peek().getDiffSupplement();
        this.executeSupplementChange(currentSupplement, supplement);
        SupplementFeature feature = new SupplementFeature(supplement);
        this.mDiffFeatureStack.push(feature);
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " applySupplement() Feature created. featureId.hashCode = " + feature.hashCode()), (Object[])new Object[0]);
        return feature.getUniqueId();
    }

    @Override
    public boolean cancelSupplement(int cancelFeatureId) {
        MLog.info((Object)TAG, (String)("ModuleGroup:" + this.mAttachedComponentName + " cancelSupplement() cancelFeatureId = " + cancelFeatureId), (Object[])new Object[0]);
        SupplementFeature cancelFeature = null;
        for (SupplementFeature feature : this.mDiffFeatureStack) {
            if (feature.getUniqueId() != cancelFeatureId) continue;
            cancelFeature = feature;
            break;
        }
        if (cancelFeature == null) {
            return false;
        }
        int cancelFeatureStackIndex = this.mDiffFeatureStack.indexOf(cancelFeature);
        SupplementFeature goToFeature = cancelFeatureStackIndex == 0 ? null : (SupplementFeature)this.mDiffFeatureStack.get(cancelFeatureStackIndex - 1);
        SupplementFeature currentFeature = this.mDiffFeatureStack.peek();
        this.executeSupplementChange(currentFeature.getDiffSupplement(), goToFeature == null ? null : goToFeature.getDiffSupplement());
        for (int index = this.mDiffFeatureStack.size() - 1; index >= cancelFeatureStackIndex; --index) {
            this.mDiffFeatureStack.pop();
        }
        return true;
    }

    private void executeSupplementChange(@Nullable DiffSupplement from, @Nullable DiffSupplement to) {
        ELAbsModule module;
        DiffCalculator calculator = new DiffCalculator(from, to);
        for (String moduleName : calculator.getFinallyAppend()) {
            this.onAddModule(moduleName);
            module = this.getModuleByName(moduleName);
            this.onModuleVisible(module);
        }
        for (String moduleName : calculator.getFinallyRemove()) {
            module = this.getModuleByName(moduleName);
            if (module == null) continue;
            this.onModuleGone(module);
        }
    }

    @Deprecated
    public static void addModule(@NonNull String whichComponent, @NonNull String whatModule) {
        PluginBus.INSTANCE.get().post((Object)new AddModuleEvent(whichComponent, whatModule));
    }

    @Deprecated
    public static void removeModule(@NonNull String whichComponent, @NonNull String whatModule) {
        PluginBus.INSTANCE.get().post((Object)new RemoveModuleEvent(whichComponent, whatModule));
    }

    private Map<String, IEntModule> getFinalModuleGroup(String moduleGroupName) {
        if (this.mELModuleContext == null || this.mELModuleContext.getComponent() == null) {
            return Collections.emptyMap();
        }
        try {
            Class<?> factoryCls = Class.forName(moduleGroupName + "$$ELModulesFactory");
            Object factory = factoryCls.newInstance();
            Method method = factoryCls.getDeclaredMethod("createModules", String.class);
            Map moduleMap = (Map)method.invoke(factory, moduleGroupName);
            if (!moduleMap.isEmpty()) {
                return moduleMap;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return Collections.emptyMap();
    }

    @NonNull
    private List<ELAbsModule> whichModuleHit(@NonNull BaseModuleEvent event) {
        LinkedList<ELAbsModule> hitModules = new LinkedList<ELAbsModule>();
        for (BaseModuleEvent.TargetModuleIdentification target2 : event.getTargets()) {
            if (!this.isComponentHit(target2.getComponent())) continue;
            if (target2.getModule().equals("*")) {
                return new LinkedList<ELAbsModule>(this.mElAbsModules.values());
            }
            ELAbsModule module = this.getModuleByName(target2.getModule());
            if (module == null) continue;
            hitModules.add(module);
        }
        return hitModules;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onAddModuleEvent(AddModuleEvent event) {
        if (event.getComponent().equals(this.mAttachedComponentName)) {
            this.onAddModule(event.getModule());
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onRemoveModuleEvent(RemoveModuleEvent event) {
        if (event.getComponent().equals(this.mAttachedComponentName)) {
            this.onRemoveModule(event.getModule());
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public final void onModuleGoneEvent(ModuleGoneEvent event) {
        for (ELAbsModule module : this.whichModuleHit(event)) {
            this.onModuleGone(module);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public final void onModuleInvisibleEvent(ModuleInvisibleEvent event) {
        for (ELAbsModule module : this.whichModuleHit(event)) {
            this.onModuleInvisible(module);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public final void onModuleVisibleEvent(ModuleVisibleEvent event) {
        for (ELAbsModule module : this.whichModuleHit(event)) {
            this.onModuleVisible(module);
        }
    }

    public void onEventBind() {
        if (this.mELModulesManagerSniperEventBinder == null) {
            this.mELModulesManagerSniperEventBinder = new ELModulesManager$$EventBinder();
        }
        this.mELModulesManagerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mELModulesManagerSniperEventBinder != null) {
            this.mELModulesManagerSniperEventBinder.unBindEvent();
        }
    }
}

