/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.opensdk.mobile.host.init;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.opensdk.mobile.dalvikpatch.DalvikPatch;
import com.unionyy.opensdk.mobile.host.init.AsyncInitTask;
import com.unionyy.opensdk.mobile.host.init.FixAndroidP;
import com.unionyy.opensdk.mobile.host.init.PrimaryTask;
import com.unionyy.opensdk.mobile.host.init.SpdtInitProcess;
import com.yy.mobile.baseapi.common.Constants;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.hiido.HiidoManager;
import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.config.HttpNetConfigImp;
import com.yy.mobile.http.config.IHttpNetConfig;
import com.yy.mobile.ipc.IPCApiBridge;
import com.yy.mobile.sdkwrapper.yylive.sdkadapt.SdkAdapter;
import com.yy.mobile.ui.widget.FloatingGroupExpandableListView;
import com.yy.mobile.union.api.impl.UnionAuthActionImpl;
import com.yy.mobile.uniondif.AppIdConfig;
import com.yy.mobile.util.Logger;
import com.yy.mobile.util.NetworkMonitor;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.LogCompressListener;
import com.yy.mobile.util.log.LogManager;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"Lcom/unionyy/opensdk/mobile/host/init/PrimaryTask;", "", "()V", "initHttp", "", "initHttpHeaders", "initLogging", "initSkin", "isRestartProcess", "", "myProcessName", "", "notifySlow", "raiseMainThreadPriority", "run", "application", "Landroid/app/Application;", "isDebugPackage", "opensdk_release"})
public final class PrimaryTask {
    public final void run(@NotNull Application application, @Nullable String myProcessName, boolean isDebugPackage) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Log.i((String)"PrimaryTask", (String)("process name: " + myProcessName));
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        basicConfig.setAppContext((Context)application);
        BasicConfig.getInstance().appId = AppIdConfig.getAppIds().getUdbAppId();
        BasicConfig.getInstance().isBuildDebug = false;
        BasicConfig.getInstance().isDebugPackage = isDebugPackage;
        BasicConfig basicConfig2 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig2, (String)"BasicConfig.getInstance()");
        basicConfig2.setDebuggable(isDebugPackage);
        boolean isMainProcess = TextUtils.equals((CharSequence)application.getPackageName(), (CharSequence)myProcessName);
        if (((SpdtInitProcess)Spdt.of(SpdtInitProcess.class)).canInitInOtherProcess() || isMainProcess) {
            this.initLogging();
            YYStore.INSTANCE.init(CollectionsKt.emptyList());
            MLog.info((Object)"PrimaryTask", (String)(" curProcessName= " + myProcessName), (Object[])new Object[0]);
            DalvikPatch.patch();
            NetworkMonitor networkMonitor = NetworkMonitor.instance();
            BasicConfig basicConfig3 = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig3, (String)"BasicConfig.getInstance()");
            networkMonitor.init(basicConfig3.getAppContext());
            BasicConfig basicConfig4 = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig4, (String)"BasicConfig.getInstance()");
            NetworkUtils.init((Context)basicConfig4.getAppContext());
            this.initHttp();
            BasicConfig basicConfig5 = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig5, (String)"BasicConfig.getInstance()");
            Context context = basicConfig5.getAppContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"BasicConfig.getInstance().appContext");
            IPCApiBridge.INSTANCE.init(context);
            this.raiseMainThreadPriority();
            YYActivityManager.INSTANCE.init(application);
            BasicConfig basicConfig6 = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig6, (String)"BasicConfig.getInstance()");
            if (basicConfig6.isDebuggable()) {
                AsyncInitTask.INSTANCE.setTestHostVersion("5.0.1-SNAPSHOT");
            }
            this.notifySlow();
            FixAndroidP.INSTANCE.fixWarning();
            StringBuilder stringBuilder = new StringBuilder();
            File file = application.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.filesDir");
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"application.filesDir.parentFile");
            SdkAdapter.setLibPath((String)stringBuilder.append(file2.getAbsolutePath()).append(File.separator).append("lib").toString());
            SdkAdapter.initAuthSdk();
            SdkAdapter.setupYYHandler();
            SdkAdapter.initYYLiveKit();
            SdkAdapter.setupMediaHandler();
            UnionAuthActionImpl.INSTANCE.init(application);
            this.initSkin();
            BasicConfig basicConfig7 = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig7, (String)"BasicConfig.getInstance()");
            HiidoManager.initHiido((Context)basicConfig7.getAppContext());
            HiidoManager.pilingHiidoStatisticContent((String)"UmengInitBegin", (String)"non");
            HiidoManager.pilingHiidoStatisticContent((String)"UmengInitEnd", (String)"non");
            HiidoManager.pilingHiidoStatisticContent((String)"PushInitBegin", (String)"non");
            HiidoManager.pilingHiidoStatisticContent((String)"PushInitEnd", (String)"non");
        } else {
            this.initLogging();
        }
    }

    private final void initSkin() {
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        Context context = basicConfig.getAppContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Application");
        }
        Spdt.INSTANCE.applySkin((Application)context, (Function1)initSkin.1.INSTANCE);
    }

    private final void notifySlow() {
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        if (basicConfig.isDebuggable() && Build.VERSION.SDK_INT >= 26) {
            FloatingGroupExpandableListView.ReflectionUtils.setFieldValue(Looper.class, (String)"mSlowDispatchThresholdMs", (Object)Looper.getMainLooper(), (Object)60);
        }
    }

    private final void initHttp() {
        this.initHttpHeaders();
        HttpNetConfigImp config = new HttpNetConfigImp();
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        config.setContext(basicConfig.getAppContext());
        config.setCacheDir(Constants.Host.YYMOBILE_DIR_NAME + File.separator + "http");
        RequestManager.instance().init((IHttpNetConfig)config);
    }

    private final void initHttpHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, String> $this$run = hashMap;
        boolean bl3 = false;
        $this$run.put("compAppid", BasicConfig.getInstance().appId);
        $this$run.put("stype", "1");
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)basicConfig.getAppContext());
        boolean bl4 = false;
        boolean bl5 = false;
        VersionUtil.Ver $this$run2 = ver;
        boolean bl6 = false;
        $this$run.put("version", $this$run2.getVersionNameWithoutSnapshot());
        String userAgent = "Platform/Android" + Build.VERSION.RELEASE + " APP/" + BasicConfig.getInstance().appId + $this$run2.getVersionNameWithoutSnapshot() + " Model/" + Build.MODEL + " Browser/None";
        $this$run.put("User-Agent", userAgent);
        BaseNetwork.setCommonHeaders((Map)$this$run);
    }

    private final boolean isRestartProcess(String myProcessName) {
        return myProcessName != null && StringsKt.endsWith$default((String)myProcessName, (String)":restart", (boolean)false, (int)2, null);
    }

    private final void raiseMainThreadPriority() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        boolean bl2 = false;
        Thread $this$run = thread;
        boolean bl3 = false;
        int idealPriority = ($this$run.getPriority() + 10) / 2;
        if ($this$run.getPriority() < idealPriority) {
            $this$run.setPriority(idealPriority);
            Process.setThreadPriority((int)-14);
        }
    }

    private final void initLogging() {
        BasicConfig basicConfig = BasicConfig.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        BasicConfig $this$run = basicConfig;
        boolean bl3 = false;
        $this$run.setRootDir(Constants.Host.YYMOBILE_DIR_NAME);
        $this$run.setConfigDir(Constants.Host.YYMOBILE_DIR_NAME + File.separator + "config");
        $this$run.setLogDir();
        basicConfig = new Logger.LogConfig();
        bl = false;
        bl2 = false;
        $this$run = basicConfig;
        boolean bl4 = false;
        BasicConfig basicConfig2 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig2, (String)"BasicConfig.getInstance()");
        $this$run.dir = basicConfig2.getLogDirPath();
        Log.d((String)"PrimaryTask", (String)(" Logger dir " + $this$run.dir));
        Logger.init((Logger.LogConfig)$this$run);
        LogManager.getInstance().setLogProvider(new LogManager.LogProvider(){

            public boolean fillAppLogs(@NotNull List<File> appLogs, @Nullable LogCompressListener listener) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(appLogs, (String)"appLogs");
                BasicConfig basicConfig = BasicConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
                File dirFile = new File(basicConfig.getLogDirPath());
                if (!dirFile.exists()) {
                    LogCompressListener logCompressListener = listener;
                    if (logCompressListener != null) {
                        logCompressListener.onCompressError(-8);
                    }
                    bl = false;
                } else {
                    File[] files = dirFile.listFiles();
                    if (files == null) {
                        LogCompressListener logCompressListener = listener;
                        if (logCompressListener != null) {
                            logCompressListener.onCompressError(-9);
                        }
                        bl = false;
                    } else {
                        Collections.addAll((Collection)appLogs, Arrays.copyOf(files, files.length));
                        bl = true;
                    }
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            public boolean fillSdkLogs(@NotNull List<File> sdkLogs, @NotNull LogCompressListener listener) {
                block1: {
                    void $this$filterNotTo$iv;
                    Intrinsics.checkParameterIsNotNull(sdkLogs, (String)"sdkLogs");
                    Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
                    BasicConfig basicConfig = BasicConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
                    File[] fileArray = new File(basicConfig.getSDKLogDirPath()).listFiles();
                    if (fileArray == null) break block1;
                    File[] fileArray2 = fileArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    File[] it = fileArray2;
                    boolean bl3 = false;
                    File[] fileArray3 = it;
                    Collection destination$iv = sdkLogs;
                    boolean $i$f$filterNotTo = false;
                    void var11_11 = $this$filterNotTo$iv;
                    int n = ((void)var11_11).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it2 = element$iv = var11_11[i];
                        boolean bl4 = false;
                        void v2 = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                        if (v2.isDirectory()) continue;
                        destination$iv.add(element$iv);
                    }
                    List cfr_ignored_0 = (List)destination$iv;
                }
                return true;
            }

            public boolean fillExtraFiles(@NotNull List<? extends File> extraFiles, @NotNull LogCompressListener listener) {
                Intrinsics.checkParameterIsNotNull(extraFiles, (String)"extraFiles");
                Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
                return true;
            }
        });
    }
}

