/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.opensdk.mobile.host.init;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.unionyy.opensdk.mobile.host.common.PerfSdkIniter;
import com.unionyy.opensdk.mobile.host.init.AsyncInitTask;
import com.unionyy.opensdk.mobile.host.init.YCloudStartupManager;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.baseapi.model.store.action.YYState_TestHostVersionAction;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.hiido.HiidoManager;
import com.yy.mobile.model.Action;
import com.yy.mobile.util.log.MLog;
import io.reactivex.functions.Consumer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0006J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unionyy/opensdk/mobile/host/init/AsyncInitTask;", "", "()V", "TAG", "", "mCompleteListener", "Lcom/unionyy/opensdk/mobile/host/init/AsyncInitTask$CompleteListener;", "mMainHandler", "Landroid/os/Handler;", "mRunningState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/unionyy/opensdk/mobile/host/init/AsyncInitTask$RunningState;", "mStartTime", "", "doRunInBackground", "", "notifyTaskFail", "notifyTaskSuccess", "onStartupFinished", "run", "listener", "rxJavaHelper", "setTestHostVersion", "testHostVersion", "CompleteListener", "RunningState", "opensdk_release"})
public final class AsyncInitTask {
    private static final String TAG = "AsyncInitTask";
    private static AtomicReference<RunningState> mRunningState;
    private static CompleteListener mCompleteListener;
    private static final Handler mMainHandler;
    private static long mStartTime;
    public static final AsyncInitTask INSTANCE;

    public final void run(@NotNull CompleteListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (mRunningState.get() != RunningState.DONE) {
            mStartTime = System.currentTimeMillis();
            mCompleteListener = listener;
            MLog.info((Object)TAG, (String)("not done yet, set listener: " + listener), (Object[])new Object[0]);
            if (mRunningState.compareAndSet(RunningState.NOT_RUN, RunningState.RUNNING)) {
                MLog.info((Object)TAG, (String)"not run yet, schedule to run", (Object[])new Object[0]);
                HandlerThread handlerThread = new HandlerThread("AsyncInitHandler");
                boolean bl = false;
                boolean bl2 = false;
                HandlerThread $this$run = handlerThread;
                boolean bl3 = false;
                $this$run.start();
                new Handler($this$run.getLooper()).post((Runnable)run.1.1.INSTANCE);
            }
        } else {
            this.notifyTaskSuccess();
        }
    }

    public final void setTestHostVersion(@NotNull String testHostVersion) {
        Intrinsics.checkParameterIsNotNull((Object)testHostVersion, (String)"testHostVersion");
        YYStore.INSTANCE.dispatch((Action)new YYState_TestHostVersionAction(testHostVersion));
    }

    private final void notifyTaskSuccess() {
        mMainHandler.postAtFrontOfQueue((Runnable)notifyTaskSuccess.1.INSTANCE);
    }

    private final void notifyTaskFail() {
        mMainHandler.postAtFrontOfQueue((Runnable)notifyTaskFail.1.INSTANCE);
    }

    public final void doRunInBackground() {
        MLog.info((Object)TAG, (String)"doRunInBackground running", (Object[])new Object[0]);
        this.rxJavaHelper();
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        Context context = basicConfig.getAppContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Application");
        }
        PerfSdkIniter.init((Application)context);
        YCloudStartupManager.INSTANCE.startUrgent();
        BasicConfig basicConfig2 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig2, (String)"BasicConfig.getInstance()");
        HiidoManager.initHiido((Context)basicConfig2.getAppContext());
        this.notifyTaskSuccess();
    }

    private final void rxJavaHelper() {
        if (!RxJavaPlugins.isLockdown()) {
            RxJavaPlugins.setErrorHandler((Consumer)rxJavaHelper.1.INSTANCE);
            RxJavaPlugins.lockdown();
        }
    }

    private final void onStartupFinished() {
        long endTime = System.currentTimeMillis();
        MLog.info((Object)TAG, (String)("onStartupFinished " + (endTime - mStartTime)), (Object[])new Object[0]);
        mRunningState.set(RunningState.DONE);
    }

    private AsyncInitTask() {
    }

    static {
        AsyncInitTask asyncInitTask;
        INSTANCE = asyncInitTask = new AsyncInitTask();
        mRunningState = new AtomicReference<RunningState>(RunningState.NOT_RUN);
        mMainHandler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ CompleteListener access$getMCompleteListener$p(AsyncInitTask $this) {
        AsyncInitTask asyncInitTask = $this;
        return mCompleteListener;
    }

    public static final /* synthetic */ void access$setMCompleteListener$p(AsyncInitTask $this, CompleteListener completeListener) {
        AsyncInitTask asyncInitTask = $this;
        mCompleteListener = completeListener;
    }

    public static final /* synthetic */ void access$onStartupFinished(AsyncInitTask $this) {
        $this.onStartupFinished();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unionyy/opensdk/mobile/host/init/AsyncInitTask$RunningState;", "", "(Ljava/lang/String;I)V", "NOT_RUN", "RUNNING", "DONE", "opensdk_release"})
    public static final class RunningState
    extends Enum<RunningState> {
        public static final /* enum */ RunningState NOT_RUN;
        public static final /* enum */ RunningState RUNNING;
        public static final /* enum */ RunningState DONE;
        private static final /* synthetic */ RunningState[] $VALUES;

        static {
            RunningState[] runningStateArray = new RunningState[3];
            RunningState[] runningStateArray2 = runningStateArray;
            runningStateArray[0] = NOT_RUN = new RunningState();
            runningStateArray[1] = RUNNING = new RunningState();
            runningStateArray[2] = DONE = new RunningState();
            $VALUES = runningStateArray;
        }

        public static RunningState[] values() {
            return (RunningState[])$VALUES.clone();
        }

        public static RunningState valueOf(String string) {
            return Enum.valueOf(RunningState.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/unionyy/opensdk/mobile/host/init/AsyncInitTask$CompleteListener;", "", "onTaskFailed", "", "onTaskSuccess", "opensdk_release"})
    public static interface CompleteListener {
        public void onTaskSuccess();

        public void onTaskFailed();
    }
}

