/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.opensdk.mobile.host.common;

import android.content.Context;
import android.os.Environment;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/unionyy/opensdk/mobile/host/common/DataCleanManager;", "", "()V", "cleanApplicationData", "", "context", "Landroid/content/Context;", "cleanExternalCache", "cleanSDCardData", "clearAppUserData", "deleteDirWithFile", "dir", "Ljava/io/File;", "opensdk_release"})
public final class DataCleanManager {
    public static final DataCleanManager INSTANCE;

    public final void cleanApplicationData(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.cleanSDCardData(context);
        this.clearAppUserData(context);
    }

    private final void clearAppUserData(Context context) {
        try {
            Runtime.getRuntime().exec("pm clear  " + context.getPackageName());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private final void cleanSDCardData(Context context) {
        String[] dirs = new String[4];
        if (Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted")) {
            dirs[0] = Environment.getExternalStorageDirectory().toString() + "/yymobile";
            dirs[1] = Environment.getExternalStorageDirectory().toString() + "/yyplugins";
            dirs[2] = Environment.getExternalStorageDirectory().toString() + "/YYPushService/" + context.getPackageName();
            dirs[3] = Environment.getExternalStorageDirectory().toString() + "/" + context.getPackageName();
        }
        for (String filePath : dirs) {
            this.deleteDirWithFile(new File(filePath));
        }
        this.cleanExternalCache(context);
    }

    private final void cleanExternalCache(Context context) {
        if (Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted")) {
            this.deleteDirWithFile(context.getExternalCacheDir());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteDirWithFile(File dir) {
        block5: {
            if (dir != null && dir.isDirectory()) {
                File[] fileArray = dir.listFiles();
                if (fileArray != null) {
                    void $this$filterTo$iv$iv;
                    File[] $this$filter$iv = fileArray;
                    boolean $i$f$filter = false;
                    File[] fileArray2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    void var7_8 = $this$filterTo$iv$iv;
                    int n = ((void)var7_8).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = var7_8[i];
                        boolean bl = false;
                        if (!(it != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File it = (File)element$iv;
                        boolean bl = false;
                        File file = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        if (file.isFile()) {
                            boolean r = it.delete();
                            MLog.info((Object)"DataCleanManager", (String)("delete " + (r ? "success" : "failed") + " : " + it), (Object[])new Object[0]);
                            continue;
                        }
                        if (!it.isDirectory()) continue;
                        INSTANCE.deleteDirWithFile(it);
                    }
                }
            }
            File file = dir;
            if (file == null) break block5;
            file.delete();
        }
    }

    private DataCleanManager() {
    }

    static {
        DataCleanManager dataCleanManager;
        INSTANCE = dataCleanManager = new DataCleanManager();
    }
}

