/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.mobile.bizmodel.login.LoginUtilHomeApi;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.util.AppMetaDataUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.TelephonyUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;

public class CommonParamUtil {
    private static ParamValues sParamValues;

    public static RequestParam fillCommonParam() {
        DefaultRequestParam param = new DefaultRequestParam();
        try {
            if (sParamValues == null) {
                sParamValues = new ParamValues();
            }
            param.put("os", sParamValues.getOs());
            param.put("osVersion", sParamValues.getOsVersion());
            param.put("yyVersion", sParamValues.getYyVersion());
            param.put("ispType", String.valueOf(CommonParamUtil.getIspType()));
            param.put("netType", String.valueOf(CommonParamUtil.getNetworkType()));
            param.put("model", sParamValues.getModel());
            param.put("channel", sParamValues.getChannel());
            param.put("uid", LoginUtilHomeApi.isLogined() ? String.valueOf(LoginUtilHomeApi.getUid()) : "0");
            param.put("imei", sParamValues.getImei());
            param.put("sdkVersion", sParamValues.getSdkVersion());
            param.put("mac", sParamValues.getMac());
            param.put("hdid", CommonParamUtil.getHdid());
            param.put("appid", "yym");
        }
        catch (Throwable e2) {
            MLog.error((Object)"CommonParamUtil", (String)"[kaede] getAuthCore null", (Object[])new Object[0]);
        }
        return param;
    }

    public static int getNetworkType() {
        if (NetworkUtils.getNetworkType((Context)BasicConfig.getInstance().getAppContext()) == 1) {
            return 2;
        }
        return 1;
    }

    public static int getIspType() {
        String isp = NetworkUtils.getOperator((Context)BasicConfig.getInstance().getAppContext());
        int ispType = 4;
        if (isp.equals("CMCC")) {
            ispType = 1;
        } else if (isp.equals("UNICOM")) {
            ispType = 2;
        } else if (isp.equals("CTL")) {
            ispType = 3;
        }
        return ispType;
    }

    public static String getPhoneModel() {
        return Build.MODEL;
    }

    public static String getMac() {
        return NetworkUtils.getMac((Context)BasicConfig.getInstance().getAppContext());
    }

    public static String getHdid() {
        try {
            if (BasicConfig.getInstance().getAppContext() != null) {
                return HiidoSDK.instance().getHdid(BasicConfig.getInstance().getAppContext());
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"HiidoSDK getHdid error: %s", (String)throwable.toString(), (Object[])new Object[0]);
        }
        return "";
    }

    private static class ParamValues {
        private String os;
        private String osVersion;
        private String yyVersion;
        private String model;
        private String channel;
        private String imei;
        private String sdkVersion;
        private String mac;

        private ParamValues() {
        }

        public String getOs() {
            if (TextUtils.isEmpty((CharSequence)this.os)) {
                this.os = "android";
            }
            return this.os;
        }

        public String getOsVersion() {
            if (TextUtils.isEmpty((CharSequence)this.osVersion)) {
                this.osVersion = Build.VERSION.RELEASE;
            }
            return this.osVersion;
        }

        public String getYyVersion() {
            if (TextUtils.isEmpty((CharSequence)this.yyVersion)) {
                this.yyVersion = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameWithoutSnapshot();
            }
            return this.yyVersion;
        }

        public String getModel() {
            if (TextUtils.isEmpty((CharSequence)this.model)) {
                this.model = CommonParamUtil.getPhoneModel();
            }
            return this.model;
        }

        public String getChannel() {
            if (TextUtils.isEmpty((CharSequence)this.channel)) {
                this.channel = AppMetaDataUtil.getChannelID((Context)BasicConfig.getInstance().getAppContext());
            }
            return this.channel;
        }

        public String getImei() {
            if (TextUtils.isEmpty((CharSequence)this.imei)) {
                this.imei = TelephonyUtils.getImei((Context)BasicConfig.getInstance().getAppContext());
            }
            return this.imei;
        }

        public String getSdkVersion() {
            if (TextUtils.isEmpty((CharSequence)this.sdkVersion)) {
                this.sdkVersion = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameWithoutSnapshot();
            }
            return this.sdkVersion;
        }

        public String getMac() {
            if (TextUtils.isEmpty((CharSequence)this.mac)) {
                this.mac = NetworkUtils.getMac((Context)BasicConfig.getInstance().getAppContext());
            }
            return this.mac;
        }
    }
}

