/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.ent.v2;

import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.Validation;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.ent.v2.ServiceApp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtosMapperV2 {
    private static final String TAG = "ProtosMapperV2";
    private static Map<ServiceApp, ProtosMapperV2> sAppidMapper = new HashMap<ServiceApp, ProtosMapperV2>();
    private Map<Long, Class<? extends IEntProtocol>> mMapper = new ConcurrentHashMap<Long, Class<? extends IEntProtocol>>();

    public static synchronized ProtosMapperV2 getInstanceByServiceApp(ServiceApp serviceApp) {
        ProtosMapperV2 mapperV2 = sAppidMapper.get(serviceApp);
        if (mapperV2 == null) {
            mapperV2 = new ProtosMapperV2();
            sAppidMapper.put(serviceApp, mapperV2);
        }
        return mapperV2;
    }

    private ProtosMapperV2() {
    }

    public void add(Class<? extends IEntProtocol> ... protocolClasses) {
        if (FP.size((Object[])protocolClasses) > 0) {
            for (Class<? extends IEntProtocol> protocolClass : protocolClasses) {
                try {
                    IEntProtocol protocol = protocolClass.newInstance();
                    this.add(protocolClass, protocol.getMaxType().intValue(), protocol.getMinType().intValue());
                }
                catch (Exception e2) {
                    MLog.error((Object)TAG, (String)"add protocol class error.", (Throwable)e2, (Object[])new Object[0]);
                }
            }
        }
    }

    public void add(Class<? extends IEntProtocol> protocolClass, int max, int min) {
        Validation.checkNull((String)"protocolClass", (Object[])new Object[]{protocolClass});
        long key = this.hashKey(max, min);
        Class<? extends IEntProtocol> classAdded = this.mMapper.get(key);
        if (classAdded == null) {
            this.mMapper.put(key, protocolClass);
        } else if (!classAdded.equals(protocolClass)) {
            throw new IllegalStateException(String.format("Protocol class[max=%d,min=%d] has added, exist: %s, add: %s", max, min, classAdded, protocolClass));
        }
    }

    public void remove(Class<? extends IEntProtocol> ... protocolClasses) {
        if (FP.size((Object[])protocolClasses) > 0) {
            for (Class<? extends IEntProtocol> protocolClass : protocolClasses) {
                try {
                    IEntProtocol protocol = protocolClass.newInstance();
                    long key = this.hashKey(protocol.getMaxType().intValue(), protocol.getMinType().intValue());
                    this.mMapper.remove(key);
                }
                catch (Exception e2) {
                    MLog.error((Object)TAG, (String)"remove protocol class error.", (Throwable)e2, (Object[])new Object[0]);
                }
            }
        }
    }

    public Class<? extends IEntProtocol> get(int max, int min) {
        return this.mMapper.get(this.hashKey(max, min));
    }

    private long hashKey(int max, int min) {
        return (long)max << 32 | (long)min;
    }
}

