/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.db;

import android.support.annotation.NonNull;
import com.yy.mobile.util.Logger;
import com.yymobile.core.db.DbCommand;
import com.yymobile.core.db.DbContext;
import com.yymobile.core.db.DbHelper;
import com.yymobile.core.db.DbResult;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DbThread
implements DbContext {
    protected volatile DbHelper dbHelper;
    @NonNull
    protected final String dbName;
    protected final Logger logger;
    private volatile boolean isReady = false;
    private List<DbCommand> cachedCommands = Collections.synchronizedList(new ArrayList());

    public DbThread(@NonNull String name, @NonNull String dbName) {
        this.dbName = dbName;
        this.logger = Logger.getLogger((String)name);
        this.logger.debug("DbThread constructor");
    }

    private <T> void processResult(final @NonNull DbCommand<T> cmd) {
        this.scheduleMainThread(new Runnable(){

            @Override
            public void run() {
                DbResult dbResult = cmd.getResult();
                switch (dbResult.resultCode) {
                    case Successful: {
                        cmd.onSucceed(dbResult.resultObject);
                        break;
                    }
                    case Failed: {
                        cmd.onFail(dbResult.error);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void sendCommand(DbCommand cmd) {
        if (cmd != null) {
            if (!this.isReady) {
                this.cachedCommands.add(cmd);
            } else {
                this.processCommand(cmd);
            }
        }
    }

    private void processCachedCommands() {
        if (this.dbHelper != null) {
            ArrayList<DbCommand> commands = new ArrayList<DbCommand>(this.cachedCommands);
            if (commands.size() > 0) {
                this.logger.info("handle cached commands: " + commands.size());
                for (DbCommand cmd : commands) {
                    this.processCommand(cmd);
                }
            }
            commands.clear();
        }
        this.cachedCommands.clear();
    }

    @Override
    public abstract void createDbHelper(String var1);

    @Override
    public DbHelper getDbHelper() {
        return this.dbHelper;
    }

    @Override
    public void closeDbHelper() {
        this.scheduleDbThread(new Runnable(){

            @Override
            public void run() {
                if (DbThread.this.dbHelper != null) {
                    DbThread.this.logger.info("close dbHelper: " + DbThread.this.dbHelper.getDbName());
                    DbThread.this.dbHelper.close();
                    DbThread.this.dbHelper = null;
                }
            }
        });
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            return;
        }
        this.scheduleDbThread(new Runnable(){

            @Override
            public void run() {
                DbThread.this.createDbHelper(DbThread.this.dbName);
                DbThread.this.isReady = true;
                DbThread.this.logger.info("DbThread ready");
                DbThread.this.processCachedCommands();
            }
        });
    }

    private <T> void processCommand(final DbCommand<T> cmd) {
        if (cmd != null) {
            this.scheduleDbThread(new Runnable(){

                @Override
                public void run() {
                    cmd.realExecute();
                    DbThread.this.processResult(cmd);
                }
            });
        }
    }

    private void scheduleDbThread(Runnable action) {
        Schedulers.computation().scheduleDirect(action);
    }

    private void scheduleMainThread(Runnable action) {
        AndroidSchedulers.mainThread().scheduleDirect(action);
    }

    public boolean isOpen() {
        return this.dbHelper != null && this.dbHelper.isOpen();
    }
}

