/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.config.model;

import android.util.SparseArray;
import com.duowan.mobile.utils.FP;
import com.example.configcenterannotation.BssConfig;
import com.example.configcenterannotation.BssValue;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@BssConfig(name="AppBasicsConfig", bssCode="mobyy-base")
public class AppBasicsData {
    private static final String TAG = "AppBasicsData";
    @BssValue(property="universal_json_support_type")
    public Map<String, List<String>> mapConfig = new HashMap<String, List<String>>();
    @BssValue(property="HappyCampTip", key="visible")
    public int mShowHappyCampTip = -1;
    @BssValue(property="TabLocation")
    public String mTabLocation;
    @BssValue(property="DNSv2")
    public String mDNSv2;
    @BssValue(property="OKHttp")
    public String mOKHttp;
    @BssValue(property="https")
    public String mHttps;
    @BssValue(property="FreeTrafficAreaConfig", key="gridTitle")
    public String mGridTitle;
    @BssValue(property="FreeTrafficAreaConfig", key="gridIconUrl")
    public String mGridIconUrl;
    @BssValue(property="onepiece_live_home")
    public String mOnePieceLiveHome;
    @BssValue(property="bindingPhoneSkipCount", key="skipcount")
    public int mBingPhoneSkipCount = -1;
    public List<Long> mHostExcludeGames = new ArrayList<Long>();
    public String mHostErrorTips;
    public List<Long> mUserExcludeGames = new ArrayList<Long>();
    public String mUserErrorTips;
    public Map<Integer, Long> mPluginIdPlayoneIdMapping = new HashMap<Integer, Long>();
    public SparseArray<String> mBlackNameList = new SparseArray();

    @BssValue(property="Web_Redirect_Config")
    public void parseWebRedirect(String infos) {
        try {
            JSONObject object = new JSONObject(infos);
            JSONArray webBlackListConfig = object.optJSONArray("WebBlackListConfig");
            for (int idx = 0; idx < webBlackListConfig.length(); ++idx) {
                this.mBlackNameList.put(idx, (Object)webBlackListConfig.get(idx).toString());
            }
        }
        catch (Exception e2) {
            MLog.info((Object)TAG, (String)"parser error!", (Object[])new Object[0]);
        }
    }

    @BssValue(property="live_game_config")
    public void parseLiveGameConfig(String config) {
        if (!FP.empty((CharSequence)config)) {
            this.mHostExcludeGames.clear();
            this.mUserExcludeGames.clear();
            try {
                int i2;
                JSONObject jsonObject = new JSONObject(config);
                JSONArray array = jsonObject.getJSONArray("exclude_game_host");
                for (i2 = 0; array != null && i2 < array.length(); ++i2) {
                    this.mHostExcludeGames.add(array.getLong(i2));
                }
                this.mHostErrorTips = jsonObject.getString("error_tips_host");
                array = jsonObject.getJSONArray("exclude_game_user");
                for (i2 = 0; array != null && i2 < array.length(); ++i2) {
                    this.mUserExcludeGames.add(array.getLong(i2));
                }
                this.mUserErrorTips = jsonObject.getString("error_tips_user");
                this.mPluginIdPlayoneIdMapping.clear();
                JSONObject idsMapping = jsonObject.getJSONObject("playoneid_pluginid_mapping");
                if (idsMapping != null) {
                    Iterator iterator = idsMapping.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        this.mPluginIdPlayoneIdMapping.put(Integer.valueOf(key), idsMapping.getLong(key));
                    }
                }
            }
            catch (JSONException e2) {
                MLog.error((Object)TAG, (String)"parseLiveGameConfig error", (Throwable)e2, (Object[])new Object[0]);
            }
        }
    }

    public String toString() {
        return "AppBasicsData{mapConfig=" + this.mapConfig + ", mShowHappyCampTip=" + this.mShowHappyCampTip + ", mTabLocation='" + this.mTabLocation + '\'' + ", mDNSv2='" + this.mDNSv2 + '\'' + ", mOKHttp='" + this.mOKHttp + '\'' + ", mHttps='" + this.mHttps + '\'' + ", mGridTitle='" + this.mGridTitle + '\'' + ", mGridIconUrl='" + this.mGridIconUrl + '\'' + ", mOnePieceLiveHome='" + this.mOnePieceLiveHome + '\'' + ", mBingPhoneSkipCount=" + this.mBingPhoneSkipCount + ", mHostExcludeGames=" + this.mHostExcludeGames + ", mHostErrorTips='" + this.mHostErrorTips + '\'' + ", mUserExcludeGames=" + this.mUserExcludeGames + ", mUserErrorTips='" + this.mUserErrorTips + '\'' + ", mPluginIdPlayoneIdMapping=" + this.mPluginIdPlayoneIdMapping + ", mBlackNameList=" + this.mBlackNameList + '}';
    }
}

