/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.channel;

import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.richtext.ChannelImageEmoticonFilter;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgValidator {
    private static final String TAG = "MsgValidator";
    private static final int LEAST_MATCH_LENGTH = 20;
    private static final double LEAST_MATCH_POINT = 0.9;
    private static Map<Long, AtomicInteger> repeateCountMap = new HashMap<Long, AtomicInteger>();
    private static Map<Long, String> repeateMsgMap = new HashMap<Long, String>();
    private static MsgValidator msgFilter = new MsgValidator();
    private static final int MAX_REPEATE_COUNT = 10;
    private static List<String> ChannrlChatStrFilterList = new ArrayList<String>(){
        {
            this.add("<?xml");
            this.add("yy://");
        }
    };
    public static final int CHANNEL_CHAT_MAX_LEN = 100;
    public static final int PRIVATE_CHAT_MAX_LEN = 500;
    public static Pattern email = Pattern.compile("\\w+(\\.\\w+)*@\\w+(\\.\\w+)+");
    public static Pattern mobile = Pattern.compile("((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}");
    public static Pattern url = Pattern.compile("(http://|ftp://|https://|www|rtsp://|igmp://|file://|rtspt://|rtspu://)?[^\u4e00-\u9fbb\\s]*?\\.(com|net|cn|me|tw|fr|htm|html|php|jpg|png|asp|css|bmp|ico|js|xml|swf)[^\u4e00-\u9fbb\\s]*");

    private MsgValidator() {
    }

    public static MsgValidator getInstance() {
        return msgFilter;
    }

    private boolean isReqeateMsg(Long uid, String msg) {
        AtomicInteger count = repeateCountMap.get(uid);
        if (count != null && count.intValue() > 10) {
            return true;
        }
        if (msg.length() < 20) {
            return false;
        }
        String lastMsg = repeateMsgMap.get(uid);
        if (lastMsg == null) {
            repeateMsgMap.put(uid, msg);
            return false;
        }
        if (MsgValidator.getSimilar(msg, lastMsg) >= 0.9) {
            if (count == null) {
                count = new AtomicInteger(0);
                repeateCountMap.put(uid, count);
            }
            count.incrementAndGet();
        }
        return false;
    }

    public boolean valid(Long uid, String msg, int length) {
        if (FP.empty((CharSequence)msg) || FP.empty((CharSequence)msg.trim())) {
            return false;
        }
        if (ChannelTicketFilter.isChannelTicketMessage((CharSequence)msg) || YGroupTicketFilter.isYGroupTicketMessage((CharSequence)msg)) {
            return true;
        }
        if (LoginUtil.isLogined() && LoginUtil.getUid() == uid) {
            return true;
        }
        if (ChannelImageEmoticonFilter.isEmojiMessage((String)msg)) {
            return false;
        }
        if (MsgValidator.matchUrl(msg)) {
            return false;
        }
        if (MsgValidator.matchEmail(msg)) {
            return false;
        }
        if (MsgValidator.matchMobile(msg)) {
            return false;
        }
        for (String strFilter : ChannrlChatStrFilterList) {
            if (!MsgValidator.containChannelChatFilter(msg, strFilter)) continue;
            return false;
        }
        if (length <= 0) {
            length = 100;
        }
        return msg.length() <= length;
    }

    public static boolean matchEmail(String msg) {
        Matcher m = email.matcher(msg);
        return m.find();
    }

    public static boolean matchMobile(String msg) {
        Matcher m = mobile.matcher(msg);
        return m.find();
    }

    public static boolean matchUrl(String msg) {
        Matcher m = url.matcher(msg);
        while (m.find()) {
            if (m.group().contains("yy.com") || m.group().contains("duowan.com")) continue;
            return true;
        }
        return false;
    }

    public static String replacePunChar(String c) {
        String regex = "[\\\\pP\\\\pZ\\\\pS\\\\pM\\\\pC]";
        return c.replaceAll(regex, "");
    }

    public static double getSimilar(String content, String lastContent) {
        int ld = StringUtils.getLevenshteinDistance((String)MsgValidator.replacePunChar(content), (String)MsgValidator.replacePunChar(lastContent));
        double num = 1.0 - (double)ld / (double)Math.max(content.length(), lastContent.length());
        return num;
    }

    public static boolean containChannelChatFilter(String msg, String strFilter) {
        return msg.contains(strFilter);
    }

    public static void addStrFilter(String strFilter) {
        ChannrlChatStrFilterList.add(strFilter);
    }
}

