/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core;

import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.ANCHOROPPO;
import com.unionyy.mobile.spdt.annotation.ANCHORVIVO;
import com.unionyy.mobile.spdt.annotation.OPPO;
import com.unionyy.mobile.spdt.annotation.VIVO;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.PrefKeys;
import com.yymobile.core.media.IMediaCore;
import com.yymobile.core.media.VideoCodecType;
import com.yymobile.core.webview.BaseEnvContants;
import java.lang.reflect.InvocationTargetException;

public class BaseEnv
implements PrefKeys {
    protected static BaseEnv mEnv = BaseEnv.getInstanceFromEnv();

    private static BaseEnv getInstanceFromEnv() {
        try {
            return (BaseEnv)Class.forName("com.yymobile.core.Env").getMethod("instance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            MLog.error((Object)"BaseEnv", (String)"getInstance error", (Throwable)e2, (Object[])new Object[0]);
        }
        catch (InvocationTargetException e3) {
            MLog.error((Object)"BaseEnv", (String)"getInstance error", (Throwable)e3, (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e4) {
            MLog.error((Object)"BaseEnv", (String)"getInstance error", (Throwable)e4, (Object[])new Object[0]);
            e4.printStackTrace();
        }
        catch (ClassNotFoundException e5) {
            MLog.error((Object)"BaseEnv", (String)"getInstance error", (Throwable)e5, (Object[])new Object[0]);
        }
        return null;
    }

    public static BaseEnv instance() {
        return mEnv;
    }

    public int getMobileLiveVideoEncodePreset() {
        throw new IllegalStateException("Should init Env instance first.");
    }

    public boolean shouldUseTestEnv() {
        return BasicConfig.getInstance().isDebuggable() && BaseEnv.instance().getSvcSetting() == SvcSetting.Dev || BaseEnv.instance().getSvcSetting() == SvcSetting.Test;
    }

    public double getCameraVideoLongitude() {
        String logitudestr;
        double longitude = 113.270793;
        if (BasicConfig.getInstance().isDebuggable() && !StringUtils.isEmpty((String)(logitudestr = CommonPref.instance().getString("PRE_CAMERA_RECORD_CUSTOM_LONGITUDE"))).booleanValue()) {
            longitude = Double.valueOf(logitudestr);
        }
        return longitude;
    }

    public void setCameraVideoLongitude(double longitude) {
        if (BasicConfig.getInstance().isDebuggable()) {
            CommonPref.instance().putString("PRE_CAMERA_RECORD_CUSTOM_LONGITUDE", String.valueOf(longitude));
        }
    }

    public double getCameraVideoLatitude() {
        String latitudestr;
        double latitude = 23.135308;
        if (BasicConfig.getInstance().isDebuggable() && !StringUtils.isEmpty((String)(latitudestr = CommonPref.instance().getString("PRE_CAMERA_RECORD_CUSTOM_LATITUDE"))).booleanValue()) {
            latitude = Double.valueOf(latitudestr);
        }
        return latitude;
    }

    public void setCameraVideoLatitude(double latitude) {
        if (BasicConfig.getInstance().isDebuggable()) {
            CommonPref.instance().putString("PRE_CAMERA_RECORD_CUSTOM_LATITUDE", String.valueOf(latitude));
        }
    }

    public SvcSetting getSvcSetting() {
        int ordinal;
        if (BasicConfig.getInstance().isDebuggable() && (ordinal = CommonPref.instance().getInt("PREF_SVC_SETTING", -1)) > -1 && ordinal < SvcSetting.values().length) {
            return SvcSetting.values()[ordinal];
        }
        return SvcSetting.Product;
    }

    public SvcFlavorSetting getSvcFlavor() {
        int ordinal;
        if (BasicConfig.getInstance().isDebuggable() && (ordinal = CommonPref.instance().getInt("PREF_SVC_FLAVOR_SETTING", -1)) > -1 && ordinal < SvcFlavorSetting.values().length) {
            return SvcFlavorSetting.values()[ordinal];
        }
        if (Spdt.currentFlavor() instanceof VIVO || Spdt.currentFlavor() instanceof ANCHORVIVO) {
            return SvcFlavorSetting.VIVO;
        }
        if (Spdt.currentFlavor() instanceof OPPO || Spdt.currentFlavor() instanceof ANCHOROPPO) {
            return SvcFlavorSetting.OPPO;
        }
        return SvcFlavorSetting.YY;
    }

    public int getUdbSetting() {
        if (BasicConfig.getInstance().isDebuggable()) {
            return CommonPref.instance().getInt("PREF_UDB_SETTING", BaseEnvContants.UDB_SETTING_OPPO);
        }
        if (Spdt.currentFlavor() instanceof VIVO || Spdt.currentFlavor() instanceof ANCHORVIVO) {
            return BaseEnvContants.UDB_SETTING_VIVO;
        }
        if (Spdt.currentFlavor() instanceof OPPO || Spdt.currentFlavor() instanceof ANCHOROPPO) {
            return BaseEnvContants.UDB_SETTING_OPPO;
        }
        return BaseEnvContants.UDB_SETTING_MEIPAI;
    }

    public TurnTableSetting getTurnTableSetting() {
        int ordinal;
        if (BasicConfig.getInstance().isDebuggable() && (ordinal = CommonPref.instance().getInt("PREF_TURNTABLE_SETTING", -1)) > -1 && ordinal < TurnTableSetting.values().length) {
            return TurnTableSetting.values()[ordinal];
        }
        return TurnTableSetting.Product;
    }

    public int getMobileLiveRevolutionHeight() {
        int height = 1280;
        if (BasicConfig.getInstance().isDebuggable()) {
            height = CommonPref.instance().getInt("PRE_MOBILE_LIVE_REVOLUTION_HEIGHT", height);
        }
        return height;
    }

    public int getMobileLiveBitRateMax() {
        int bitRate = 2000;
        if (BasicConfig.getInstance().isDebuggable()) {
            bitRate = CommonPref.instance().getInt("PRE_MOBILE_LIVE_BIT_RATE_MAX", bitRate);
        }
        return bitRate;
    }

    public int getMobileLiveRevolutionWidth() {
        int width = 720;
        if (BasicConfig.getInstance().isDebuggable()) {
            width = CommonPref.instance().getInt("PRE_MOBILE_LIVE_REVOLUTION_WIDTH", width);
        }
        return width;
    }

    public int getMobileLiveFrameRate() {
        int frameRate;
        IMediaCore mediaCore = ICoreManagerBase.getMediaCore();
        int n = frameRate = mediaCore != null && mediaCore.getHardwareOrNewSoftEncoderLive() ? 24 : 20;
        if (BasicConfig.getInstance().isDebuggable()) {
            frameRate = CommonPref.instance().getInt("PRE_MOBILE_LIVE_FRAME_RATE", frameRate);
        }
        return frameRate;
    }

    public VideoCodecType getMobileLiveVideoEncoderType() {
        if (BasicConfig.getInstance().isDebuggable()) {
            VideoCodecType type = VideoCodecType.HARD_CODEC_H264;
            String strType = CommonPref.instance().getString("PREF_VIDEO_ENCODER_TYPE", VideoCodecType.HARD_CODEC_H264.name());
            try {
                type = VideoCodecType.valueOf((String)strType);
            }
            catch (IllegalArgumentException e2) {
                type = VideoCodecType.HARD_CODEC_H264;
                CommonPref.instance().putString("PREF_VIDEO_ENCODER_TYPE", type.name());
            }
            return type;
        }
        return VideoCodecType.HARD_CODEC_H264;
    }

    public static enum TurnTableSetting {
        Dev,
        Product,
        Test;

    }

    public static enum SvcFlavorSetting {
        YY,
        VIVO,
        OPPO;

    }

    public static enum SvcSetting {
        Dev,
        Product,
        Test;

    }
}

