/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.VIVO;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.utils.SpannableUtils;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkDialogListener;
import com.yymobile.baseapi.R;

public class OkDialog
implements BaseDialog {
    private CharSequence message;
    private CharSequence okLabel;
    private int okLabelColor = 0;
    private boolean isHtmlText = false;
    private boolean cancelable;
    private boolean canceledOnClickOutside;
    private OkDialogListener listener;
    private DialogInterface.OnDismissListener dismissListener;

    public OkDialog(CharSequence message, CharSequence okLabel, int okLabelColor, boolean isHtmlText, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener listener) {
        this.message = message;
        this.okLabel = okLabel;
        this.okLabelColor = okLabelColor;
        this.isHtmlText = isHtmlText;
        this.cancelable = cancelable;
        this.canceledOnClickOutside = canceledOnClickOutside;
        this.listener = listener;
    }

    public OkDialog(CharSequence message, OkDialogListener listener) {
        this(message, "", 0, false, false, false, listener);
    }

    public OkDialog(CharSequence message, boolean cancelable, OkDialogListener listener) {
        this(message, "", 0, false, cancelable, false, listener);
    }

    public OkDialog(CharSequence message, boolean cancelable, OkDialogListener listener, DialogInterface.OnDismissListener dismissListener) {
        this(message, "", 0, false, cancelable, false, listener);
        this.dismissListener = dismissListener;
    }

    public OkDialog(CharSequence message, boolean isHtmlText, boolean cancelable, OkDialogListener listener) {
        this(message, "", 0, isHtmlText, cancelable, true, listener);
    }

    public OkDialog(CharSequence message, boolean isHtmlText, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener listener) {
        this(message, "", 0, isHtmlText, cancelable, canceledOnClickOutside, listener);
    }

    public OkDialog(CharSequence message, CharSequence okLabel, int okLabelColor, boolean cancelable, OkDialogListener listener) {
        this(message, okLabel, okLabelColor, false, cancelable, cancelable, listener);
    }

    public OkDialog(CharSequence message, CharSequence okLabel, boolean cancelable, OkDialogListener listener) {
        this(message, okLabel, 0, false, cancelable, cancelable, listener);
    }

    public OkDialog(CharSequence message, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener listener, boolean isHtmlText) {
        this(message, "", 0, isHtmlText, cancelable, canceledOnClickOutside, listener);
    }

    @Override
    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.canceledOnClickOutside);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        window.setBackgroundDrawableResource(17170445);
        TextView msg = (TextView)window.findViewById(R.id.ok_dialog_message);
        if (this.isHtmlText && this.message instanceof String && !TextUtils.isEmpty((CharSequence)this.message)) {
            msg.setText((CharSequence)Html.fromHtml((String)((String)this.message)));
            msg.setMovementMethod(LinkMovementMethod.getInstance());
            SpannableUtils.setUrlSpans(msg);
        } else if (!TextUtils.isEmpty((CharSequence)this.message)) {
            msg.setText(this.message);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            ok.setTextColor(this.okLabelColor);
        }
        if (Spdt.currentFlavor() instanceof VIVO) {
            ok.setTextColor(BasicConfig.getInstance().getAppContext().getResources().getColor(R.color.vv_brand_color));
        }
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.cancel();
                if (OkDialog.this.listener != null) {
                    OkDialog.this.listener.onOk();
                }
            }
        });
        if (this.dismissListener != null) {
            dialog.setOnDismissListener(this.dismissListener);
        }
    }

    @Override
    public int getLayoutResId() {
        return R.layout.layout_ok_dialog;
    }
}

