/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicchanneltemplate.component;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.KeyEvent;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.yy.mobile.RxBus;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.event.ui.ComponentLifecycleEvent;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.ui.BackHandlerHelper;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.FragmentKeyEventHandler;
import com.yy.mobile.ui.basicchanneltemplate.component.ComponentDimension;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentContainer;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;

public abstract class Component<P extends MvpPresenter<V>, V extends MvpView>
extends BaseLinkFragment<P, V>
implements IComponent,
FragmentKeyEventHandler {
    private static final String TAG = "Component";
    private IComponentRoot mRoot;
    boolean mInitHidden;
    private ComponentDimension dimension;
    protected int mOrientation = 1;
    private boolean isComponentCreated = false;
    private IComponentContainer mParent;
    private Disposable mLifecycleDisposable = this.lifecycle().subscribe((Consumer)new Consumer<FragmentEvent>(){

        public void accept(FragmentEvent event) throws Exception {
            ComponentLifecycleEvent e2 = new ComponentLifecycleEvent((Fragment)Component.this, event);
            RxBus.getDefault().post((Object)e2);
            if (event == FragmentEvent.DETACH && Component.this.mLifecycleDisposable != null && !Component.this.mLifecycleDisposable.isDisposed()) {
                Component.this.mLifecycleDisposable.dispose();
            }
        }
    }, Functions.emptyConsumer());

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (!this.isComponentCreated) {
            this.setComponentCreated(true);
            MLog.info((Object)TAG, (String)("Component onActivityCreated className=" + this.getClass().getSimpleName()), (Object[])new Object[0]);
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (Component.this.mParent != null) {
                        Component.this.mParent.onComponentLoad(Component.this);
                    }
                }
            });
        }
    }

    @Override
    public void onStart() {
        int orientation;
        super.onStart();
        if (ICoreManagerBase.getCore(AbsChannelControllerCore.class) != null && !ICoreManagerBase.getCore(AbsChannelControllerCore.class).ignoreHorizontalScreenImp() && this.mOrientation != (orientation = ActivityUtilKt.getConfigurationsOrientation((Activity)this.getActivity()))) {
            this.mOrientation = orientation;
        }
        boolean isLandscape = this.mOrientation == 2;
        this.onOrientationChanged(isLandscape);
        this.onOrientationChanged(isLandscape, true);
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
    }

    @Override
    public IComponentContainer getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IComponentContainer parent) {
        this.mParent = parent;
    }

    @Override
    public IComponentRoot getRoot() {
        return this.mRoot;
    }

    @Override
    public void setTemplate(IComponentRoot template) {
        this.mRoot = template;
    }

    @Override
    public Fragment getContent() {
        return this;
    }

    @Override
    public boolean isInitHidden() {
        return this.mInitHidden;
    }

    @Override
    public void setInitHidden(boolean hidden) {
        this.mInitHidden = hidden;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!ICoreManagerBase.getCore(AbsChannelControllerCore.class).ignoreHorizontalScreenImp() && this.mOrientation != newConfig.orientation) {
            this.mOrientation = newConfig.orientation;
        }
        boolean isLandscape = this.mOrientation == 2;
        this.onOrientationChanged(isLandscape);
        this.onOrientationChanged(isLandscape, false);
    }

    public boolean isLandScapeMode() {
        return this.mOrientation == 2;
    }

    @Override
    public void onOrientationChanged(boolean isLandscape) {
    }

    protected void onOrientationChanged(boolean isLandscape, boolean fromStart) {
    }

    @Override
    public void showSelf() {
        if (!this.getFragmentManager().isDestroyed()) {
            this.getFragmentManager().beginTransaction().show((Fragment)this).commitAllowingStateLoss();
        }
    }

    @Override
    public void hideSelf() {
        if (!this.getFragmentManager().isDestroyed()) {
            this.getFragmentManager().beginTransaction().hide((Fragment)this).commitAllowingStateLoss();
        }
    }

    @Override
    public ComponentDimension getDimension() {
        if (this.dimension == null) {
            this.dimension = new ComponentDimension();
        }
        if (this.getView() != null) {
            this.dimension.x = this.getView().getX();
            this.dimension.y = this.getView().getY();
            this.dimension.width = this.getView().getWidth();
            this.dimension.height = this.getView().getHeight();
        }
        return this.dimension;
    }

    @Override
    public boolean isComponentCreated() {
        return this.isComponentCreated;
    }

    @Override
    public void setComponentCreated(boolean componentCreated) {
        this.isComponentCreated = componentCreated;
    }

    public int getActivityContext() {
        int context = 0;
        if (this.getContext() != null) {
            context = this.getContext().hashCode();
            MLog.info((Object)TAG, (String)("[getActivityContext] context== " + context), (Object[])new Object[0]);
        }
        return context;
    }

    @Override
    public void onDestroy() {
        this.setComponentCreated(false);
        this.mOrientation = 1;
        super.onDestroy();
    }

    @Override
    public boolean onBackPressed() {
        return BackHandlerHelper.handleBackPress((Fragment)this) || this.onHandleBackPressed();
    }

    protected boolean onHandleBackPressed() {
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }
}

