/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicchanneltemplate.component;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.ui.IDataStatus;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.common.FitLandScapeNoDataFragment;
import com.yy.mobile.ui.common.IStatusFragment;
import com.yy.mobile.ui.common.LoadingFragment;
import com.yy.mobile.ui.common.NetworkErrorFragment;
import com.yy.mobile.ui.common.NoDataFragment;
import com.yy.mobile.ui.common.NoDataFragmentWithBtn;
import com.yy.mobile.ui.common.NoMobileLiveFragment;
import com.yy.mobile.ui.common.ReloadFragment;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;

public abstract class BasePopupComponent
extends PopupComponent
implements IDataStatus {
    private static final String TAG = "BasePopupComponent";
    protected Context mContext;
    private Handler mHandler = new SafeDispatchHandler();
    private Toast mToast;
    public static final String STATUS_TAG = "STATUS_TAG";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this.getActivity();
    }

    public Context getContext() {
        return this.mContext;
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
        if (this.mToast != null) {
            this.mToast.cancel();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mContext = null;
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (savedInstanceState != null) {
            Fragment fragment = this.getChildFragmentManager().findFragmentByTag(STATUS_TAG);
            if (fragment != null && fragment instanceof NoMobileLiveFragment) {
                ((NoMobileLiveFragment)fragment).setListener(this.getNoMobileLiveDataListener());
            } else if (fragment != null && fragment instanceof IStatusFragment) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)TAG, (String)"xuwakao, onViewStateRestored re-set listener", (Object[])new Object[0]);
                }
                ((IStatusFragment)fragment).setListener(this.getLoadListener());
            }
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)TAG, (String)("xuwakao, fragment onHiddenChanged hidden = " + hidden), (Object[])new Object[0]);
        }
    }

    public View.OnClickListener getLoadListener() {
        return null;
    }

    public View.OnClickListener getLoadMoreListener() {
        return null;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return null;
    }

    public void showLoading() {
        this.showLoading(0, 0);
    }

    public void showLoading(View view) {
        this.showLoading(view, 0, 0);
    }

    public void showReload() {
        this.showReload(0, 0);
    }

    public void showLoading(int drawable2, int tips) {
        this.showLoading(this.getView(), drawable2, tips);
    }

    public void showLoading(View view, int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance((int)drawable2, (int)tips);
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showReload(int drawable2, int tips) {
        this.showReload(this.getView(), drawable2, tips);
    }

    public void showReload(View view, int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        ReloadFragment fragment = ReloadFragment.newInstance((int)drawable2, (int)tips);
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoData() {
        this.showNoData(0, 0);
    }

    public void showNoData(View view, int drawable2, CharSequence charSequence, View.OnClickListener onClickListener) {
    }

    public void showNoData(int drawable2, int tips) {
        this.showNoData(this.getView(), drawable2, tips);
    }

    public void showNoData(int drawable2, CharSequence charSequence) {
        this.showNoData(this.getView(), drawable2, charSequence);
    }

    public void showNoData(View view, int drawable2, int tips) {
        if (tips <= 0) {
            this.showNoData(view, drawable2, "");
        } else {
            this.showNoData(view, drawable2, this.getString(tips));
        }
    }

    public void showNoData(View view, int drawable2, CharSequence charSequence) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNoData view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragment fragment = NoDataFragment.newInstance((int)drawable2, (CharSequence)charSequence);
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoDataLandScape(View view, int drawable2, CharSequence charSequence) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNoData view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragment fragment = FitLandScapeNoDataFragment.newInstance(drawable2, charSequence);
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoDataWithBtn(int drawable2, String tips, String btnText, View.OnClickListener btnClickListener) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"showNoDataWithBtn view is NULL", (Object[])new Object[0]);
            return;
        }
        View view = this.getView().findViewById(R.id.status_layout);
        if (view.getId() <= 0) {
            MLog.error((Object)TAG, (String)"had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragmentWithBtn fragment = NoDataFragmentWithBtn.newInstance((int)drawable2, (CharSequence)tips);
        fragment.setBtnContent(btnText, btnClickListener);
        this.getChildFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showFragment(Fragment fragment) {
    }

    public void showNetworkErr() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNetworkErr view is NULL", (Object[])new Object[0]);
            return;
        }
        View view = this.getView().findViewById(R.id.status_layout);
        if (view.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void hideStatus() {
        Fragment fragment = this.getChildFragmentManager().findFragmentByTag(STATUS_TAG);
        if (fragment != null) {
            this.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        } else if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)TAG, (String)"xuwakao, status fragment is NULL", (Object[])new Object[0]);
        }
    }

    public void showNoMobileLiveData() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNoMobileLiveData view is NULL", (Object[])new Object[0]);
            return;
        }
        View view = this.getView().findViewById(R.id.status_layout);
        if (view.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoMobileLiveFragment fragment = NoMobileLiveFragment.newInstance();
        fragment.setListener(this.getNoMobileLiveDataListener());
        this.getChildFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showPageError(int tips) {
        this.showPageError(this.getView(), tips);
    }

    public void showPageError(View view, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View more = view.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showErrorPage(tips, this.getLoadMoreListener());
    }

    public void showPageLoading() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View more = this.getView().findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showLoadMore();
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.getActivity() == null) {
            return false;
        }
        if (this.getActivity().isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !this.getActivity().isDestroyed();
    }

    public boolean isLogined() {
        return LoginUtil.isLogined();
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext());
    }

    public boolean checkNetToast() {
        boolean falg = this.isNetworkAvailable();
        if (!falg && this.getContext() != null) {
            this.toast(R.string.str_network_not_capable, 0);
        }
        return falg;
    }

    public void toast(int resId) {
        this.toast(resId, 0);
    }

    public void toast(int resId, int length) {
        if (this.isResumed()) {
            if (this.mToast == null) {
                if (this.getContext() != null) {
                    this.mToast = Toast.makeText((Context)this.getContext(), (int)resId, (int)length);
                }
            } else {
                this.mToast = Toast.makeText((Context)this.getContext(), (int)resId, (int)length);
            }
            if (this.mToast != null) {
                this.mToast.show();
            }
        }
    }

    public void toast(String message) {
        this.toast(message, 0);
    }

    public void toast(String message, int length) {
        if (this.isResumed()) {
            if (this.mToast == null) {
                if (this.getContext() != null) {
                    this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)length);
                }
            } else {
                this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)length);
            }
            if (this.mToast != null) {
                this.mToast.show();
            }
        }
    }

    public <T> T findFragmentById(int id2, Class<T> clazz) {
        Fragment f = this.getActivity().getSupportFragmentManager().findFragmentById(id2);
        return (T)f;
    }

    public <T> T findChildFragmentById(int id2, Class<T> clazz) {
        Fragment f = this.getChildFragmentManager().findFragmentById(id2);
        return (T)f;
    }

    public <T> T findFragmentByTag(String tag, Class<T> clazz) {
        Fragment f = this.getActivity().getSupportFragmentManager().findFragmentByTag(tag);
        return (T)f;
    }

    public <T> T getActivity(Class<T> clazz) {
        FragmentActivity f = this.getActivity();
        return (T)f;
    }

    protected Handler getHandler() {
        return this.mHandler;
    }
}

