/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.KeyEvent;
import com.yy.mobile.ui.FragmentKeyEventHandler;
import java.util.List;

public class BackHandlerHelper {
    public static boolean handleBackPress(FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments == null) {
            return false;
        }
        for (int i2 = fragments.size() - 1; i2 >= 0; --i2) {
            Fragment child = (Fragment)fragments.get(i2);
            if (!BackHandlerHelper.isFragmentBackHandled(child)) continue;
            return true;
        }
        if (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStack();
            return true;
        }
        return false;
    }

    public static boolean handleBackPress(Fragment fragment) {
        return BackHandlerHelper.handleBackPress(fragment.getChildFragmentManager());
    }

    public static boolean handleBackPress(FragmentActivity fragmentActivity) {
        return BackHandlerHelper.handleBackPress(fragmentActivity.getSupportFragmentManager());
    }

    public static boolean handleBackPress(ViewPager viewPager) {
        if (viewPager == null) {
            return false;
        }
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter == null) {
            return false;
        }
        int currentItem = viewPager.getCurrentItem();
        Object fragment = adapter instanceof FragmentPagerAdapter ? ((FragmentPagerAdapter)adapter).getItem(currentItem) : (adapter instanceof FragmentStatePagerAdapter ? ((FragmentStatePagerAdapter)adapter).getItem(currentItem) : null);
        return BackHandlerHelper.isFragmentBackHandled(fragment);
    }

    public static boolean isFragmentBackHandled(Fragment fragment) {
        return fragment != null && fragment.isVisible() && fragment.getUserVisibleHint() && fragment instanceof FragmentKeyEventHandler && ((FragmentKeyEventHandler)fragment).onBackPressed();
    }

    public static boolean handleKeyDown(Fragment fragment, int keyCode, KeyEvent event) {
        return BackHandlerHelper.handleKeyDown(fragment.getChildFragmentManager(), keyCode, event);
    }

    public static boolean handleKeyDown(FragmentActivity fragmentActivity, int keyCode, KeyEvent event) {
        return BackHandlerHelper.handleKeyDown(fragmentActivity.getSupportFragmentManager(), keyCode, event);
    }

    public static boolean handleKeyDown(FragmentManager fragmentManager, int keyCode, KeyEvent event) {
        List fragments = fragmentManager.getFragments();
        if (fragments == null) {
            return false;
        }
        for (int i2 = fragments.size() - 1; i2 >= 0; --i2) {
            Fragment child = (Fragment)fragments.get(i2);
            if (!BackHandlerHelper.isFragmentKeyDownHandled(child, keyCode, event)) continue;
            return true;
        }
        return false;
    }

    public static boolean handleKeyDown(ViewPager viewPager, int keyCode, KeyEvent event) {
        if (viewPager == null) {
            return false;
        }
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter == null) {
            return false;
        }
        int currentItem = viewPager.getCurrentItem();
        Object fragment = adapter instanceof FragmentPagerAdapter ? ((FragmentPagerAdapter)adapter).getItem(currentItem) : (adapter instanceof FragmentStatePagerAdapter ? ((FragmentStatePagerAdapter)adapter).getItem(currentItem) : null);
        return BackHandlerHelper.isFragmentKeyDownHandled(fragment, keyCode, event);
    }

    public static boolean isFragmentKeyDownHandled(Fragment fragment, int keyCode, KeyEvent event) {
        return fragment != null && fragment.isVisible() && fragment.getUserVisibleHint() && fragment instanceof FragmentKeyEventHandler && ((FragmentKeyEventHandler)fragment).onKeyDown(keyCode, event);
    }
}

