/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.taskexecutor;

import android.util.Log;
import com.yy.mobile.util.pref.CommonPref;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class HardwareUtil {
    private static final String CPU_INFO_CORE_COUNT_FILE_PATH = "/sys/devices/system/cpu/";
    private static boolean sHasInitCpuCoreCount = false;
    private static int sCpuCoreCount = 1;

    public static int getCpuCoreCount() {
        if (sHasInitCpuCoreCount) {
            return sCpuCoreCount;
        }
        sCpuCoreCount = CommonPref.instance().getInt("CpuCoreCount", -1);
        if (sCpuCoreCount > 0) {
            sHasInitCpuCoreCount = true;
            return sCpuCoreCount;
        }
        try {
            File dir = new File(CPU_INFO_CORE_COUNT_FILE_PATH);
            final class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    try {
                        if (Pattern.matches("cpu[0-9]+", pathname.getName())) {
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        Log.e((String)"HardwareUtil", (String)"Empty Catch on accept", (Throwable)t);
                    }
                    return false;
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            sCpuCoreCount = files.length;
            CommonPref.instance().putInt("CpuCoreCount", sCpuCoreCount);
        }
        catch (Throwable e) {
            Log.e((String)"HardwareUtil", (String)"Empty Catch on getCpuCoreCount", (Throwable)e);
        }
        if (sCpuCoreCount < 1) {
            sCpuCoreCount = 1;
        }
        sHasInitCpuCoreCount = true;
        return sCpuCoreCount;
    }
}

