/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import com.yy.mobile.util.CloseUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J*\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\"\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J*\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007JB\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J*\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/yy/mobile/util/SandBoxCommonUtils;", "", "()V", "TAG", "", "insertAudioFile", "context", "Landroid/content/Context;", "saveFileNamePath", "description", "needDeleteLocalFile", "", "insertImageFile", "bitmap", "Landroid/graphics/Bitmap;", "title", "discription", "insertMediaFile", "uri", "Landroid/net/Uri;", "mimeType", "displayName", "insertVideoFile", "framework_release"})
public final class SandBoxCommonUtils {
    private static final String TAG = "SandBoxShareUtils";
    public static final SandBoxCommonUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final String insertImageFile(@NotNull Context context, @NotNull Bitmap bitmap, @NotNull String title, @NotNull String discription) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)discription, (String)"discription");
        return MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (Bitmap)bitmap, (String)title, (String)discription);
    }

    @JvmStatic
    @Nullable
    public static final String insertImageFile(@NotNull Context context, @NotNull String saveFileNamePath, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        return SandBoxCommonUtils.insertImageFile(context, saveFileNamePath, description, false);
    }

    @JvmStatic
    @Nullable
    public static final String insertImageFile(@NotNull Context context, @NotNull String saveFileNamePath, @NotNull String description, boolean needDeleteLocalFile) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        File file = new File(saveFileNamePath);
        Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        return SandBoxCommonUtils.insertMediaFile(uri, context, "image/jpeg", string2, description, saveFileNamePath, needDeleteLocalFile);
    }

    @JvmStatic
    @Nullable
    public static final String insertVideoFile(@NotNull Context context, @NotNull String saveFileNamePath, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        return SandBoxCommonUtils.insertVideoFile(context, saveFileNamePath, description, false);
    }

    @JvmStatic
    @Nullable
    public static final String insertVideoFile(@NotNull Context context, @NotNull String saveFileNamePath, @NotNull String description, boolean needDeleteLocalFile) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        File file = new File(saveFileNamePath);
        Uri uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"MediaStore.Video.Media.EXTERNAL_CONTENT_URI");
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        return SandBoxCommonUtils.insertMediaFile(uri, context, "video/mp4", string2, description, saveFileNamePath, needDeleteLocalFile);
    }

    @JvmStatic
    @Nullable
    public static final String insertAudioFile(@NotNull Context context, @NotNull String saveFileNamePath, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        return SandBoxCommonUtils.insertAudioFile(context, saveFileNamePath, description, false);
    }

    @JvmStatic
    @Nullable
    public static final String insertAudioFile(@NotNull Context context, @NotNull String saveFileNamePath, @NotNull String description, boolean needDeleteLocalFile) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        File file = new File(saveFileNamePath);
        Uri uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"MediaStore.Audio.Media.EXTERNAL_CONTENT_URI");
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        return SandBoxCommonUtils.insertMediaFile(uri, context, "audio/mpeg", string2, description, saveFileNamePath, needDeleteLocalFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String insertMediaFile(@NotNull Uri uri, @NotNull Context context, @NotNull String mimeType, @NotNull String displayName, @NotNull String description, @NotNull String saveFileNamePath, boolean needDeleteLocalFile) {
        File localFile;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)saveFileNamePath, (String)"saveFileNamePath");
        ContentValues values = new ContentValues();
        values.put("_display_name", displayName);
        values.put("description", description);
        values.put("mime_type", mimeType);
        Uri url = null;
        String stringUrl = null;
        ContentResolver cr = context.getContentResolver();
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            int numRead;
            url = cr.insert(uri, values);
            if (url == null) {
                String string2 = null;
                return string2;
            }
            byte[] buffer = new byte[1024];
            ParcelFileDescriptor parcelFileDescriptor = cr.openFileDescriptor(url, "w");
            inputStream = new FileInputStream(saveFileNamePath);
            ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptor;
            if (parcelFileDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            fileOutputStream = new FileOutputStream(parcelFileDescriptor2.getFileDescriptor());
            while ((numRead = inputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, numRead);
            }
            fileOutputStream.flush();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "Failed to insert media file: " + e, new Object[0]);
            if (url != null) {
                cr.delete(url, null, null);
                url = null;
            }
        }
        finally {
            CloseUtils.safeClose(fileOutputStream);
            CloseUtils.safeClose(inputStream);
        }
        if (needDeleteLocalFile && (localFile = new File(saveFileNamePath)).exists()) {
            localFile.delete();
        }
        if (url != null) {
            stringUrl = url.toString();
        }
        return stringUrl;
    }

    private SandBoxCommonUtils() {
    }

    static {
        SandBoxCommonUtils sandBoxCommonUtils;
        INSTANCE = sandBoxCommonUtils = new SandBoxCommonUtils();
    }
}

