/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class CollectionsHelper {
    public static boolean isNullOrEmpty(Collection<?> list) {
        return list == null || list.size() == 0;
    }

    public static <T> boolean isNullOrEmpty(T ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(int ... args) {
        return args == null || args.length == 0;
    }

    public static boolean hasData(Collection<?> list) {
        return !CollectionsHelper.isNullOrEmpty(list);
    }

    public static <T> boolean hasData(T ... array) {
        return !CollectionsHelper.isNullOrEmpty(array);
    }

    public static boolean haveAtLeastOneNull(Object ... args) {
        for (Object e : args) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    public static <T> ArrayList<T> cloneList(List<T> src) {
        ArrayList<T> ret = new ArrayList<T>();
        if (src == null) {
            return ret;
        }
        for (T e : src) {
            ret.add(e);
        }
        return ret;
    }

    public static <T> ArrayList<T> getUniques(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        ArrayList<T> newList = new ArrayList<T>();
        for (T element : list) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    public static <T> T firstValid(List<T> list, T defaultValue) {
        if (CollectionsHelper.isNullOrEmpty(list)) {
            return defaultValue;
        }
        for (T e : list) {
            if (e == null) continue;
            return e;
        }
        return defaultValue;
    }

    public static <T> T firstValue(T defaultValue, T ... args) {
        if (CollectionsHelper.isNullOrEmpty(args)) {
            return defaultValue;
        }
        return args[0];
    }

    public static int firstValue(int defaultValue, int ... args) {
        if (CollectionsHelper.isNullOrEmpty(args)) {
            return defaultValue;
        }
        return args[0];
    }

    public static <T> boolean equal(List<T> l1, List<T> l2, Comparator<T> comparator) {
        int n2;
        if (CollectionsHelper.isNullOrEmpty(l1)) {
            return CollectionsHelper.isNullOrEmpty(l2);
        }
        if (CollectionsHelper.isNullOrEmpty(l2)) {
            return CollectionsHelper.isNullOrEmpty(l1);
        }
        int n1 = l1.size();
        if (n1 != (n2 = l2.size())) {
            return false;
        }
        if (comparator == null) {
            for (int i = 0; i < n1; ++i) {
                T e1 = l1.get(i);
                T e2 = l2.get(i);
                if (e1 == null) {
                    if (e2 == null) continue;
                    return false;
                }
                if (e1 != null && !e1.equals(e2)) continue;
            }
        } else {
            for (int i = 0; i < n1; ++i) {
                T e2;
                T e1 = l1.get(i);
                if (comparator.compare(e1, e2 = l2.get(i)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> boolean containsRef(T[] array, T dest) {
        if (CollectionsHelper.isNullOrEmpty(array)) {
            return false;
        }
        for (T e : array) {
            if (e != dest) continue;
            return true;
        }
        return false;
    }
}

