/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photoView;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.View;
import android.widget.ImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.ui.widget.photoView.IPhotoView;
import com.yy.mobile.ui.widget.photoView.PhotoViewAttacher;

public class PhotoView
extends RecycleImageView
implements IPhotoView {
    private final PhotoViewAttacher mAttacher;
    private ImageView.ScaleType mPendingScaleType;
    private OnImageDrawableListener mImageDrawableListener;

    public PhotoView(Context context) {
        this(context, null);
    }

    public PhotoView(Context context, AttributeSet attr2) {
        this(context, attr2, 0);
    }

    public PhotoView(Context context, AttributeSet attr2, int defStyle) {
        super(context, attr2, defStyle);
        super.setScaleType(ImageView.ScaleType.MATRIX);
        this.mAttacher = new PhotoViewAttacher((ImageView)this);
        if (null != this.mPendingScaleType) {
            this.setScaleType(this.mPendingScaleType);
            this.mPendingScaleType = null;
        }
    }

    @Override
    public void setPhotoViewRotation(float rotationDegree) {
        this.mAttacher.setRotationTo(rotationDegree);
    }

    @Override
    public void setRotationTo(float rotationDegree) {
        this.mAttacher.setRotationTo(rotationDegree);
    }

    @Override
    public void setRotationBy(float rotationDegree) {
        this.mAttacher.setRotationBy(rotationDegree);
    }

    @Override
    public boolean canZoom() {
        return this.mAttacher.canZoom();
    }

    @Override
    public RectF getDisplayRect() {
        return this.mAttacher.getDisplayRect();
    }

    @Override
    public Matrix getDisplayMatrix() {
        return this.mAttacher.getDrawMatrix();
    }

    @Override
    public boolean setDisplayMatrix(Matrix finalRectangle) {
        return this.mAttacher.setDisplayMatrix(finalRectangle);
    }

    @Override
    @Deprecated
    public float getMinScale() {
        return this.getMinimumScale();
    }

    @Override
    public float getMinimumScale() {
        return this.mAttacher.getMinimumScale();
    }

    @Override
    @Deprecated
    public float getMidScale() {
        return this.getMediumScale();
    }

    @Override
    public float getMediumScale() {
        return this.mAttacher.getMediumScale();
    }

    @Override
    @Deprecated
    public float getMaxScale() {
        return this.getMaximumScale();
    }

    @Override
    public float getMaximumScale() {
        return this.mAttacher.getMaximumScale();
    }

    @Override
    public float getScale() {
        return this.mAttacher.getScale();
    }

    @Override
    public ImageView.ScaleType getScaleType() {
        return this.mAttacher.getScaleType();
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAttacher.setAllowParentInterceptOnEdge(allow);
    }

    @Override
    @Deprecated
    public void setMinScale(float minScale) {
        this.setMinimumScale(minScale);
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        this.mAttacher.setMinimumScale(minimumScale);
    }

    @Override
    @Deprecated
    public void setMidScale(float midScale) {
        this.setMediumScale(midScale);
    }

    @Override
    public void setMediumScale(float mediumScale) {
        this.mAttacher.setMediumScale(mediumScale);
    }

    @Override
    @Deprecated
    public void setMaxScale(float maxScale) {
        this.setMaximumScale(maxScale);
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        this.mAttacher.setMaximumScale(maximumScale);
    }

    public void setImageDrawableListener(OnImageDrawableListener listener) {
        this.mImageDrawableListener = listener;
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (null != this.mAttacher) {
            this.mAttacher.update();
        }
        if (null != this.mImageDrawableListener) {
            this.mImageDrawableListener.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setImageResource(int resId) {
        super.setImageResource(resId);
        if (null != this.mAttacher) {
            this.mAttacher.update();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        if (null != this.mAttacher) {
            this.mAttacher.update();
        }
    }

    @Override
    public void setOnMatrixChangeListener(PhotoViewAttacher.OnMatrixChangedListener listener) {
        this.mAttacher.setOnMatrixChangeListener(listener);
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener l) {
        this.mAttacher.setOnLongClickListener(l);
    }

    @Override
    public void setOnPhotoTapListener(PhotoViewAttacher.OnPhotoTapListener listener) {
        this.mAttacher.setOnPhotoTapListener(listener);
    }

    @Override
    public PhotoViewAttacher.OnPhotoTapListener getOnPhotoTapListener() {
        return this.mAttacher.getOnPhotoTapListener();
    }

    @Override
    public void setOnViewTapListener(PhotoViewAttacher.OnViewTapListener listener) {
        this.mAttacher.setOnViewTapListener(listener);
    }

    @Override
    public PhotoViewAttacher.OnViewTapListener getOnViewTapListener() {
        return this.mAttacher.getOnViewTapListener();
    }

    @Override
    public void setScale(float scale) {
        this.mAttacher.setScale(scale);
    }

    @Override
    public void setScale(float scale, boolean animate) {
        this.mAttacher.setScale(scale, animate);
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        this.mAttacher.setScale(scale, focalX, focalY, animate);
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        if (null != this.mAttacher) {
            this.mAttacher.setScaleType(scaleType);
        } else {
            this.mPendingScaleType = scaleType;
        }
    }

    @Override
    public void setZoomable(boolean zoomable) {
        this.mAttacher.setZoomable(zoomable);
    }

    @Override
    public Bitmap getVisibleRectangleBitmap() {
        return this.mAttacher.getVisibleRectangleBitmap();
    }

    @Override
    public void setZoomTransitionDuration(int milliseconds) {
        this.mAttacher.setZoomTransitionDuration(milliseconds);
    }

    @Override
    public IPhotoView getIPhotoViewImplementation() {
        return this.mAttacher;
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        this.mAttacher.setOnDoubleTapListener(newOnDoubleTapListener);
    }

    @Override
    protected void onDetachedFromWindow() {
        this.mAttacher.cleanup();
        super.onDetachedFromWindow();
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return true;
    }

    public static interface OnImageDrawableListener {
        public void setImageDrawable(Drawable var1);
    }
}

