/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.keyboard;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.utils.SoftKeyboardStateHelper;
import com.yy.mobile.ui.widget.keyboard.BaseKeyboardView;
import com.yy.mobile.ui.widget.listenkeyboard.KeyboardStateListener;
import com.yy.mobile.ui.widget.listenkeyboard.ListenIntoKeyboardShowOrHideRelativeLayout;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.log.MLog;

public class KeyboardSelectLayout
extends RelativeLayout {
    private boolean mKeyboardVisiable = false;
    private SoftKeyboardStateHelper mSoftKeyboardStateHelper;
    private View mFocusView;
    private OnKeyboardListener mListener;
    private OnKeyboardAction mAction = new DefaultAction();
    private BaseKeyboardView mKeyboardView;
    private int mKeyHeight = 0;

    public KeyboardSelectLayout(Context context, View focusView) {
        super(context);
        this.mFocusView = focusView;
        this.init();
    }

    public KeyboardSelectLayout(Context context) {
        super(context);
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_keyboard_select, (ViewGroup)this);
        ((ListenIntoKeyboardShowOrHideRelativeLayout)this.findViewById(R.id.layout_keyboard)).setKeyboardStateListener(new KeyboardStateListener(){

            @Override
            public void stateChange(boolean isKeyboardVisiable) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug("KeyboardSelectLayout", "->stateChange isKeyboardVisiable=" + isKeyboardVisiable + ",current keyboardVisiable=" + KeyboardSelectLayout.this.mKeyboardVisiable, new Object[0]);
                }
                if (KeyboardSelectLayout.this.mKeyboardVisiable != isKeyboardVisiable) {
                    KeyboardSelectLayout.this.mKeyboardVisiable = isKeyboardVisiable;
                    if (!KeyboardSelectLayout.this.mKeyboardVisiable) {
                        ImeUtil.hideIME((Activity)KeyboardSelectLayout.this.getContext());
                        KeyboardSelectLayout.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                KeyboardSelectLayout.this.doCloseKeyboard();
                            }
                        });
                    } else {
                        KeyboardSelectLayout.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                KeyboardSelectLayout.this.doSelectComponentShow();
                            }
                        });
                    }
                }
            }
        });
        if (this.mFocusView != null) {
            this.mFocusView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug("KeyboardSelectLayout", "->focus keyboardVisiable=" + KeyboardSelectLayout.this.mKeyboardVisiable, new Object[0]);
                    }
                    if (KeyboardSelectLayout.this.mListener != null && KeyboardSelectLayout.this.mFocusView != null) {
                        KeyboardSelectLayout.this.mListener.onFocus(v, hasFocus);
                    }
                    if (KeyboardSelectLayout.this.mKeyboardVisiable) {
                        KeyboardSelectLayout.this.doSelectComponentShow();
                    }
                }
            });
        }
        this.mSoftKeyboardStateHelper = new SoftKeyboardStateHelper(this.findViewById(R.id.layout_keyboard).getRootView());
        this.mSoftKeyboardStateHelper.addSoftKeyboardStateListener(new SoftKeyboardStateHelper.SoftKeyboardStateListener(){

            @Override
            public void onSoftKeyboardOpened(int keyboardHeightInPx) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug("KeyboardSelectLayout", "->open keyboardVisiable=" + KeyboardSelectLayout.this.mKeyboardVisiable, new Object[0]);
                }
                KeyboardSelectLayout.this.mKeyboardVisiable = true;
                KeyboardSelectLayout.this.mKeyHeight = keyboardHeightInPx;
                KeyboardSelectLayout.this.doSelectComponentShow();
            }

            @Override
            public void onSoftKeyboardClosed() {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug("KeyboardSelectLayout", "->close keyboardVisiable=" + KeyboardSelectLayout.this.mKeyboardVisiable, new Object[0]);
                }
                KeyboardSelectLayout.this.doCloseKeyboard();
            }
        });
    }

    private void doCloseKeyboard() {
        if (this.mFocusView != null) {
            this.mFocusView.clearFocus();
        }
        this.doKeyboardAction(false);
        this.dispatchKeyboardEvent(false);
        if (this.mKeyboardView != null) {
            this.mKeyboardView.onKeyboardHide();
        }
    }

    public void addKeyboardView(BaseKeyboardView view) {
        this.mKeyboardView = view;
        this.mKeyboardView.setVisibility(8);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.addView((View)view, (ViewGroup.LayoutParams)params);
    }

    private void doSelectComponentShow() {
        if (this.mAction != null) {
            this.mAction.onFocus(this.mFocusView, (View)this.mKeyboardView, this.mKeyHeight);
        }
        if (this.mKeyboardView != null) {
            this.mKeyboardView.onFoucsChange((View)this);
        }
        if (this.mFocusView == null || this.mFocusView == this.getRootView().findFocus()) {
            this.dispatchKeyboardEvent(true);
        }
    }

    private boolean isLandScape() {
        return this.getResources().getConfiguration().orientation == 2;
    }

    public void setKeyboardAction(OnKeyboardAction action) {
        this.mAction = action;
    }

    private void doKeyboardAction(boolean isVisible) {
        if (this.mAction != null) {
            if (isVisible) {
                this.mAction.onShow((View)this.mKeyboardView);
            } else {
                this.mAction.onHide((View)this.mKeyboardView);
            }
        }
    }

    private void dispatchKeyboardEvent(boolean isVisible) {
        if (this.mListener != null) {
            this.mListener.onVisible(isVisible);
        }
    }

    public void setOnKeyboardListener(OnKeyboardListener listener) {
        this.mListener = listener;
    }

    private static class DefaultAction
    implements OnKeyboardAction {
        private DefaultAction() {
        }

        @Override
        public void onShow(View view) {
            if (view != null) {
                view.setVisibility(0);
            }
        }

        @Override
        public void onHide(View view) {
            if (view != null) {
                view.setVisibility(8);
            }
        }

        @Override
        public void onFocus(View focusView, View view, int keyHeight) {
            if (focusView == null || view != null && view.getRootView() != null && focusView == view.getRootView().findFocus()) {
                if (view != null) {
                    view.setVisibility(0);
                    if (focusView.getResources().getConfiguration().orientation == 2) {
                        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
                        layoutParams.bottomMargin = keyHeight;
                        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    } else {
                        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
                        layoutParams.bottomMargin = 0;
                        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                }
            } else if (view != null) {
                view.setVisibility(8);
            }
        }
    }

    public static interface OnKeyboardAction {
        public void onShow(View var1);

        public void onHide(View var1);

        public void onFocus(View var1, View var2, int var3);
    }

    public static interface OnKeyboardListener {
        public void onVisible(boolean var1);

        public void onFocus(View var1, boolean var2);
    }
}

