/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.stuckminor;

import android.content.Context;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.stuckminor.base.IANRListener;
import com.yy.mobile.stuckminor.base.ILooperMonitor;
import com.yy.mobile.stuckminor.base.IMsgListener;
import com.yy.mobile.stuckminor.loopermintor.LooperMonitor;

public class LooperMonitorUtil {
    private static final long ANR_TIME_OUT = 5000L;
    private static final ThreadLocal<ILooperMonitor> sThreadLocal = new ThreadLocal();
    private static final int TYPE_BASE_ANALYZER = 0;

    private static ILooperMonitor getInstance() {
        return LooperMonitorUtil.getInstance(0);
    }

    private static ILooperMonitor getInstance(int type) {
        switch (type) {
            case 0: {
                ILooperMonitor looperMonitor = sThreadLocal.get();
                if (looperMonitor == null) {
                    looperMonitor = new LooperMonitor();
                    sThreadLocal.set(looperMonitor);
                }
                return looperMonitor;
            }
        }
        return null;
    }

    public static void setMsgListener(IMsgListener msgListener) {
        ILooperMonitor looperMonitor = sThreadLocal.get();
        if (looperMonitor == null) {
            return;
        }
        looperMonitor.setMsgListener(msgListener);
    }

    public static void setAnrListener(IANRListener anrListener) {
        ILooperMonitor looperMonitor = sThreadLocal.get();
        if (looperMonitor == null) {
            return;
        }
        looperMonitor.setANRListener(BasicConfig.getInstance().getAppContext(), anrListener, 5000L, Thread.currentThread());
    }

    public static void start(Context ctx, IANRListener anrListener, IMsgListener msgListener) {
        ILooperMonitor looperMonitor = LooperMonitorUtil.getInstance();
        looperMonitor.setANRListener(ctx, anrListener, 5000L, Thread.currentThread());
        looperMonitor.setMsgListener(msgListener);
        looperMonitor.start();
    }

    public static void stop() {
        ILooperMonitor looperMonitor = sThreadLocal.get();
        if (looperMonitor == null) {
            return;
        }
        looperMonitor.stop();
        sThreadLocal.remove();
    }

    public static void pause() {
        ILooperMonitor looperMonitor = sThreadLocal.get();
        if (looperMonitor == null) {
            return;
        }
        looperMonitor.stop();
    }
}

