/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid.player;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.View;
import com.yy.y2aplayerandroid.log.Y2ALoggers;
import com.yy.y2aplayerandroid.player.IY2AGLView;
import com.yy.y2aplayerandroid.player.IY2AGLViewRenderer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class Y2AGLSurfaceView
extends GLSurfaceView
implements IY2AGLView,
GLSurfaceView.Renderer {
    private static final String TAG = Y2AGLSurfaceView.class.getSimpleName();
    private int mPlayerUID = 0;
    private IY2AGLViewRenderer mViewRenderer;
    private ArrayList<Runnable> mCacheEventQueue = new ArrayList();
    private boolean mIsInited = false;

    public Y2AGLSurfaceView(Context context) {
        super(context);
        this.initView();
    }

    public Y2AGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    protected void initView() {
        this.setEGLContextClientVersion(2);
        this.setFocusableInTouchMode(false);
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(new ConfigChooser(8, 8, 8, 8, 16, 0));
        this.getHolder().setFormat(-3);
        this.setRenderer(this);
        this.setZOrderOnTop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void glQueueEvent(Runnable r) {
        this.onResume();
        if (this.mIsInited) {
            this.queueEvent(r);
        } else {
            Y2AGLSurfaceView y2AGLSurfaceView = this;
            synchronized (y2AGLSurfaceView) {
                this.mCacheEventQueue.add(r);
            }
        }
    }

    @Override
    public void setGlViewRenderer(IY2AGLViewRenderer viewRenderer) {
        this.mViewRenderer = viewRenderer;
    }

    @Override
    public View getGlView() {
        return this;
    }

    @Override
    public void setGlZOrderOnTop(boolean onTop) {
        this.setZOrderOnTop(onTop);
    }

    @Override
    public void glPause() {
        this.onPause();
    }

    @Override
    public void glResume() {
        this.onResume();
    }

    @Override
    public void setPlayerUID(int playerUID) {
        this.mPlayerUID = playerUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Y2ALoggers.i(TAG, this.mPlayerUID + " xlb surfaceView onSurfaceCreated: ");
        if (this.mViewRenderer != null) {
            this.mViewRenderer.onInnerSurfaceCreated();
        }
        this.mIsInited = true;
        Y2AGLSurfaceView y2AGLSurfaceView = this;
        synchronized (y2AGLSurfaceView) {
            for (Runnable event : this.mCacheEventQueue) {
                this.queueEvent(event);
            }
            this.mCacheEventQueue.clear();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Y2ALoggers.i(TAG, this.mPlayerUID + " xlb surfaceView onSurfaceChanged width:" + width + ", height:" + height);
        if (this.mViewRenderer != null) {
            this.mViewRenderer.onInnerSurfaceChanged(width, height);
        }
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mViewRenderer != null) {
            this.mViewRenderer.onInnerDrawFrame();
        }
    }

    public void onResume() {
        super.onResume();
        this.setRenderMode(1);
    }

    public void onPause() {
        super.onPause();
        this.setRenderMode(0);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] configAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12338, 1, 12337, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize = 0;
        protected int mGreenSize = 0;
        protected int mBlueSize = 0;
        protected int mAlphaSize = 0;
        protected int mDepthSize = 0;
        protected int mStencilSize = 0;
        private int[] mValue = new int[1];

        public ConfigChooser(int red, int green, int blue, int alpha, int depth, int stencil) {
            this.mRedSize = red;
            this.mGreenSize = green;
            this.mBlueSize = blue;
            this.mAlphaSize = alpha;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, configAttribs, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                Y2ALoggers.e(TAG, "y2aplayer No configs match configSpec");
                return null;
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, configAttribs, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int depth = this.findConfigAttrib(egl, display, config, 12325, 0);
                int stencil = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (depth < this.mDepthSize || stencil < this.mStencilSize) continue;
                int red = this.findConfigAttrib(egl, display, config, 12324, 0);
                int green = this.findConfigAttrib(egl, display, config, 12323, 0);
                int blue = this.findConfigAttrib(egl, display, config, 12322, 0);
                int alpha = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (red != this.mRedSize || green != this.mGreenSize || blue != this.mBlueSize || alpha != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }
}

