/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid.player;

import android.graphics.Bitmap;

public class Y2APlayerInner {
    private static final String TAG = Y2APlayerInner.class.getSimpleName();
    private long mNativeID = 0L;

    public long getNativeID() {
        return this.mNativeID;
    }

    public void resetNativeID() {
        this.mNativeID = 0L;
    }

    public long innerNativeLoad(String filename) {
        this.mNativeID = Y2APlayerInner.nativeLoad(filename);
        return this.mNativeID;
    }

    public int innerNativePlay(float speed, int loopCount) {
        return Y2APlayerInner.nativePlay(speed, loopCount, this.mNativeID);
    }

    public void innerNativePause(boolean isPause) {
        Y2APlayerInner.nativePause(isPause, this.mNativeID);
    }

    public void innerNativeStop() {
        Y2APlayerInner.nativeStop(this.mNativeID);
    }

    public void innerNativeResize(int width, int height) {
        Y2APlayerInner.nativeResize(width, height, this.mNativeID);
    }

    public void innerNativeRender() {
        Y2APlayerInner.nativeRender(this.mNativeID);
    }

    public int innerNativeGetFPS() {
        return Y2APlayerInner.nativeGetFPS(this.mNativeID);
    }

    public boolean innerNativeIsStopped() {
        return Y2APlayerInner.nativeIsStopped(this.mNativeID);
    }

    public long innerNativeGetSize() {
        return Y2APlayerInner.nativeGetSize(this.mNativeID);
    }

    public int innerNativeGetFrameIndex() {
        return Y2APlayerInner.nativeGetFrameIndex(this.mNativeID);
    }

    public void innerNativeSetImageForSprite(String imageKey, String imagePath) {
        Y2APlayerInner.nativeSetImageForSprite(imageKey, imagePath, this.mNativeID);
    }

    public void innerNativeClearImageForSprite(String imageKey) {
        Y2APlayerInner.nativeClearImageForSprite(imageKey, this.mNativeID);
    }

    public void innerNativeSetTextForSprite(String imageKey, String ttfFilePath, String text, int fontSize, float red, float green, float blue, float alpha) {
        Y2APlayerInner.nativeSetTextForSprite(imageKey, ttfFilePath, text, fontSize, red, green, blue, alpha, this.mNativeID);
    }

    public void innerNativeSetTextImageForSprite(String imageKey, Bitmap bitmap) {
        Y2APlayerInner.nativeSetTextImageForSprite(imageKey, bitmap, this.mNativeID);
    }

    public void innerNativeClearTextForSprite(String imageKey) {
        Y2APlayerInner.nativeClearTextForSprite(imageKey, this.mNativeID);
    }

    public void innerNativeSetFLipX(boolean isFlip) {
        Y2APlayerInner.nativeSetFLipX(isFlip, this.mNativeID);
    }

    public void innerNativeSetFLipY(boolean isFlip) {
        Y2APlayerInner.nativeSetFLipY(isFlip, this.mNativeID);
    }

    public void innerNativeSetOffset(float offsetX, float offsetY) {
        Y2APlayerInner.nativeSetOffset(offsetX, offsetY, this.mNativeID);
    }

    public void innerNativeResourceRecycle() {
        Y2APlayerInner.nativeResourceRecycle();
    }

    public void innerNativeDestroy() {
        if (this.mNativeID != 0L) {
            Y2APlayerInner.nativeDestroy(this.mNativeID);
        }
    }

    private static native long nativeLoad(String var0);

    private static native int nativePlay(float var0, int var1, long var2);

    private static native void nativePause(boolean var0, long var1);

    private static native void nativeStop(long var0);

    private static native void nativeResize(int var0, int var1, long var2);

    private static native void nativeRender(long var0);

    private static native int nativeGetFPS(long var0);

    private static native boolean nativeIsStopped(long var0);

    private static native long nativeGetSize(long var0);

    private static native int nativeGetFrameIndex(long var0);

    private static native void nativeSetImageForSprite(String var0, String var1, long var2);

    private static native void nativeClearImageForSprite(String var0, long var1);

    private static native void nativeSetTextForSprite(String var0, String var1, String var2, int var3, float var4, float var5, float var6, float var7, long var8);

    private static native void nativeSetTextImageForSprite(String var0, Bitmap var1, long var2);

    private static native void nativeClearTextForSprite(String var0, long var1);

    private static native void nativeSetFLipX(boolean var0, long var1);

    private static native void nativeSetFLipY(boolean var0, long var1);

    private static native void nativeSetOffset(float var0, float var1, long var2);

    private static native void nativeResourceRecycle();

    private static native void nativeDestroy(long var0);

    public static class PlayParams {
        public float mSpeed;
        public int mLoopCount;

        public PlayParams(float speed, int loopCount) {
            this.mSpeed = speed;
            this.mLoopCount = loopCount;
        }
    }

    public static class TextSpriteParams {
        public String mImageKey;
        public String mTtfFilePath;
        public String mText;
        public int mFontSize;
        public float mRed;
        public float mGreen;
        public float mBlue;
        public float mAlpha;

        public TextSpriteParams(String imageKey, String ttfFilePath, String text, int fontSize, float red, float green, float blue, float alpha) {
            this.mImageKey = imageKey;
            this.mTtfFilePath = ttfFilePath;
            this.mText = text;
            this.mFontSize = fontSize;
            this.mRed = red;
            this.mGreen = green;
            this.mBlue = blue;
            this.mAlpha = alpha;
        }
    }

    public static class ImageSpriteParams {
        public String mImageKey;
        public String mImagePath;

        public ImageSpriteParams(String imageKey, String imagePath) {
            this.mImageKey = imageKey;
            this.mImagePath = imagePath;
        }
    }

    public static class OffsetParams {
        public float mOffsetX;
        public float mOffsetY;

        public OffsetParams(float offsetX, float offsetY) {
            this.mOffsetX = offsetX;
            this.mOffsetY = offsetY;
        }
    }
}

