/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.media.SoundPool;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.JsonReader;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.y2aplayerandroid.Y2APlayerListener;
import com.yy.y2aplayerandroid.log.Y2ALog;
import com.yy.y2aplayerandroid.log.Y2ALoggers;
import com.yy.y2aplayerandroid.player.IY2AGLView;
import com.yy.y2aplayerandroid.player.IY2AGLViewRenderer;
import com.yy.y2aplayerandroid.player.Y2AAudioItem;
import com.yy.y2aplayerandroid.player.Y2AConfig;
import com.yy.y2aplayerandroid.player.Y2AGLSurfaceView;
import com.yy.y2aplayerandroid.player.Y2AGLTextureView;
import com.yy.y2aplayerandroid.player.Y2APlayerInner;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class Y2APlayer
extends FrameLayout
implements IY2AGLViewRenderer {
    private static final String TAG = Y2APlayer.class.getSimpleName();
    protected static final int sRecyclePeriod = 1000;
    private int mPlayerUID = this.hashCode();
    private Context mContext = null;
    private Y2APlayerInner mNativePlayer = null;
    private Y2APlayerListener mListener = null;
    private IY2AGLView mY2AGLView = null;
    private boolean mIsPlaying = false;
    private int mWidth = 0;
    private int mHeight = 0;
    private Rect mVisiableRect = new Rect();
    protected long mLastRecycleTime = 0L;
    private Point mAnimSizer = new Point(0, 0);
    protected int mDurationTime = 0;
    private long mSleepTime = 0L;
    private long mFrameTime = 0L;
    private long mLastTime = 0L;
    protected static final int sEventTick = 33;
    protected static final int sMiniSleepTick = 16;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    private SoundPool mSoundPool = null;
    private List<Y2AAudioItem> mAudioItems = new ArrayList<Y2AAudioItem>();
    private int mFrameIndex = -1;
    private int mAudioLoaded = 0;

    public Y2APlayer(Context context) {
        super(context);
        this.initAttributes(context);
    }

    public Y2APlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context);
    }

    public Y2APlayer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttributes(context);
    }

    public Rect getVisableRect() {
        return this.mVisiableRect;
    }

    public void setListener(Y2APlayerListener listener) {
        this.mListener = listener;
    }

    public void close() {
        this.mListener = null;
    }

    public void load(final String filename) {
        Y2ALoggers.i(TAG, this.mPlayerUID + " a2m load filename:" + filename);
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doLoad(filename);
            }
        });
    }

    public void setGlZOrderOnTop(boolean onTop) {
        this.mY2AGLView.setGlZOrderOnTop(onTop);
    }

    public void play(final float speed, final int loopCount) {
        Y2ALoggers.i(TAG, this.mPlayerUID + " a2m play");
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayerInner.PlayParams params = new Y2APlayerInner.PlayParams(speed, loopCount);
                Y2APlayer.this.doPlay(params);
            }
        });
    }

    public void pause(final boolean isPaused) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doPause(isPaused ? 1 : 0);
            }
        });
    }

    public void stop() {
        if (this.mIsPlaying) {
            this.mY2AGLView.glQueueEvent(new Runnable(){

                @Override
                public void run() {
                    Y2APlayer.this.doStop();
                }
            });
            this.mIsPlaying = false;
        }
    }

    public void setBottomMargin(final int margin) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayerInner.OffsetParams params = new Y2APlayerInner.OffsetParams(0.0f, margin);
                Y2APlayer.this.doSetOffset(params);
            }
        });
    }

    public void setOffset(final float offsetX, final float offsetY) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayerInner.OffsetParams params = new Y2APlayerInner.OffsetParams(offsetX, offsetY);
                Y2APlayer.this.doSetOffset(params);
            }
        });
    }

    public void setImageForSptire(final String imageKey, final String imagePath) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayerInner.ImageSpriteParams params = new Y2APlayerInner.ImageSpriteParams(imageKey, imagePath);
                Y2APlayer.this.doSetImageForSprite(params);
            }
        });
    }

    public void clearImageForSprite(final String imageKey) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doClearImageSprite(imageKey);
            }
        });
    }

    public void setTextForSprite(final String imageKey, final String ttfFilePath, final String text, final int fontSize, final float red, final float green, final float blue, final float alpha) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayerInner.TextSpriteParams params = new Y2APlayerInner.TextSpriteParams(imageKey, ttfFilePath, text, fontSize, red, green, blue, alpha);
                Y2APlayer.this.doSetTextForSprite(params);
            }
        });
    }

    public void setTextForSprite(final String imageKey, final StaticLayout layout) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doSetTextForSprite(imageKey, layout);
            }
        });
    }

    public void setTextForSprite(String imageKey, String text, TextPaint paint) {
        int width = (int)Math.ceil(paint.measureText(text));
        this.setTextForSprite(imageKey, new StaticLayout((CharSequence)text, 0, text.length(), paint, width, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false));
    }

    public void clearTextForSprite(final String imageKey) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doClearTextSprite(imageKey);
            }
        });
    }

    public void setFlipX(final boolean isFlip) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doSetFlipX(isFlip ? 1 : 0);
            }
        });
    }

    public void setFlipY(final boolean isFlip) {
        this.mY2AGLView.glQueueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doSetFlipY(isFlip ? 1 : 0);
            }
        });
    }

    @Override
    public void onInnerSurfaceCreated() {
    }

    @Override
    public void onInnerSurfaceChanged(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.mNativePlayer.innerNativeResize(width, height);
        this.updateViewRect();
    }

    @Override
    public void onInnerDrawFrame() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glDisable((int)2929);
        GLES20.glClear((int)16384);
        if (this.mNativePlayer.getNativeID() == 0L) {
            return;
        }
        this.mNativePlayer.innerNativeRender();
        int currFrameIndex = this.mNativePlayer.innerNativeGetFrameIndex();
        if (currFrameIndex >= 0 && this.mFrameIndex != currFrameIndex) {
            if (this.mFrameIndex > 0 && this.mFrameIndex > currFrameIndex && this.mSoundPool != null && this.mAudioItems.size() > 0) {
                for (Y2AAudioItem item : this.mAudioItems) {
                    item.stop(this.mSoundPool);
                }
            }
            this.mFrameIndex = currFrameIndex;
            if (this.mSoundPool != null && this.mAudioItems.size() > 0) {
                for (Y2AAudioItem item : this.mAudioItems) {
                    item.update(this.mSoundPool, this.mFrameIndex);
                }
            }
        }
        if (this.mNativePlayer.innerNativeIsStopped() && this.mIsPlaying) {
            this.doStop();
            this.mIsPlaying = false;
            return;
        }
        if (this.mLastTime != 0L) {
            this.mFrameTime = System.currentTimeMillis() - this.mLastTime;
            this.mSleepTime = (long)this.mDurationTime > this.mFrameTime ? (long)this.mDurationTime - this.mFrameTime : 0L;
        } else {
            this.mSleepTime = 0L;
        }
        if (this.mSleepTime > 0L) {
            try {
                Thread.sleep(this.mSleepTime);
            }
            catch (InterruptedException e) {
                this.resourceRecycle(this.mLastTime);
                return;
            }
        }
        this.mLastTime = System.currentTimeMillis();
        this.resourceRecycle(this.mLastTime);
    }

    @Override
    public void onInnerCleanup() {
        this.doStop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void resourceRecycle(long currentMS) {
        if (this.mLastRecycleTime != 0L) {
            if (currentMS - this.mLastRecycleTime >= 1000L) {
                this.mNativePlayer.innerNativeResourceRecycle();
                this.mLastRecycleTime = currentMS;
            }
        } else {
            this.mLastRecycleTime = currentMS;
        }
    }

    protected void initAttributes(Context context) {
        Y2ALog.setLevel(3);
        this.mContext = context;
        this.mNativePlayer = new Y2APlayerInner();
        this.innerInitGlView();
    }

    private void innerInitGlView() {
        if (this.mY2AGLView != null) {
            return;
        }
        this.mY2AGLView = Build.VERSION.SDK_INT < 16 || Y2AConfig.useGlSurfaceView() ? new Y2AGLSurfaceView(this.mContext) : new Y2AGLTextureView(this.mContext);
        this.mY2AGLView.setPlayerUID(this.mPlayerUID);
        this.mY2AGLView.setGlViewRenderer(this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.addView(this.mY2AGLView.getGlView(), (ViewGroup.LayoutParams)layoutParams);
    }

    protected boolean doLoadAudios(String jsonFile, final long startTime) {
        try {
            this.mAudioLoaded = 0;
            String fileDir = jsonFile.substring(0, jsonFile.lastIndexOf(47) + 1);
            FileReader in = new FileReader(jsonFile);
            JsonReader jsonReader = new JsonReader((Reader)in);
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                Y2AAudioItem item = new Y2AAudioItem(jsonReader);
                this.mAudioItems.add(item);
            }
            jsonReader.endArray();
            jsonReader.close();
            if (this.mAudioItems.size() > 0) {
                this.mSoundPool = new SoundPool(this.mAudioItems.size(), 3, 0);
                if (this.mSoundPool != null) {
                    this.mSoundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

                        public void onLoadComplete(SoundPool soundPool, int i, int i1) {
                            Y2APlayer.this.mAudioLoaded++;
                            if (Y2APlayer.this.mAudioLoaded >= Y2APlayer.this.mAudioItems.size()) {
                                Y2ALoggers.i(TAG, Y2APlayer.this.mPlayerUID + " load all audio file complete. cost time: " + (System.currentTimeMillis() - startTime));
                                Y2APlayer.this.mAudioLoaded = 0;
                                Y2APlayer.this.mMainHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Y2APlayer.this.mListener != null) {
                                            Y2APlayer.this.mListener.onLoaded(0);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    for (Y2AAudioItem item : this.mAudioItems) {
                        if (item.load(fileDir, this.mSoundPool)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (FileNotFoundException e) {
            Y2ALoggers.i(TAG, this.mPlayerUID + " json file not found.");
            return false;
        }
        catch (IOException e) {
            Y2ALoggers.e(TAG, this.mPlayerUID + " parse json file error");
            return false;
        }
        return false;
    }

    protected void doLoad(String filename) {
        int errorCode;
        this.clearNativeResources();
        this.mAudioItems.clear();
        if (this.mSoundPool != null) {
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
        long t = System.currentTimeMillis();
        long playerID = this.mNativePlayer.innerNativeLoad(filename);
        if (playerID != 0L) {
            this.mDurationTime = 1000 / this.mNativePlayer.innerNativeGetFPS();
        }
        int n = errorCode = playerID == 0L ? -1 : 0;
        if (errorCode == 0) {
            this.updateViewRect();
            this.mNativePlayer.innerNativeResize(this.mWidth, this.mHeight);
            GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
            String jsonFile = filename.substring(0, filename.lastIndexOf(46) + 1) + "json";
            if (this.doLoadAudios(jsonFile, t)) {
                return;
            }
        }
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Y2APlayer.this.mListener != null) {
                    Y2APlayer.this.mListener.onLoaded(errorCode);
                }
            }
        });
        Y2ALoggers.i(TAG, String.format(this.mPlayerUID + " xlb load time %d ms, playerID %d", System.currentTimeMillis() - t, playerID));
    }

    protected void doPlay(Y2APlayerInner.PlayParams params) {
        final int errorCode = this.mNativePlayer.innerNativePlay(params.mSpeed, params.mLoopCount);
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Y2APlayer.this.mListener != null) {
                    Y2APlayer.this.mListener.onPlayed(errorCode);
                }
            }
        });
        if (errorCode == 0) {
            this.mIsPlaying = true;
        }
        Y2ALoggers.i(TAG, String.format(this.mPlayerUID + " xlb play errorCode %d", errorCode));
    }

    protected void doPause(int isPause) {
        this.mNativePlayer.innerNativePause(isPause == 1);
    }

    protected void clearNativeResources() {
        this.mNativePlayer.innerNativeDestroy();
    }

    protected void doStop() {
        if (this.mNativePlayer.getNativeID() == 0L) {
            return;
        }
        this.clearNativeResources();
        if (this.mAudioItems.size() > 0) {
            for (Y2AAudioItem item : this.mAudioItems) {
                item.stop(this.mSoundPool);
            }
        }
        this.mAudioItems.clear();
        if (this.mSoundPool != null) {
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Y2APlayer.this.mListener != null) {
                    Y2APlayer.this.mListener.onStopped();
                    Y2APlayer.this.mListener.onDestroyed();
                }
                Y2APlayer.this.mY2AGLView.glPause();
            }
        });
        this.mNativePlayer.resetNativeID();
    }

    protected void doSetOffset(Y2APlayerInner.OffsetParams offsetParams) {
        this.mNativePlayer.innerNativeSetOffset(offsetParams.mOffsetX, offsetParams.mOffsetY);
    }

    protected void doSetImageForSprite(Y2APlayerInner.ImageSpriteParams imageSpriteParams) {
        this.mNativePlayer.innerNativeSetImageForSprite(imageSpriteParams.mImageKey, imageSpriteParams.mImagePath);
    }

    protected void doClearImageSprite(String imageKey) {
        this.mNativePlayer.innerNativeClearImageForSprite(imageKey);
    }

    protected void doSetTextForSprite(Y2APlayerInner.TextSpriteParams textSpriteParams) {
        this.mNativePlayer.innerNativeSetTextForSprite(textSpriteParams.mImageKey, textSpriteParams.mTtfFilePath, textSpriteParams.mText, textSpriteParams.mFontSize, textSpriteParams.mRed, textSpriteParams.mGreen, textSpriteParams.mBlue, textSpriteParams.mAlpha);
    }

    protected void doSetTextForSprite(String imageKey, StaticLayout layout) {
        int width = layout.getWidth();
        int height = layout.getHeight();
        if (width <= 0 || height <= 0) {
            Y2ALoggers.e(TAG, this.mPlayerUID + " layout width or height equal zero.");
            return;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)layout.getWidth(), (int)layout.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        layout.draw(canvas);
        this.mNativePlayer.innerNativeSetTextImageForSprite(imageKey, bitmap);
    }

    protected void doClearTextSprite(String imageKey) {
        this.mNativePlayer.innerNativeClearTextForSprite(imageKey);
    }

    protected void doSetFlipX(int isFlip) {
        this.mNativePlayer.innerNativeSetFLipX(isFlip == 1);
    }

    protected void doSetFlipY(int isFlip) {
        this.mNativePlayer.innerNativeSetFLipY(isFlip == 1);
    }

    protected void updateViewRect() {
        long sizer = this.mNativePlayer.innerNativeGetSize();
        int width = (int)(sizer >> 32 & 0xFFFFFFFFFFFFFFFFL);
        int height = (int)(sizer & 0xFFFFFFFFFFFFFFFFL);
        this.mAnimSizer.set(width, height);
        float scale = Math.min((float)this.mWidth / (float)width, (float)this.mHeight / (float)height);
        int scaleWidth = (int)(scale * (float)width);
        int scaleHeight = (int)(scale * (float)height);
        int startX = this.mWidth - scaleWidth >> 1;
        int startY = this.mHeight - scaleHeight >> 1;
        this.mVisiableRect.set(startX, startY, startX + scaleWidth, startY + scaleHeight);
    }

    public Point getY2ASizer() {
        return this.mAnimSizer;
    }

    static {
        System.loadLibrary("y2aplayer");
    }
}

