/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid.player;

import android.media.SoundPool;
import android.util.JsonReader;
import com.yy.y2aplayerandroid.log.Y2ALoggers;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Y2AAudioItem {
    private final String TAG = "Y2AAudioItem";
    private String mAudioKey = null;
    private int mStartFrame = 0;
    private int mEndFrame = 0;
    private int mStartTime = 0;
    private int mTotalTime = 0;
    private int mPlayerID = 0;
    private int mStreamID = 0;

    public Y2AAudioItem(JsonReader reader) throws IOException {
        if (reader == null) {
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (key.equals("mAudioKey")) {
                this.mAudioKey = reader.nextString();
                continue;
            }
            if (key.equals("mStartFrame")) {
                this.mStartFrame = reader.nextInt();
                continue;
            }
            if (key.equals("mEndFrame")) {
                this.mEndFrame = reader.nextInt();
                continue;
            }
            if (key.equals("mStartTime")) {
                this.mStartTime = reader.nextInt();
                continue;
            }
            if (key.equals("mTotalTime")) {
                this.mTotalTime = reader.nextInt();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (this.mAudioKey == null) {
            Y2ALoggers.e("Y2AAudioItem", "init audio item failed. audio key is null.");
            return;
        }
        Y2ALoggers.i("Y2AAudioItem", "init audio item, audio key:" + this.mAudioKey + " start frame:" + this.mStartFrame + " end frame:" + this.mEndFrame + " start time:" + this.mStartTime + " total time:" + this.mTotalTime);
    }

    public boolean load(String fileDir, SoundPool soundPool) {
        if (this.mAudioKey == null || fileDir == null || soundPool == null) {
            return false;
        }
        String audioPath = fileDir + this.mAudioKey + ".mp3";
        try {
            FileInputStream fis = new FileInputStream(audioPath);
            long offset = this.mTotalTime == 0 ? 0L : (long)((double)this.mStartTime / (double)this.mTotalTime * (double)fis.available());
            long len = (long)fis.available() - offset;
            this.mPlayerID = soundPool.load(fis.getFD(), offset, len, 1);
            fis.close();
        }
        catch (FileNotFoundException e) {
            Y2ALoggers.i("Y2AAudioItem", "file not found. " + audioPath);
            return false;
        }
        catch (IOException e) {
            Y2ALoggers.e("Y2AAudioItem", "read audio file error. " + audioPath);
            return false;
        }
        return true;
    }

    public void update(SoundPool soundPool, int frameIndex) {
        if (soundPool == null || this.mAudioKey == null || this.mPlayerID == 0) {
            return;
        }
        if (this.mStartFrame <= frameIndex && frameIndex < this.mEndFrame) {
            if (this.mStreamID == 0) {
                this.mStreamID = soundPool.play(this.mPlayerID, 1.0f, 1.0f, 1, 0, 1.0f);
                Y2ALoggers.i("Y2AAudioItem", "play audio: " + this.mAudioKey);
            }
        } else if (this.mStreamID != 0) {
            soundPool.stop(this.mStreamID);
            this.mStreamID = 0;
        }
    }

    public void stop(SoundPool soundPool) {
        if (soundPool == null || this.mAudioKey == null || this.mPlayerID == 0) {
            return;
        }
        if (this.mStreamID != 0) {
            soundPool.stop(this.mStreamID);
            this.mStreamID = 0;
        }
    }
}

