/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid.log;

import com.yy.y2aplayerandroid.log.Y2ALoggers;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.atomic.AtomicInteger;

public class Y2ALog {
    private static final String TAG = Y2ALog.class.getSimpleName();
    private static AtomicInteger mLogLevel = new AtomicInteger(3);
    private static Charset mCharset = Charset.forName("UTF-8");
    private static CharsetDecoder mDecoder = mCharset.newDecoder();

    private static native void nativeSetLevel(int var0);

    private void Y2ALog() {
    }

    public static void setLevel(int level) {
        mLogLevel.set(level);
        Y2ALog.nativeSetLevel(level);
    }

    public static void debug(Object o, String msg) {
        if (mLogLevel.get() <= 3) {
            Y2ALoggers.d(TAG, msg);
        }
    }

    public static void debug(String tag, String msg) {
        if (mLogLevel.get() <= 3) {
            Y2ALoggers.d(tag, msg);
        }
    }

    public static void info(Object o, String msg) {
        if (mLogLevel.get() <= 4) {
            Y2ALoggers.i(TAG, msg);
        }
    }

    public static void info(String tag, String msg) {
        if (mLogLevel.get() <= 4) {
            Y2ALoggers.i(tag, msg);
        }
    }

    public static void warn(Object o, String msg) {
        if (mLogLevel.get() <= 5) {
            Y2ALoggers.w(TAG, msg);
        }
    }

    public static void warn(String tag, String msg) {
        if (mLogLevel.get() <= 5) {
            Y2ALoggers.w(tag, msg);
        }
    }

    public static void error(Object o, String msg) {
        if (mLogLevel.get() <= 6) {
            Y2ALoggers.e(TAG, msg);
        }
    }

    public static void error(String tag, String msg) {
        if (mLogLevel.get() <= 6) {
            Y2ALoggers.e(tag, msg);
        }
    }

    private static void yylog(int level, ByteBuffer tag, ByteBuffer text) {
        try {
            String s1 = mDecoder.decode(tag).toString();
            String s2 = mDecoder.decode(text).toString();
            if (mLogLevel.get() <= level) {
                switch (level) {
                    case 2: {
                        Y2ALoggers.i(s1, s2);
                        break;
                    }
                    case 3: {
                        Y2ALoggers.d(s1, s2);
                        break;
                    }
                    case 4: {
                        Y2ALoggers.i(s1, s2);
                        break;
                    }
                    case 5: {
                        Y2ALoggers.w(s1, s2);
                        break;
                    }
                    case 6: {
                        Y2ALoggers.e(s1, s2);
                    }
                }
            }
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }
}

