/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid.gles;

import com.yy.y2aplayerandroid.Y2ALoggers;
import com.yy.y2aplayerandroid.gles.EGLLogWrapper;
import com.yy.y2aplayerandroid.gles.EglContextWrapper;
import com.yy.y2aplayerandroid.gles.GLThread;
import com.yy.y2aplayerandroid.gles.IEglHelper;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglHelper
implements IEglHelper {
    private static final String TAG = EglHelper.class.getSimpleName();
    private GLThread.EGLConfigChooser eglConfigChooser;
    private GLThread.EGLContextFactory eglContextFactory;
    private GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private EGL10 mEgl;
    private EGLDisplay mEglDisplay;
    private EGLSurface mEglSurface;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;

    public EglHelper(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.eglConfigChooser = configChooser;
        this.eglContextFactory = eglContextFactory;
        this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContext) {
        int[] version;
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            this.throwEglException("eglGetDisplay failed");
        }
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version = new int[2])) {
            this.throwEglException("eglInitialize failed");
        }
        this.mEglConfig = this.eglConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
        if (this.mEglConfig != null) {
            this.mEglContext = this.eglContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig, eglContext.getEglContextOld());
        }
        if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            this.mEglContext = null;
            this.throwEglException("createContext");
        }
        this.mEglSurface = null;
        EglContextWrapper eglContextWrapper = new EglContextWrapper();
        eglContextWrapper.setEglContextOld(this.mEglContext);
        return eglContextWrapper;
    }

    @Override
    public boolean createSurface(Object surface) {
        Y2ALoggers.w(TAG, "createSurface()  tid=" + Thread.currentThread().getId());
        if (this.mEgl == null) {
            Y2ALoggers.e(TAG, "egl not initialized");
            return false;
        }
        if (this.mEglDisplay == null) {
            Y2ALoggers.e(TAG, "eglDisplay not initialized");
            return false;
        }
        if (this.mEglConfig == null) {
            Y2ALoggers.e(TAG, "mEglConfig not initialized");
            return false;
        }
        this.destroySurfaceImp();
        this.mEglSurface = this.eglWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
            int error = this.mEgl.eglGetError();
            if (error == 12299) {
                Y2ALoggers.e(TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (this.mEglContext != null && !this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            EglHelper.logEglErrorAsWarning(TAG, "eglMakeCurrent", this.mEgl.eglGetError());
            return false;
        }
        return true;
    }

    @Override
    public int swap() {
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
            return this.mEgl.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.destroySurfaceImp();
    }

    private void destroySurfaceImp() {
        if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.eglWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }

    @Override
    public void finish() {
        if (this.mEglContext != null) {
            this.eglContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            this.mEgl.eglTerminate(this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    @Override
    public void setPresentationTime(long nsecs) {
    }

    private void throwEglException(String function) {
        EglHelper.throwEglException(function, this.mEgl.eglGetError());
    }

    public static void throwEglException(String function, int error) {
        String message = EglHelper.formatEglError(function, error);
        Y2ALoggers.e(TAG, "throwEglException tid=" + Thread.currentThread().getId() + " " + message);
    }

    public static void logEglErrorAsWarning(String tag, String function, int error) {
        Y2ALoggers.w(tag, EglHelper.formatEglError(function, error));
    }

    public static String formatEglError(String function, int error) {
        return function + " failed: " + EGLLogWrapper.getErrorString(error);
    }
}

