/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class GLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final String TAG = GLTextureView.class.getSimpleName();
    protected static final int sEventTick = 33;
    protected static final int sMiniSleepTick = 16;
    protected static final int SURFACE_RESIZE_FAILED = 2000;
    GLESVersion version = GLESVersion.OpenGLES11;
    EGLConfigChooser mEglConfigChooser = null;
    RenderingThreadType renderingThreadType = RenderingThreadType.BackgroundThread;
    GL11 gl11;
    Thread backgroundThread = null;
    protected Renderer mRenderer = null;
    protected EGLManager mEglManager = null;
    protected final Object mLock = new Object();
    protected final Object mListenerLock = new Object();
    protected AtomicBoolean mDestroyed = new AtomicBoolean(false);
    boolean mSleep = false;
    boolean mInitialized = false;
    int mSurfaceWidth = 0;
    int mSurfaceHeight = 0;
    protected int mDurationTime = 0;
    protected boolean mNeedRendering = false;
    protected boolean mSurfaceChanged = false;
    private SurfaceTexture mSurface = null;
    ConcurrentLinkedQueue mMessageQueue = new ConcurrentLinkedQueue();

    public GLTextureView(Context context) {
        super(context);
        this.setSurfaceTextureListener(this);
    }

    public GLTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setSurfaceTextureListener(this);
    }

    public GLTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setSurfaceTextureListener(this);
    }

    public EGLManager getEGLManager() {
        return this.mEglManager;
    }

    public void handleThreadMessage(Message msg) {
    }

    protected void resourceRecycle(long currentMS) {
    }

    public void pushMessage(Message msg) {
        this.mMessageQueue.add(msg);
    }

    public void onPause() {
        this.mSleep = true;
    }

    public void onResume() {
        this.mSleep = false;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderer(Renderer renderer) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new UnsupportedOperationException("GLTextureView Initialized");
            }
            this.mRenderer = renderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(GLESVersion version) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isInitialized()) {
                return;
            }
            this.version = version;
        }
    }

    public void setSurfaceSpec(SurfaceColorSpec color, boolean hasDepth, boolean hasStencil) {
        DefaultEGLConfigChooser chooser = new DefaultEGLConfigChooser();
        chooser.setColorSpec(color);
        chooser.setDepthEnable(hasDepth);
        chooser.setStencilEnable(hasStencil);
        this.setEGLConfigChooser(chooser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEGLConfigChooser(EGLConfigChooser eglConfigChooser) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new UnsupportedOperationException("GLTextureView Initialized");
            }
            this.mEglConfigChooser = eglConfigChooser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderingThreadType(RenderingThreadType renderingThreadType) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new UnsupportedOperationException("GLTextureView Initialized");
            }
            this.renderingThreadType = renderingThreadType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRender() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isInitialized()) {
                throw new UnsupportedOperationException("GLTextureView not initialized");
            }
            this.onRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAction(Runnable runnable) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isInitialized()) {
                throw new UnsupportedOperationException("GLTextureView not initialized");
            }
            this.mEglManager.bind();
            runnable.run();
            this.mEglManager.unbind();
        }
    }

    protected void createEGLManager() {
        if (this.mEglManager != null) {
            this.mEglManager.destroy();
            this.mEglManager = null;
        }
        this.mEglManager = new EGLManager();
        if (this.mEglConfigChooser == null) {
            this.mEglConfigChooser = new DefaultEGLConfigChooser();
        }
        this.mEglManager.initialize(this.mEglConfigChooser, this.version);
        if (this.version == GLESVersion.OpenGLES11) {
            this.gl11 = this.mEglManager.getGL11();
        }
    }

    protected void pushSurfaceResizeFailed() {
        if (this.isInitialized()) {
            Message msg = Message.obtain();
            msg.what = 2000;
            this.pushMessage(msg);
        }
    }

    protected boolean doSurfaceResize(SurfaceTexture surface) {
        boolean resizeResult = this.mEglManager.resize(surface);
        if (!resizeResult) {
            this.pushSurfaceResizeFailed();
            this.createEGLManager();
            resizeResult = this.mEglManager.resize(surface);
        }
        return resizeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Object object = this.mLock;
        synchronized (object) {
            boolean initializedResult;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.mSurface = surface;
            if (!this.isInitialized()) {
                this.createEGLManager();
                initializedResult = this.mEglManager.resize(surface);
                if (this.renderingThreadType != RenderingThreadType.BackgroundThread) {
                    this.mEglManager.bind();
                    this.mRenderer.onSurfaceCreated((GL10)this.gl11, this.mEglManager.getConfig());
                    this.mRenderer.onSurfaceChanged((GL10)this.gl11, width, height);
                    this.mEglManager.unbind();
                }
            } else {
                initializedResult = this.doSurfaceResize(surface);
                if (this.renderingThreadType != RenderingThreadType.BackgroundThread) {
                    this.mEglManager.bind();
                    this.mRenderer.onSurfaceChanged((GL10)this.gl11, width, height);
                    this.mEglManager.unbind();
                }
            }
            if (this.renderingThreadType == RenderingThreadType.BackgroundThread) {
                this.backgroundThread = this.createRenderingThread();
                this.backgroundThread.start();
            }
            this.mInitialized = initializedResult;
            this.mDestroyed.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Object object = this.mLock;
        synchronized (object) {
            if (surface == this.mSurface && width == this.mSurfaceWidth && height == this.mSurfaceHeight) {
                return;
            }
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.mSurface = surface;
            boolean resizeResult = this.doSurfaceResize(surface);
            this.mSurfaceChanged = true;
            if (this.mNeedRendering) {
                this.mNeedRendering = resizeResult;
            }
            if (this.renderingThreadType != RenderingThreadType.BackgroundThread) {
                this.mEglManager.bind();
                this.mRenderer.onSurfaceChanged((GL10)this.gl11, width, height);
                this.mEglManager.unbind();
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.destoryView();
        this.mInitialized = false;
        return true;
    }

    protected void destoryView() {
        block6: {
            if (this.mDestroyed.compareAndSet(false, true)) {
                try {
                    if (this.backgroundThread == null) break block6;
                    try {
                        Log.d((String)TAG, (String)"wait rendering thread");
                        this.backgroundThread.join(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.backgroundThread.interrupt();
                    }
                    this.backgroundThread = null;
                }
                finally {
                    this.mEglManager.destroy();
                }
            }
        }
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    protected void onRendering() {
        this.mEglManager.bind();
        this.mRenderer.onDrawFrame((GL10)this.gl11);
        this.mEglManager.swapBuffers();
        this.mEglManager.unbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleImp(long timestamp) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEglManager.bind();
            this.resourceRecycle(timestamp);
            this.mEglManager.unbind();
        }
    }

    protected Thread createRenderingThread() {
        return new Thread(){
            int width = 0;
            int height = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                GLTextureView.this.mEglManager.bind();
                GLTextureView.this.mRenderer.onSurfaceCreated((GL10)GLTextureView.this.gl11, GLTextureView.this.mEglManager.getConfig());
                while (!GLTextureView.this.mDestroyed.get()) {
                    try {
                        long frameTime;
                        object = GLTextureView.this.mLock;
                        synchronized (object) {
                            GLTextureView.this.mEglManager.bind();
                            frameTime = System.currentTimeMillis();
                            if (GLTextureView.this.mMessageQueue.isEmpty() && !GLTextureView.this.mNeedRendering || !GLTextureView.this.isInitialized()) {
                                GLTextureView.this.recycleImp(frameTime);
                                Thread.sleep(33L);
                                continue;
                            }
                            if (this.width != GLTextureView.this.mSurfaceWidth || this.height != GLTextureView.this.mSurfaceHeight || GLTextureView.this.mSurfaceChanged) {
                                GLTextureView.this.mSurfaceChanged = false;
                                this.width = GLTextureView.this.mSurfaceWidth;
                                this.height = GLTextureView.this.mSurfaceHeight;
                                GLTextureView.this.mRenderer.onSurfaceChanged((GL10)GLTextureView.this.gl11, this.width, this.height);
                            }
                            while (!GLTextureView.this.mMessageQueue.isEmpty()) {
                                Message msg = (Message)GLTextureView.this.mMessageQueue.poll();
                                GLTextureView.this.handleThreadMessage(msg);
                                if (GLTextureView.this.mDestroyed.get()) continue;
                                break;
                            }
                            if (GLTextureView.this.mNeedRendering) {
                                GLTextureView.this.mRenderer.onDrawFrame((GL10)GLTextureView.this.gl11);
                                GLTextureView.this.mEglManager.swapBuffers();
                            }
                            GLTextureView.this.mEglManager.unbind();
                        }
                        long lastTime = System.currentTimeMillis();
                        frameTime = lastTime - frameTime;
                        long sleepTime = (long)GLTextureView.this.mDurationTime > frameTime ? (long)GLTextureView.this.mDurationTime - frameTime : (GLTextureView.this.mDurationTime <= 1 ? 33L : 16L);
                        Thread.sleep(sleepTime);
                        GLTextureView.this.recycleImp(lastTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                object = GLTextureView.this.mLock;
                synchronized (object) {
                    GLTextureView.this.mEglManager.bind();
                    GLTextureView.this.mRenderer.onSurfaceDestroyed((GL10)GLTextureView.this.gl11);
                    GLTextureView.this.mEglManager.releaseThread();
                }
            }
        };
    }

    public static enum SurfaceColorSpec {
        RGBA8{

            @Override
            public int getRedSize() {
                return 8;
            }

            @Override
            public int getGreenSize() {
                return 8;
            }

            @Override
            public int getBlueSize() {
                return 8;
            }

            @Override
            public int getAlphaSize() {
                return 8;
            }
        }
        ,
        RGB8{

            @Override
            public int getRedSize() {
                return 8;
            }

            @Override
            public int getGreenSize() {
                return 8;
            }

            @Override
            public int getBlueSize() {
                return 8;
            }

            @Override
            public int getAlphaSize() {
                return 0;
            }
        }
        ,
        RGB565{

            @Override
            public int getAlphaSize() {
                return 5;
            }

            @Override
            public int getGreenSize() {
                return 6;
            }

            @Override
            public int getBlueSize() {
                return 5;
            }

            @Override
            public int getRedSize() {
                return 0;
            }
        };


        public abstract int getRedSize();

        public abstract int getBlueSize();

        public abstract int getGreenSize();

        public abstract int getAlphaSize();
    }

    public class EGLManager {
        private final Object mMgrLock = new Object();
        EGL10 egl = null;
        EGLDisplay eglDisplay = null;
        EGLSurface eglSurface = null;
        EGLContext eglContext = null;
        EGLConfig eglConfig = null;
        EGLDisplay systemDisplay = null;
        EGLSurface systemReadSurface = null;
        EGLSurface systemDrawSurface = null;
        EGLContext systemContext = null;
        GL11 gl11 = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialize(EGLConfigChooser chooser, GLESVersion version) {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl != null) {
                    return;
                }
                this.egl = (EGL10)EGLContext.getEGL();
                this.systemDisplay = this.egl.eglGetCurrentDisplay();
                this.systemReadSurface = this.egl.eglGetCurrentSurface(12378);
                this.systemDrawSurface = this.egl.eglGetCurrentSurface(12377);
                this.systemContext = this.egl.eglGetCurrentContext();
                this.eglDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                    throw new RuntimeException("EGL_NO_DISPLAY");
                }
                if (!this.egl.eglInitialize(this.eglDisplay, new int[2])) {
                    throw new RuntimeException("eglInitialize");
                }
                this.eglConfig = chooser.chooseConfig(this.egl, this.eglDisplay, version);
                if (this.eglConfig == null) {
                    throw new RuntimeException("chooseConfig");
                }
                this.eglContext = this.egl.eglCreateContext(this.eglDisplay, this.eglConfig, EGL10.EGL_NO_CONTEXT, version.getContextAttributes());
                if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
                    throw new RuntimeException("eglCreateContext");
                }
                if (version == GLESVersion.OpenGLES11) {
                    this.gl11 = (GL11)this.eglContext.getGL();
                }
            }
        }

        public GL11 getGL11() {
            if (this.gl11 == null) {
                throw new UnsupportedOperationException("OpenGL ES 1.1 only");
            }
            return this.gl11;
        }

        public EGLConfig getConfig() {
            return this.eglConfig;
        }

        public EGLSurface getSurface() {
            return this.eglSurface;
        }

        public EGLContext getContext() {
            return this.eglContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resize(SurfaceTexture surface) {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl != null) {
                    if (this.eglSurface != null) {
                        this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
                    }
                    this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, (Object)surface, null);
                    if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
                        Log.e((String)TAG, (String)String.format("eglCreateWindowSurface Failed ,error code is %d", this.egl.eglGetError()));
                        return false;
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl == null) {
                    return;
                }
                if (this.eglSurface != null) {
                    this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
                    this.eglSurface = null;
                }
                if (this.eglContext != null) {
                    this.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
                    this.eglContext = null;
                }
                this.eglConfig = null;
                this.egl = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bind() {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl != null) {
                    this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext);
                }
            }
        }

        public boolean isUIThread() {
            return Thread.currentThread().equals(Looper.getMainLooper().getThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unbind() {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl != null) {
                    if (this.isUIThread()) {
                        this.egl.eglMakeCurrent(this.systemDisplay, this.systemDrawSurface, this.systemReadSurface, this.systemContext);
                    } else {
                        this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseThread() {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl != null) {
                    this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean swapBuffers() {
            Object object = this.mMgrLock;
            synchronized (object) {
                if (this.egl != null) {
                    return this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
                }
            }
            return true;
        }
    }

    public static class DefaultEGLConfigChooser
    implements EGLConfigChooser {
        SurfaceColorSpec mColorSpec = SurfaceColorSpec.RGBA8;
        boolean mDepthEnable = true;
        boolean mStencilEnable = false;

        public void setColorSpec(SurfaceColorSpec colorSpec) {
            this.mColorSpec = colorSpec;
        }

        public void setDepthEnable(boolean depthEnable) {
            this.mDepthEnable = depthEnable;
        }

        public void setStencilEnable(boolean stencilEnable) {
            this.mStencilEnable = stencilEnable;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, GLESVersion version) {
            EGLConfig[] configs = new EGLConfig[32];
            if (egl == null) {
                return configs[0];
            }
            int[] config_num = new int[1];
            if (!egl.eglChooseConfig(display, this.getConfigSpec(version), configs, configs.length, config_num)) {
                throw new RuntimeException("eglChooseConfig");
            }
            int CONFIG_NUM = config_num[0];
            int r_bits = this.mColorSpec.getRedSize();
            int g_bits = this.mColorSpec.getGreenSize();
            int b_bits = this.mColorSpec.getBlueSize();
            int a_bits = this.mColorSpec.getAlphaSize();
            int d_bits = this.mDepthEnable ? 16 : 0;
            int s_bits = this.mStencilEnable ? 8 : 0;
            for (int i = 0; i < CONFIG_NUM; ++i) {
                EGLConfig checkConfig = configs[i];
                int config_r = DefaultEGLConfigChooser.getConfigAttrib(egl, display, checkConfig, 12324);
                int config_g = DefaultEGLConfigChooser.getConfigAttrib(egl, display, checkConfig, 12323);
                int config_b = DefaultEGLConfigChooser.getConfigAttrib(egl, display, checkConfig, 12322);
                int config_a = DefaultEGLConfigChooser.getConfigAttrib(egl, display, checkConfig, 12321);
                int config_d = DefaultEGLConfigChooser.getConfigAttrib(egl, display, checkConfig, 12325);
                int config_s = DefaultEGLConfigChooser.getConfigAttrib(egl, display, checkConfig, 12326);
                if (config_r != r_bits || config_g != g_bits || config_b != b_bits || config_a < a_bits || config_d < d_bits || config_s < s_bits) continue;
                return checkConfig;
            }
            return configs[0];
        }

        private int[] getConfigSpec(GLESVersion version) {
            int redSize = this.mColorSpec.getRedSize();
            int blueSize = this.mColorSpec.getBlueSize();
            int greenSize = this.mColorSpec.getGreenSize();
            int alphaSize = this.mColorSpec.getAlphaSize();
            int depthSize = this.mDepthEnable ? 16 : 0;
            int stencilSize = this.mStencilEnable ? 8 : 0;
            ArrayList<Integer> result = new ArrayList<Integer>();
            if (version == GLESVersion.OpenGLES20) {
                result.add(12352);
                result.add(4);
            }
            result.add(12324);
            result.add(redSize);
            result.add(12323);
            result.add(greenSize);
            result.add(12322);
            result.add(blueSize);
            if (alphaSize > 0) {
                result.add(12321);
                result.add(alphaSize);
            }
            if (depthSize > 0) {
                result.add(12325);
                result.add(depthSize);
            }
            if (stencilSize > 0) {
                result.add(12326);
                result.add(stencilSize);
            }
            result.add(12344);
            int[] result_array = new int[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                result_array[i] = (Integer)result.get(i);
            }
            return result_array;
        }

        private static int getConfigAttrib(EGL10 egl, EGLDisplay eglDisplay, EGLConfig eglConfig, int attr) {
            if (egl == null) {
                if (attr == 12325) {
                    return 16;
                }
                if (attr == 12326) {
                    return 0;
                }
                return 8;
            }
            int[] value = new int[1];
            egl.eglGetConfigAttrib(eglDisplay, eglConfig, attr, value);
            return value[0];
        }
    }

    public static enum RenderingThreadType {
        BackgroundThread,
        RequestThread;

    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);

        public void onSurfaceDestroyed(GL10 var1);
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, GLESVersion var3);
    }

    public static enum GLESVersion {
        OpenGLES11{

            @Override
            public int[] getContextAttributes() {
                return null;
            }
        }
        ,
        OpenGLES20{

            @Override
            public int[] getContextAttributes() {
                return new int[]{12440, 2, 12344};
            }
        };


        public abstract int[] getContextAttributes();
    }
}

