/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import com.yy.y2aplayerandroid.Y2AGLTextureView;
import com.yy.y2aplayerandroid.Y2ALog;
import com.yy.y2aplayerandroid.Y2ALoggers;
import com.yy.y2aplayerandroid.gles.GLViewRenderer;

public class Y2APlayer
extends Y2AGLTextureView
implements GLViewRenderer {
    private static final String TAG = Y2APlayer.class.getSimpleName();
    protected static final int sRecyclePeriod = 1000;
    private Y2APlayerListener mListener = null;
    private long mNativeID = 0L;
    private boolean mIsPlaying = false;
    private int mWidth = 0;
    private int mHeight = 0;
    private Rect mVisiableRect = new Rect();
    protected long mLastRecycleTime = 0L;
    private Point mAnimSizer = new Point(0, 0);
    protected int mDurationTime = 0;
    private long mSleepTime = 0L;
    private long mFrameTime = 0L;
    private long mLastTime = 0L;
    protected static final int sEventTick = 33;
    protected static final int sMiniSleepTick = 16;
    private int mRenderMode = 1;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());

    public Y2APlayer(Context context) {
        super(context);
        this.initAttributes();
    }

    public Y2APlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes();
    }

    public Y2APlayer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttributes();
    }

    public Rect getVisableRect() {
        return this.mVisiableRect;
    }

    public void setListener(Y2APlayerListener listener) {
        this.mListener = listener;
    }

    public void close() {
        this.mListener = null;
    }

    public void load(final String filename) {
        Y2ALoggers.i(TAG, "a2m load filename:" + filename);
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doLoad(filename);
            }
        });
    }

    public void play(final float speed, final int loopCount) {
        Y2ALoggers.i(TAG, "a2m play");
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                PlayParams params = new PlayParams(speed, loopCount);
                Y2APlayer.this.doPlay(params);
            }
        });
    }

    public void pause(final boolean isPaused) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doPause(isPaused ? 1 : 0);
            }
        });
    }

    public void stop() {
        if (this.mIsPlaying) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    Y2APlayer.this.doStop();
                }
            });
            this.mIsPlaying = false;
        }
    }

    public void setBottomMargin(final int margin) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                OffsetParams params = new OffsetParams(0.0f, margin);
                Y2APlayer.this.doSetOffset(params);
            }
        });
    }

    public void setOffset(final float offsetX, final float offsetY) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                OffsetParams params = new OffsetParams(offsetX, offsetY);
                Y2APlayer.this.doSetOffset(params);
            }
        });
    }

    public void setImageForSptire(final String imageKey, final String imagePath) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                ImageSpriteParams params = new ImageSpriteParams(imageKey, imagePath);
                Y2APlayer.this.doSetImageForSprite(params);
            }
        });
    }

    public void clearImageForSprite(final String imageKey) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doClearImageSprite(imageKey);
            }
        });
    }

    public void setTextForSprite(final String imageKey, final String ttfFilePath, final String text, final int fontSize, final float red, final float green, final float blue, final float alpha) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                TextSpriteParams params = new TextSpriteParams(imageKey, ttfFilePath, text, fontSize, red, green, blue, alpha);
                Y2APlayer.this.doSetTextForSprite(params);
            }
        });
    }

    public void clearTextForSprite(final String imageKey) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doClearTextSprite(imageKey);
            }
        });
    }

    public void setFlipX(final boolean isFlip) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doSetFlipX(isFlip ? 1 : 0);
            }
        });
    }

    public void setFlipY(final boolean isFlip) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Y2APlayer.this.doSetFlipY(isFlip ? 1 : 0);
            }
        });
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
        if (this.mGLThread == null) {
            this.createGLThread();
        }
    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        super.onSurfaceTextureDestroyed(surface);
        return true;
    }

    @Override
    protected int getRenderMode() {
        return this.mRenderMode;
    }

    @Override
    public void onSurfaceCreated() {
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        Y2APlayer.nativeResize(width, height, this.mNativeID);
        this.updateViewRect();
    }

    @Override
    public void onDrawFrame() {
        this.mFrameTime = System.currentTimeMillis();
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glDisable((int)2929);
        GLES20.glClear((int)16384);
        if (this.mNativeID == 0L) {
            return;
        }
        Y2APlayer.nativeRender(this.mNativeID);
        if (Y2APlayer.nativeIsStopped(this.mNativeID) && this.mIsPlaying) {
            this.doStop();
            this.mIsPlaying = false;
            return;
        }
        this.mLastTime = System.currentTimeMillis();
        this.mFrameTime = this.mLastTime - this.mFrameTime;
        this.mSleepTime = (long)this.mDurationTime > this.mFrameTime ? (long)this.mDurationTime - this.mFrameTime : (this.mDurationTime <= 1 ? 33L : 16L);
        try {
            Thread.sleep(this.mSleepTime);
        }
        catch (InterruptedException e) {
            this.resourceRecycle(this.mLastTime);
            return;
        }
        this.resourceRecycle(this.mLastTime);
    }

    @Override
    public void onCleanup() {
        this.doStop();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void resourceRecycle(long currentMS) {
        if (this.mLastRecycleTime != 0L) {
            if (currentMS - this.mLastRecycleTime >= 1000L) {
                Y2APlayer.nativeResourceRecycle();
                this.mLastRecycleTime = currentMS;
            }
        } else {
            this.mLastRecycleTime = currentMS;
        }
    }

    protected void initAttributes() {
        Y2ALog.setLevel(3);
        this.setOpaque(false);
        if (Build.VERSION.SDK_INT < 24) {
            this.setBackgroundColor(0);
        }
        this.setRenderer(this);
        if (Build.VERSION.SDK_INT < 16) {
            this.setVisibility(4);
        }
    }

    protected void doLoad(String filename) {
        int errorCode;
        this.clearNativeResources();
        this.mNativeID = 0L;
        long t = System.currentTimeMillis();
        this.mNativeID = Y2APlayer.nativeLoad(filename, this.mNativeID);
        if (this.mNativeID != 0L) {
            this.mDurationTime = 1000 / Y2APlayer.nativeGetFPS(this.mNativeID);
        }
        int n = errorCode = this.mNativeID == 0L ? -1 : 0;
        if (errorCode == 0) {
            this.updateViewRect();
            Y2APlayer.nativeResize(this.mWidth, this.mHeight, this.mNativeID);
            GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        }
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Y2APlayer.this.mListener != null) {
                    Y2APlayer.this.mListener.onLoaded(errorCode);
                }
            }
        });
        Y2ALoggers.i(TAG, String.format("xlb load time %d ms, mNativeID %d", System.currentTimeMillis() - t, this.mNativeID));
    }

    protected void doPlay(PlayParams params) {
        final int errorCode = Y2APlayer.nativePlay(params.mSpeed, params.mLoopCount, this.mNativeID);
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Y2APlayer.this.mListener != null) {
                    Y2APlayer.this.mListener.onPlayed(errorCode);
                }
            }
        });
        if (errorCode == 0) {
            this.mIsPlaying = true;
        }
        Y2ALoggers.i(TAG, String.format("xlb play errorCode %d", errorCode));
    }

    protected void doPause(int isPause) {
        Y2APlayer.nativePause(isPause == 1, this.mNativeID);
    }

    protected void clearNativeResources() {
        if (this.mNativeID != 0L) {
            Y2APlayer.nativeDestroy(this.mNativeID);
            this.mNativeID = 0L;
        }
    }

    protected void doStop() {
        if (this.mNativeID == 0L) {
            return;
        }
        this.clearNativeResources();
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Y2APlayer.this.mListener != null) {
                    Y2APlayer.this.mListener.onStopped();
                    Y2APlayer.this.mListener.onDestroyed();
                }
            }
        });
        this.mNativeID = 0L;
    }

    protected void doSetOffset(OffsetParams offsetParams) {
        Y2APlayer.nativeSetOffset(offsetParams.mOffsetX, offsetParams.mOffsetY, this.mNativeID);
    }

    protected void doSetImageForSprite(ImageSpriteParams imageSpriteParams) {
        Y2APlayer.nativeSetImageForSprite(imageSpriteParams.mImageKey, imageSpriteParams.mImagePath, this.mNativeID);
    }

    protected void doClearImageSprite(String imageKey) {
        Y2APlayer.nativeClearImageForSprite(imageKey, this.mNativeID);
    }

    protected void doSetTextForSprite(TextSpriteParams textSpriteParams) {
        Y2APlayer.nativeSetTextForSprite(textSpriteParams.mImageKey, textSpriteParams.mTtfFilePath, textSpriteParams.mText, textSpriteParams.mFontSize, textSpriteParams.mRed, textSpriteParams.mGreen, textSpriteParams.mBlue, textSpriteParams.mAlpha, this.mNativeID);
    }

    protected void doClearTextSprite(String imageKey) {
        Y2APlayer.nativeClearTextForSprite(imageKey, this.mNativeID);
    }

    protected void doSetFlipX(int isFlip) {
        Y2APlayer.nativeSetFLipX(isFlip == 1, this.mNativeID);
    }

    protected void doSetFlipY(int isFlip) {
        Y2APlayer.nativeSetFLipY(isFlip == 1, this.mNativeID);
    }

    protected void updateViewRect() {
        long sizer = Y2APlayer.nativeGetSize(this.mNativeID);
        int width = (int)(sizer >> 32 & 0xFFFFFFFFFFFFFFFFL);
        int height = (int)(sizer & 0xFFFFFFFFFFFFFFFFL);
        this.mAnimSizer.set(width, height);
        float scale = Math.min((float)this.mWidth / (float)width, (float)this.mHeight / (float)height);
        int scaleWidth = (int)(scale * (float)width);
        int scaleHeight = (int)(scale * (float)height);
        int startX = this.mWidth - scaleWidth >> 1;
        int startY = this.mHeight - scaleHeight >> 1;
        this.mVisiableRect.set(startX, startY, startX + scaleWidth, startY + scaleHeight);
    }

    public Point getY2ASizer() {
        return this.mAnimSizer;
    }

    private static native long nativeLoad(String var0, long var1);

    private static native int nativePlay(float var0, int var1, long var2);

    private static native void nativePause(boolean var0, long var1);

    private static native void nativeStop(long var0);

    private static native void nativeResize(int var0, int var1, long var2);

    private static native void nativeRender(long var0);

    private static native int nativeGetFPS(long var0);

    private static native boolean nativeIsStopped(long var0);

    private static native long nativeGetSize(long var0);

    private static native void nativeSetImageForSprite(String var0, String var1, long var2);

    private static native void nativeClearImageForSprite(String var0, long var1);

    private static native void nativeSetTextForSprite(String var0, String var1, String var2, int var3, float var4, float var5, float var6, float var7, long var8);

    private static native void nativeClearTextForSprite(String var0, long var1);

    private static native void nativeSetFLipX(boolean var0, long var1);

    private static native void nativeSetFLipY(boolean var0, long var1);

    private static native void nativeSetOffset(float var0, float var1, long var2);

    private static native void nativeResourceRecycle();

    private static native void nativeDestroy(long var0);

    static {
        System.loadLibrary("y2aplayer");
    }

    public static class PlayParams {
        public float mSpeed;
        public int mLoopCount;

        public PlayParams(float speed, int loopCount) {
            this.mSpeed = speed;
            this.mLoopCount = loopCount;
        }
    }

    public static class TextSpriteParams {
        public String mImageKey;
        public String mTtfFilePath;
        public String mText;
        public int mFontSize;
        public float mRed;
        public float mGreen;
        public float mBlue;
        public float mAlpha;

        public TextSpriteParams(String imageKey, String ttfFilePath, String text, int fontSize, float red, float green, float blue, float alpha) {
            this.mImageKey = imageKey;
            this.mTtfFilePath = ttfFilePath;
            this.mText = text;
            this.mFontSize = fontSize;
            this.mRed = red;
            this.mGreen = green;
            this.mBlue = blue;
            this.mAlpha = alpha;
        }
    }

    public static class ImageSpriteParams {
        public String mImageKey;
        public String mImagePath;

        public ImageSpriteParams(String imageKey, String imagePath) {
            this.mImageKey = imageKey;
            this.mImagePath = imagePath;
        }
    }

    public static class OffsetParams {
        public float mOffsetX;
        public float mOffsetY;

        public OffsetParams(float offsetX, float offsetY) {
            this.mOffsetX = offsetX;
            this.mOffsetY = offsetY;
        }
    }

    public static interface Y2APlayerListener {
        public void onLoaded(int var1);

        public void onPlayed(int var1);

        public void onStopped();

        public void onDestroyed();
    }
}

