/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid.gles;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.yy.y2aplayerandroid.Y2ALoggers;
import com.yy.y2aplayerandroid.gles.EglContextWrapper;
import com.yy.y2aplayerandroid.gles.EglHelper;
import com.yy.y2aplayerandroid.gles.GLThread;
import com.yy.y2aplayerandroid.gles.IEglHelper;

@RequiresApi(value=17)
public class EglHelperAPI17
implements IEglHelper {
    private static final String TAG = EglHelperAPI17.class.getSimpleName();
    private GLThread.EGLConfigChooser eglConfigChooser;
    private GLThread.EGLContextFactory eglContextFactory;
    private GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private EGLDisplay mEglDisplay;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;
    private EGLSurface mEglSurface;

    public EglHelperAPI17(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.eglConfigChooser = configChooser;
        this.eglContextFactory = eglContextFactory;
        this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContext) {
        int[] version;
        Y2ALoggers.w(TAG, "start() tid=" + Thread.currentThread().getId());
        this.mEglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
            this.throwEglException("eglGetDisplay failed");
        }
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])(version = new int[2]), (int)0, (int[])version, (int)1)) {
            this.mEglDisplay = null;
            this.throwEglException("eglInitialize failed");
        }
        this.mEglConfig = this.eglConfigChooser.chooseConfig(this.mEglDisplay, false);
        if (this.mEglConfig != null) {
            this.mEglContext = this.eglContextFactory.createContextAPI17(this.mEglDisplay, this.mEglConfig, eglContext.getEglContext());
        }
        if (this.mEglContext == null || this.mEglContext == EGL14.EGL_NO_CONTEXT) {
            this.mEglContext = null;
            this.throwEglException("createContext");
        }
        Y2ALoggers.w(TAG, "createContext " + this.mEglContext + " tid=" + Thread.currentThread().getId());
        this.mEglSurface = null;
        EglContextWrapper eglContextWrapper = new EglContextWrapper();
        eglContextWrapper.setEglContext(this.mEglContext);
        return eglContextWrapper;
    }

    @Override
    public boolean createSurface(Object surface) {
        Y2ALoggers.w(TAG, "createSurface()  tid=" + Thread.currentThread().getId());
        if (this.mEglDisplay == null) {
            Y2ALoggers.e(TAG, "eglDisplay not initialized");
            return false;
        }
        if (this.mEglConfig == null) {
            Y2ALoggers.e(TAG, "mEglConfig not initialized");
            return false;
        }
        this.destroySurfaceImp();
        this.mEglSurface = this.eglWindowSurfaceFactory.createWindowSurface(this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL14.EGL_NO_SURFACE) {
            int error = EGL14.eglGetError();
            if (error == 12299) {
                Y2ALoggers.e(TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (this.mEglContext != null && !EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext)) {
            EglHelperAPI17.logEglErrorAsWarning(TAG, "eglMakeCurrent", EGL14.eglGetError());
            return false;
        }
        return true;
    }

    @Override
    public int swap() {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
            Y2ALoggers.w(TAG, String.format("swap: start get error", new Object[0]));
            return EGL14.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.destroySurfaceImp();
    }

    private void destroySurfaceImp() {
        if (this.mEglSurface != null && this.mEglSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            this.eglWindowSurfaceFactory.destroySurface(this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }

    @Override
    public void finish() {
        if (this.mEglContext != null) {
            this.eglContextFactory.destroyContext(this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    @Override
    public void setPresentationTime(long nsecs) {
        if (Build.VERSION.SDK_INT >= 18 && nsecs != 0L) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (long)nsecs);
        }
    }

    public static void logEglErrorAsWarning(String tag, String function, int error) {
        Y2ALoggers.w(tag, EglHelper.formatEglError(function, error));
    }

    private void throwEglException(String function) {
        EglHelperAPI17.throwEglException(function, EGL14.eglGetError());
    }

    public static void throwEglException(String function, int error) {
        String message = EglHelper.formatEglError(function, error);
        Y2ALoggers.e(TAG, "throwEglException tid=" + Thread.currentThread().getId() + " " + message);
    }
}

