/*
 * Decompiled with CFR 0.152.
 */
package com.yy.y2aplayerandroid;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.yy.y2aplayerandroid.Y2ALoggers;
import com.yy.y2aplayerandroid.gles.EglContextWrapper;
import com.yy.y2aplayerandroid.gles.GLThread;
import com.yy.y2aplayerandroid.gles.GLViewRenderer;
import java.util.ArrayList;
import java.util.List;

abstract class Y2AGLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final String TAG = Y2AGLTextureView.class.getSimpleName();
    protected GLThread mGLThread;
    protected GLThread.Builder glThreadBuilder;
    private List<Runnable> cacheEvents = new ArrayList<Runnable>();
    private GLThread.OnCreateGLContextListener onCreateGLContextListener;
    private boolean hasCreateGLThreadCalledOnce = false;
    private boolean surfaceAvailable = false;
    private GLViewRenderer renderer;

    public Y2AGLTextureView(Context context) {
        super(context);
        this.init();
    }

    public Y2AGLTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public Y2AGLTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Y2ALoggers.i(TAG, "onSizeChanged: ");
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mGLThread != null) {
            this.mGLThread.onWindowResize(w, h);
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void queueEvent(Runnable r) {
        if (this.mGLThread == null) {
            this.cacheEvents.add(r);
            return;
        }
        this.mGLThread.queueEvent(r);
    }

    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void surfaceCreated() {
        if (this.mGLThread != null) {
            this.mGLThread.surfaceCreated();
        }
    }

    protected void surfaceDestroyed(boolean isDestroyed) {
        if (isDestroyed) {
            if (this.mGLThread != null) {
                this.mGLThread.surfaceDestroyed();
                this.mGLThread.onPause();
                this.mGLThread.requestExitAndWait();
            }
            this.hasCreateGLThreadCalledOnce = false;
            this.surfaceAvailable = false;
            this.mGLThread = null;
        } else {
            if (this.mGLThread != null) {
                this.mGLThread.surfaceDestroyed();
            }
            this.surfaceAvailable = false;
        }
    }

    protected void surfaceChanged(int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    protected void surfaceRedrawNeeded() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void onDetachedFromWindow() {
        Y2ALoggers.i(TAG, "onDetachedFromWindow: ");
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
            this.mGLThread.requestExitAndWait();
            this.mGLThread = null;
        }
        super.onDetachedFromWindow();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
                this.mGLThread = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void init() {
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public EglContextWrapper getCurrentEglContext() {
        return this.mGLThread == null ? null : this.mGLThread.getEglContext();
    }

    public void setOnCreateGLContextListener(GLThread.OnCreateGLContextListener onCreateGLContextListener) {
        this.onCreateGLContextListener = onCreateGLContextListener;
    }

    protected int getRenderMode() {
        return 0;
    }

    public void setRenderer(GLViewRenderer renderer) {
        this.renderer = renderer;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Y2ALoggers.i(TAG, "onSurfaceTextureAvailable: ");
        this.surfaceAvailable = true;
        this.glThreadBuilder = new GLThread.Builder();
        if (this.mGLThread == null) {
            this.glThreadBuilder.setRenderMode(this.getRenderMode()).setSurface(surface).setRenderer(this.renderer);
            if (this.hasCreateGLThreadCalledOnce) {
                this.createGLThread();
            }
        } else {
            this.mGLThread.setSurface(surface);
            this.freshSurface(width, height);
        }
    }

    protected void createGLThread() {
        Y2ALoggers.i(TAG, "createGLThread: ");
        this.hasCreateGLThreadCalledOnce = true;
        if (!this.surfaceAvailable) {
            return;
        }
        if (this.mGLThread != null) {
            return;
        }
        this.mGLThread = this.glThreadBuilder.createGLThread();
        this.mGLThread.setOnCreateGLContextListener(new GLThread.OnCreateGLContextListener(){

            @Override
            public void onCreate(final EglContextWrapper eglContext) {
                Y2AGLTextureView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Y2AGLTextureView.this.onCreateGLContextListener != null) {
                            Y2AGLTextureView.this.onCreateGLContextListener.onCreate(eglContext);
                        }
                    }
                });
            }
        });
        this.mGLThread.start();
        this.freshSurface(this.getWidth(), this.getHeight());
        for (Runnable cacheEvent : this.cacheEvents) {
            this.mGLThread.queueEvent(cacheEvent);
        }
        this.cacheEvents.clear();
    }

    private void freshSurface(int width, int height) {
        this.surfaceCreated();
        this.surfaceChanged(width, height);
        this.surfaceRedrawNeeded();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Y2ALoggers.i(TAG, "onSurfaceTextureSizeChanged: ");
        this.surfaceChanged(width, height);
        this.surfaceRedrawNeeded();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Y2ALoggers.i(TAG, "onSurfaceTextureDestroyed: ");
        this.surfaceDestroyed(false);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

