/*
 * Decompiled with CFR 0.152.
 */
package com.yy.android.sniper.api.lurk;

import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import com.yy.android.sniper.api.lurk.LurkBuilder;
import com.yy.android.sniper.api.lurk.generater.IdentifierGenerater;
import com.yy.android.sniper.api.lurk.point.PointFragmentListener;
import com.yy.android.sniper.api.lurk.point.PointViewListener;

public class LurkIncubator {
    static LurkIncubator mLurkIncubator;
    private PointFragmentListener mPointFragmentListener;
    private PointViewListener mPointViewListener;
    private IdentifierGenerater mGenerater = new IdentifierGenerater();

    private LurkIncubator() {
        this(null);
    }

    private LurkIncubator(LurkBuilder lurkBuilder) {
        if (lurkBuilder != null) {
            this.mPointFragmentListener = lurkBuilder.mPointContext;
            this.mPointViewListener = lurkBuilder.mPointView;
        }
    }

    static LurkIncubator getInstance(LurkBuilder lurkBuilder) {
        if (mLurkIncubator == null) {
            mLurkIncubator = new LurkIncubator(lurkBuilder);
        }
        return mLurkIncubator;
    }

    public void callFragmentCreate(View view, Bundle savedInstanceState, String fragmentName) {
        if (this.mPointFragmentListener != null) {
            this.mPointFragmentListener.onFragmentCreated(savedInstanceState);
        }
        this.mGenerater.addFragmentName(view, fragmentName);
    }

    public void callFragmentDestroy(String fragmentName) {
        if (this.mPointFragmentListener != null) {
            this.mPointFragmentListener.onFragmentDestroy();
        }
        this.mGenerater.removeFragmentName(fragmentName);
    }

    public void callOnClick(View view) {
        if (this.mPointViewListener != null) {
            this.mPointViewListener.onClick(view, this.mGenerater.getOnClickViewIdentifier(view));
        }
    }

    public void callOnItemClick(AdapterView<?> parent, View view, int position) {
        if (this.mPointViewListener != null) {
            this.mPointViewListener.onClick(view, this.mGenerater.getListItemViewIdentifier(parent, view, position));
        }
    }
}

