/*
 * Decompiled with CFR 0.152.
 */
package com.yy.android.sniper.api.darts;

import android.util.Log;
import com.yy.android.sniper.api.darts.Darts;
import com.yy.android.sniper.api.darts.DartsFactory;
import com.yy.android.sniper.api.darts.DartsTransfer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DartsLauncher {
    private static final String TAG = "DartsLauncher";
    private static final Map<Class, Darts> mMarket = new ConcurrentHashMap<Class, Darts>();

    static void init(DartsFactory[] dartsFactoryArray) {
        for (DartsFactory dartsFactory : dartsFactoryArray) {
            mMarket.putAll(dartsFactory.getDartsMap());
        }
    }

    static void beforehand(Class ... classes) {
        for (Class cls : classes) {
            DartsLauncher.getDarts(cls);
        }
    }

    public static <T> T getDarts(Class<T> clazz) {
        if (clazz == null) {
            Log.e((String)TAG, (String)"getDarts >> create DartsImply instance fail, the reason is class in null ");
            return null;
        }
        T object = null;
        try {
            Darts darts = mMarket.get(clazz);
            if (darts != null && (object = (T)darts.getDartsInstance()) != null && object instanceof DartsTransfer && ((DartsTransfer)object).state.compareAndSet(false, true)) {
                ((DartsTransfer)object).onDartsCreated();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getDarts >> create DartsImply instance fail, the reason is " + e.getMessage()));
        }
        return object;
    }

    public static <T> boolean queryDartsDone(Class<T> clazz) {
        if (clazz != null) {
            Darts darts = mMarket.get(clazz);
            return darts != null && darts.instantiated();
        }
        return false;
    }
}

