/*
 * Decompiled with CFR 0.152.
 */
package com.yy.android.sniper.api.lurk.generater;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.TextView;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class IdentifierGenerater {
    private final String DecorView = "com.android.internal.policy.PhoneWindow$DecorView";
    private final String ListView = "android.widget.ListView";
    private final String ListView_Name = "ListView";
    private final String RecyclerView = "android.support.v7.widget.RecyclerView";
    private final String RecyclerView_Name = "RecyclerView";
    private final String UNKNOWN = "unknown";
    private final String CONNECTOR = "_";
    private Map<View, String> mFragmentNameMap = new WeakHashMap<View, String>();

    public void addFragmentName(View rootView, String fragmentName) {
        this.mFragmentNameMap.put(rootView, fragmentName);
    }

    public void removeFragmentName(String fragmentName) {
        View view = null;
        Set<Map.Entry<View, String>> set = this.mFragmentNameMap.entrySet();
        for (Map.Entry<View, String> entry : set) {
            if (!entry.getValue().equalsIgnoreCase(fragmentName)) continue;
            view = entry.getKey();
            break;
        }
        if (view != null) {
            this.mFragmentNameMap.remove(view);
        }
    }

    public String getListItemViewIdentifier(AdapterView<?> parent, View view, int position) {
        StringBuffer defaultName = new StringBuffer();
        defaultName.append(parent.getAdapter().getClass().getSimpleName());
        defaultName.append("[index:");
        defaultName.append(position);
        defaultName.append("]");
        defaultName.append("childView");
        return this.getViewIdentifier(view, defaultName.toString());
    }

    public String getOnClickViewIdentifier(View view) {
        return this.getViewIdentifier(view, String.format("%s<ResId:%s>", view.getClass().getSimpleName(), String.valueOf(view.getId())));
    }

    public String getViewIdentifier(View view, String defaultName) {
        String parentViewName;
        StringBuffer identifier = new StringBuffer();
        defaultName = this.getViewText(view, defaultName);
        if (!(view.getContext() instanceof Activity)) {
            identifier.append("unknown");
            identifier.append("_");
            identifier.append(defaultName);
            return identifier.toString();
        }
        identifier.append(view.getContext().getClass().getSimpleName());
        identifier.append("_");
        Log.e((String)"getViewIdentifier", (String)"parentView \u904d\u5386\u5f00\u59cb------->");
        for (ViewParent parentView = view.getParent(); parentView != null && !(parentViewName = parentView.getClass().getName()).equalsIgnoreCase("com.android.internal.policy.PhoneWindow$DecorView"); parentView = parentView.getParent()) {
            Log.e((String)"getViewIdentifier", (String)("parentView------->" + parentViewName));
            if (this.isFragmentRootView(parentView)) {
                identifier.append(this.mFragmentNameMap.get(parentView));
                identifier.append("_");
                identifier.append(defaultName);
                return identifier.toString();
            }
            if (parentViewName.equalsIgnoreCase("android.widget.ListView")) {
                identifier.append("ListView");
                identifier.append("_");
            } else if (parentViewName.equalsIgnoreCase("android.support.v7.widget.RecyclerView")) {
                identifier.append("RecyclerView");
                identifier.append("_");
            }
            if (!(parentView instanceof View)) continue;
            defaultName = this.getViewText((View)parentView, defaultName);
        }
        identifier.append(defaultName);
        return identifier.toString();
    }

    public String getViewText(View view, String defaultName) {
        if (view instanceof TextView && !((TextView)view).getText().toString().equalsIgnoreCase("")) {
            return String.format("%s[content:%s]", defaultName, ((TextView)view).getText().toString());
        }
        return defaultName;
    }

    public boolean isFragmentRootView(ViewParent viewParent) {
        return this.mFragmentNameMap.keySet().contains(viewParent);
    }
}

