/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.timeelapse;

import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.mobile.ui.widget.timeelapse.ITimeElapse;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class TimeElapseAdapter<T extends ITimeElapse>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    Queue<T> mData = new LinkedBlockingQueue<T>();
    Queue<T> mWaitingData = new LinkedBlockingQueue<T>();
    private final int mShowSize;
    private final int mDuration;
    private Runnable mTask;
    private List<Integer> mDelIndex = new CopyOnWriteArrayList<Integer>();
    Handler mMainHandler = new Handler(Looper.getMainLooper());
    private int mShowingSize = 0;
    private boolean isStarted = false;

    public TimeElapseAdapter(int showSize, int duration) {
        this.mShowSize = showSize;
        this.mDuration = duration;
        this.mTask = new Runnable(){

            @Override
            public void run() {
                ITimeElapse data;
                int index = 0;
                TimeElapseAdapter.this.mDelIndex.clear();
                Iterator it = TimeElapseAdapter.this.mWaitingData.iterator();
                while (it.hasNext()) {
                    data = (ITimeElapse)it.next();
                    data.timeElapse(TimeElapseAdapter.this.mDuration);
                    if (data.getRemainTime() >= 0) continue;
                    it.remove();
                }
                it = TimeElapseAdapter.this.mData.iterator();
                while (it.hasNext()) {
                    data = (ITimeElapse)it.next();
                    data.timeElapse(TimeElapseAdapter.this.mDuration);
                    if (data.getRemainTime() < 0) {
                        it.remove();
                        TimeElapseAdapter.this.mDelIndex.add(index);
                    }
                    ++index;
                }
                while (TimeElapseAdapter.this.mData.size() < TimeElapseAdapter.this.mShowSize && !TimeElapseAdapter.this.mWaitingData.isEmpty()) {
                    TimeElapseAdapter.this.mData.offer(TimeElapseAdapter.this.mWaitingData.poll());
                }
                if (TimeElapseAdapter.this.mDelIndex.size() > 0) {
                    Iterator iterator = TimeElapseAdapter.this.mDelIndex.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        TimeElapseAdapter.this.notifyItemRemoved(i);
                    }
                    TimeElapseAdapter.this.notifyItemRangeChanged(0, TimeElapseAdapter.this.getItemCount());
                } else if (TimeElapseAdapter.this.mShowingSize < TimeElapseAdapter.this.mShowSize && TimeElapseAdapter.this.mData.size() > TimeElapseAdapter.this.mShowingSize) {
                    while (TimeElapseAdapter.this.mShowingSize < TimeElapseAdapter.this.mData.size() && TimeElapseAdapter.this.mShowingSize < TimeElapseAdapter.this.mShowSize) {
                        ++TimeElapseAdapter.this.mShowingSize;
                        TimeElapseAdapter.this.notifyItemInserted(0);
                    }
                    TimeElapseAdapter.this.notifyItemRangeChanged(0, TimeElapseAdapter.this.getItemCount());
                } else {
                    TimeElapseAdapter.this.notifyDataSetChanged();
                }
                TimeElapseAdapter.this.mShowingSize = TimeElapseAdapter.this.getItemCount();
                TimeElapseAdapter.this.mMainHandler.removeCallbacks((Runnable)this);
                if (TimeElapseAdapter.this.hasMessage()) {
                    TimeElapseAdapter.this.mMainHandler.postDelayed((Runnable)this, (long)(TimeElapseAdapter.this.mDuration * 1000));
                }
            }
        };
    }

    public boolean hasMessage() {
        return !this.mData.isEmpty() || !this.mWaitingData.isEmpty();
    }

    public T getItem(int pos) {
        Iterator it = this.mData.iterator();
        int index = 0;
        while (it.hasNext()) {
            ITimeElapse data = (ITimeElapse)it.next();
            if (index == pos) {
                return (T)data;
            }
            ++index;
        }
        return null;
    }

    public void setData(Collection<T> datas) {
        this.mWaitingData.clear();
        if (datas != null) {
            this.mWaitingData.addAll(datas);
        }
        this.notifyDataSetChanged();
    }

    public void add(T data) {
        this.mWaitingData.offer(data);
    }

    public void remove(T data) {
        ITimeElapse t;
        int index = 0;
        Iterator iterator = this.mData.iterator();
        while (iterator.hasNext() && !(t = (ITimeElapse)iterator.next()).equals(data)) {
            ++index;
        }
        this.mData.remove(data);
        this.notifyItemRemoved(index);
        this.notifyItemRangeChanged(0, this.getItemCount());
    }

    public void clear() {
        this.mWaitingData.clear();
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        this.mMainHandler.removeCallbacks(this.mTask);
        this.mMainHandler.postDelayed(this.mTask, 0L);
        this.isStarted = true;
    }

    public void cancel() {
        this.mMainHandler.removeCallbacks(this.mTask);
        this.isStarted = false;
    }

    public abstract RecyclerView.ViewHolder onCreateViewHolder(ViewGroup var1, int var2);

    public abstract void onBindViewHolder(RecyclerView.ViewHolder var1, int var2);

    public int getItemCount() {
        return this.mShowSize < this.mData.size() ? this.mShowSize : this.mData.size();
    }

    public int getItemViewType(int position) {
        return this.getItem(position).viewType();
    }
}

