/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.reportbug;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.baseapi.common.YYAppInfoHolder;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;

public class ReportBugView
extends LinearLayout {
    static final byte[] lock = new byte[0];
    private static final String TAG = "ReportBugView";
    private static SoftReference<ReportBugView> instance;
    private final String packageName = "com.duowan.mobile";
    private WindowManager wm = (WindowManager)this.getContext().getApplicationContext().getSystemService("window");
    private WindowManager.LayoutParams wmParams = new WindowManager.LayoutParams();
    private ImageView logo;
    private View viewTarget;
    private float xInScreen;
    private float yInScreen;
    private float xDownInScreen;
    private float yDownInScreen;
    private float xInView;
    private float yInView;
    private int statusBarHeight = 0;
    private Context mContext;
    private boolean clickflag = false;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private YYAppInfoHolder.OnForegroundChangeListener onChangeListener = new YYAppInfoHolder.OnForegroundChangeListener(){

        public void back2Forground() {
            MLog.info((String)ReportBugView.TAG, (String)"--> in front");
            ReportBugView.this.setVisibility(0);
            ReportBugView.this.postInvalidate();
        }

        public void fore2Background() {
            MLog.info((String)ReportBugView.TAG, (String)"--> not in front");
            ReportBugView.this.setVisibility(4);
            ReportBugView.this.postInvalidate();
        }
    };

    private ReportBugView(Context context, String packageName) {
        super(context);
        this.mContext = context.getApplicationContext();
        this.setBackgroundColor(0);
        this.getBackground().setAlpha(200);
        this.logo = new ImageView(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        this.logo.setLayoutParams((ViewGroup.LayoutParams)params);
        this.logo.setImageResource(R.drawable.me_quick_report);
        this.viewTarget = this.logo;
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(0);
        this.viewTarget.setBackgroundDrawable((Drawable)drawable2);
        this.viewTarget.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ReportBugView.this.clickflag) {
                    ReportBugView.this.openBigWindow();
                }
            }
        });
        this.viewTarget.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        ReportBugView.this.xInView = event.getX();
                        ReportBugView.this.yInView = event.getY();
                        ReportBugView.this.xDownInScreen = event.getRawX();
                        ReportBugView.this.yDownInScreen = event.getRawY() - (float)ReportBugView.this.getStatusBarHeight();
                        ReportBugView.this.xInScreen = event.getRawX();
                        ReportBugView.this.yInScreen = event.getRawY() - (float)ReportBugView.this.getStatusBarHeight();
                        ReportBugView.this.clickflag = false;
                        break;
                    }
                    case 2: {
                        ReportBugView.this.xInScreen = event.getRawX();
                        ReportBugView.this.yInScreen = event.getRawY() - (float)ReportBugView.this.getStatusBarHeight();
                        ReportBugView.this.updateViewPosition();
                        return true;
                    }
                    case 1: {
                        if (!(Math.abs(ReportBugView.this.xDownInScreen - ReportBugView.this.xInScreen) < 50.0f) || !(Math.abs(ReportBugView.this.yDownInScreen - ReportBugView.this.yInScreen) < 50.0f)) break;
                        ReportBugView.this.clickflag = true;
                        break;
                    }
                }
                return false;
            }
        });
        this.addView(this.viewTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportBugView instance(Context context, String packageName) {
        if (instance == null || instance.get() == null) {
            byte[] byArray = lock;
            synchronized (lock) {
                ReportBugView reportBugView = new ReportBugView(context, packageName);
                instance = new SoftReference<ReportBugView>(reportBugView);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return instance.get();
            }
        }
        return instance.get();
    }

    private int dpTopx(Context context, int dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dp * scale + 0.5f);
    }

    public void removeFormStage() {
        MLog.info((String)TAG, (String)"removeFormStage");
        try {
            if (this.getParent() != null) {
                MLog.info((String)TAG, (String)"wm.removeViewImmediate(this);");
                this.stop();
                this.wm.removeViewImmediate((View)this);
            }
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (Throwable)t);
        }
    }

    protected void onDetachedFromWindow() {
        try {
            super.onDetachedFromWindow();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    private int getStatusBarHeight() {
        if (this.statusBarHeight == 0) {
            try {
                Class<?> c = Class.forName("com.android.internal.R$dimen");
                Object o = c.newInstance();
                Field field = c.getField("status_bar_height");
                int x = (Integer)field.get(o);
                this.statusBarHeight = this.getResources().getDimensionPixelSize(x);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return this.statusBarHeight;
    }

    private void openBigWindow() {
        MLog.info((String)TAG, (String)"click()");
        Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
        if (activity2 == null) {
            return;
        }
        String className = activity2.getLocalClassName();
        if (className.endsWith("suggest.SuggestActivity")) {
            return;
        }
        ARouter.getInstance().build("/PersonalCenter/Feedback").withBoolean("bug_report_entry", true).withFlags(0x10000000).navigation((Context)activity2);
    }

    @TargetApi(value=11)
    public void addToStage(int x, int y, int width, int height) {
        MLog.info((String)TAG, (String)"addToStage");
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.addToWindow();
        } else {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ReportBugView.this.addToWindow();
                }
            }, 2000L);
        }
    }

    private void addToWindow() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        if (wm == null) {
            MLog.error((String)TAG, (String)"wm is null");
            return;
        }
        if (this.getParent() != null) {
            MLog.info((String)TAG, (String)"wm.removeView(this)");
            wm.removeView((View)this);
        }
        int screenWidth = wm.getDefaultDisplay().getWidth();
        int screenHeight = wm.getDefaultDisplay().getHeight();
        if (this.wmParams == null) {
            this.wmParams = new WindowManager.LayoutParams();
        }
        this.wmParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2003;
        this.wmParams.format = 1;
        this.wmParams.flags = 40;
        this.wmParams.gravity = 51;
        this.wmParams.width = this.dpTopx(this.mContext, 48);
        this.wmParams.height = this.dpTopx(this.mContext, 48);
        MLog.info((String)TAG, (String)("" + this.wmParams.width + " " + this.wmParams.height));
        MLog.info((String)TAG, (String)("" + this.viewTarget.getWidth() + " " + this.viewTarget.getHeight()));
        this.wmParams.x = screenWidth;
        this.wmParams.y = screenHeight / 2;
        wm.addView((View)this, (ViewGroup.LayoutParams)this.wmParams);
        this.start();
    }

    private void updateViewPosition() {
        this.wmParams.x = (int)(this.xInScreen - this.xInView);
        this.wmParams.y = (int)(this.yInScreen - this.yInView);
        this.wm.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.wmParams);
    }

    private void stop() {
        YYAppInfoHolder.removeOnForegoundChangeListener((YYAppInfoHolder.OnForegroundChangeListener)this.onChangeListener);
    }

    private void start() {
        YYAppInfoHolder.addOnForegroundChangeListener((YYAppInfoHolder.OnForegroundChangeListener)this.onChangeListener);
    }
}

