/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker.loader.photo;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.ui.widget.photopicker.PhotoInfo;
import com.yy.mobile.ui.widget.photopicker.loader.permission.PhotoPermissionUtil;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoCallback;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoCursorLoader;
import com.yy.mobile.util.BuildCompat;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PhotoLoaderHelper
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final String TAG = "PhotoLoaderHelper";
    private static final int ID = 1000;
    private static final String KEY_BUCKET_ID = "bucketId";
    private Activity mActivity;
    private LoaderManager mLoaderManager;
    private int curMaxLoaderId = 1000;
    private int curLoaderId = 0;
    private PhotoCallback mCallback;
    private Map<String, Integer> bucketIdMap = new HashMap<String, Integer>();
    private List<PhotoInfo> mPhotoInfoList = new ArrayList<PhotoInfo>();

    public PhotoLoaderHelper(@NonNull FragmentActivity activity2, @Nullable PhotoCallback callback) {
        this.mCallback = callback;
        this.mActivity = activity2;
        this.mLoaderManager = LoaderManager.getInstance((LifecycleOwner)activity2);
    }

    public PhotoLoaderHelper(@NonNull Fragment fragment, @Nullable PhotoCallback callback) {
        this.mCallback = callback;
        this.mActivity = fragment.getActivity();
        this.mLoaderManager = LoaderManager.getInstance((LifecycleOwner)fragment);
    }

    public void startLoad() {
        boolean activityValid = ActivityCheckUtils.checkActivityValid((Activity)this.mActivity);
        MLog.info((Object)TAG, (String)"startLoad: activityValid:%b", (Object[])new Object[]{activityValid});
        if (!activityValid) {
            return;
        }
        PhotoPermissionUtil.checkPermission((Context)this.mActivity, new PhotoPermissionUtil.PermissionCallback(){

            @Override
            public void onGetPermission(boolean userGranted) {
                PhotoLoaderHelper.this.curLoaderId = 1000;
                PhotoLoaderHelper.this.mLoaderManager.initLoader(1000, null, (LoaderManager.LoaderCallbacks)PhotoLoaderHelper.this);
            }
        });
    }

    public void startLoad(final String bucketId) {
        boolean activityValid = ActivityCheckUtils.checkActivityValid((Activity)this.mActivity);
        MLog.info((Object)TAG, (String)"startLoad with bucketId: activityValid:%b", (Object[])new Object[]{activityValid});
        if (!activityValid) {
            return;
        }
        PhotoPermissionUtil.checkPermission((Context)this.mActivity, new PhotoPermissionUtil.PermissionCallback(){

            @Override
            public void onGetPermission(boolean userGranted) {
                Integer loaderManagerId = (Integer)PhotoLoaderHelper.this.bucketIdMap.get(bucketId);
                if (loaderManagerId == null) {
                    loaderManagerId = PhotoLoaderHelper.this.curMaxLoaderId + 1;
                    PhotoLoaderHelper.this.bucketIdMap.put(bucketId, loaderManagerId);
                    PhotoLoaderHelper.this.curMaxLoaderId++;
                }
                MLog.info((Object)PhotoLoaderHelper.TAG, (String)"startLoad: bucketId:%s, loaderManagerId:%d", (Object[])new Object[]{bucketId, loaderManagerId});
                PhotoLoaderHelper.this.curLoaderId = loaderManagerId;
                Bundle args = new Bundle();
                args.putString(PhotoLoaderHelper.KEY_BUCKET_ID, bucketId);
                PhotoLoaderHelper.this.mLoaderManager.initLoader(loaderManagerId.intValue(), args, (LoaderManager.LoaderCallbacks)PhotoLoaderHelper.this);
            }
        });
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, @Nullable Bundle args) {
        String bucketId;
        if (args != null && !FP.empty((CharSequence)(bucketId = args.getString(KEY_BUCKET_ID)))) {
            MLog.info((Object)TAG, (String)"onCreateLoader: bucketId:%s, id:%d", (Object[])new Object[]{bucketId, id2});
            return PhotoCursorLoader.newInstance((Context)this.mActivity, bucketId);
        }
        MLog.info((Object)TAG, (String)"onCreateLoader: id:%d", (Object[])new Object[]{id2});
        return PhotoCursorLoader.newInstance((Context)this.mActivity);
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor cursor) {
        if (this.curLoaderId != loader.getId()) {
            return;
        }
        ArrayList<PhotoInfo> data = new ArrayList<PhotoInfo>();
        try {
            if (cursor != null) {
                cursor.moveToPosition(-1);
                while (cursor.moveToNext()) {
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String id2 = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                    PhotoInfo info = new PhotoInfo();
                    info.image = image;
                    if (!PhotoLoaderHelper.isFileExisted(info.image, id2)) continue;
                    data.add(info);
                }
            }
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (String)"onLoadFinished: exception:", (Throwable)t, (Object[])new Object[0]);
        }
        Collections.reverse(data);
        this.mPhotoInfoList = new ArrayList<PhotoInfo>(data);
        MLog.info((Object)TAG, (String)"onLoadFinished: mPhotoInfoList size:%d", (Object[])new Object[]{this.mPhotoInfoList.size()});
        if (this.mCallback != null) {
            this.mCallback.onPhotoInfo(data);
        }
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
        MLog.info((Object)TAG, (String)"onLoaderReset: loader:%d", (Object[])new Object[]{loader.getId()});
    }

    public List<PhotoInfo> getPhotos() {
        return this.mPhotoInfoList;
    }

    private static boolean isFileExisted(String image, String id2) {
        if (BuildCompat.isIsolatedStorage()) {
            Uri uri = Uri.parse((String)(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString() + File.separator + id2));
            try {
                ParcelFileDescriptor parcelFileDescriptor = BasicConfig.getInstance().getAppContext().getContentResolver().openFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            MLog.debug((String)TAG, (String)("photoUri:" + uri));
            return true;
        }
        return YYFileUtils.isFileExisted((String)image);
    }
}

