/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker.loader.album;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.ui.widget.photopicker.AlbumInfo;
import com.yy.mobile.ui.widget.photopicker.loader.album.AlbumCallback;
import com.yy.mobile.ui.widget.photopicker.loader.album.AlbumCursorLoader;
import com.yy.mobile.ui.widget.photopicker.loader.permission.PhotoPermissionUtil;
import com.yy.mobile.util.log.MLog;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AlbumLoaderHelper
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final String TAG = "AlbumLoaderHelper";
    private static final int ID = 2000;
    private Activity mActivity;
    private LoaderManager mLoaderManager;
    private AlbumCallback mCallback;

    public AlbumLoaderHelper(@NonNull FragmentActivity activity2, @Nullable AlbumCallback callback) {
        this.mCallback = callback;
        this.mActivity = activity2;
        this.mLoaderManager = LoaderManager.getInstance((LifecycleOwner)activity2);
    }

    public AlbumLoaderHelper(@NonNull Fragment fragment, @Nullable AlbumCallback callback) {
        this.mCallback = callback;
        this.mActivity = fragment.getActivity();
        this.mLoaderManager = LoaderManager.getInstance((LifecycleOwner)fragment);
    }

    public void startLoad() {
        boolean activityValid = ActivityCheckUtils.checkActivityValid((Activity)this.mActivity);
        MLog.info((Object)TAG, (String)"startLoad: activityValid:%b", (Object[])new Object[]{activityValid});
        if (!activityValid) {
            return;
        }
        PhotoPermissionUtil.checkPermission((Context)this.mActivity, new PhotoPermissionUtil.PermissionCallback(){

            @Override
            public void onGetPermission(boolean userGranted) {
                AlbumLoaderHelper.this.mLoaderManager.initLoader(2000, null, (LoaderManager.LoaderCallbacks)AlbumLoaderHelper.this);
            }
        });
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, @Nullable Bundle args) {
        MLog.info((Object)TAG, (String)"onCreateLoader: id:%d", (Object[])new Object[]{id2});
        return AlbumCursorLoader.newInstance((Context)this.mActivity);
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor cursor) {
        if (2000 != loader.getId()) {
            return;
        }
        ArrayList<AlbumInfo> data = new ArrayList<AlbumInfo>();
        try {
            if (cursor != null) {
                cursor.moveToPosition(-1);
                while (cursor.moveToNext()) {
                    String folderName = cursor.getString(cursor.getColumnIndexOrThrow("bucket_display_name"));
                    int count = cursor.getInt(3);
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String bucketId = cursor.getString(cursor.getColumnIndexOrThrow("bucket_id"));
                    int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                    AlbumInfo info = new AlbumInfo();
                    info.folder = folderName;
                    info.count = count;
                    info.image = image;
                    info.bucketId = bucketId;
                    info.imageId = id2;
                    data.add(info);
                }
            }
            this.sortAlbum(data);
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (String)"onLoadFinished: exception:", (Throwable)t, (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)"onLoadFinished: data size:%d", (Object[])new Object[]{data.size()});
        if (this.mCallback != null) {
            this.mCallback.onAlbumInfo(data);
        }
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
        MLog.info((String)TAG, (String)"onLoaderReset");
    }

    private void sortAlbum(@NonNull List<AlbumInfo> albumInfoList) {
        Collections.sort(albumInfoList, new Comparator<AlbumInfo>(){

            @Override
            public int compare(AlbumInfo lhs, AlbumInfo rhs) {
                if (lhs.folder.trim().equalsIgnoreCase("Camera") || lhs.folder.trim().equals("\u76f8\u673a")) {
                    return -1;
                }
                if (rhs.folder.trim().equalsIgnoreCase("Camera") || rhs.folder.trim().equals("\u76f8\u673a")) {
                    return 1;
                }
                if (lhs.folder.trim().equalsIgnoreCase("DCIM")) {
                    return -1;
                }
                if (rhs.folder.trim().equalsIgnoreCase("DCIM")) {
                    return 1;
                }
                if (lhs.folder.trim().equalsIgnoreCase("Screenshots") || lhs.folder.trim().equals("\u622a\u5c4f")) {
                    return -1;
                }
                if (rhs.folder.trim().equalsIgnoreCase("Screenshots") || rhs.folder.trim().equals("\u622a\u5c4f")) {
                    return 1;
                }
                Collator collator = Collator.getInstance();
                CollationKey key1 = collator.getCollationKey(lhs.folder.trim().toLowerCase());
                CollationKey key2 = collator.getCollationKey(rhs.folder.trim().toLowerCase());
                return key1.compareTo(key2);
            }
        });
    }
}

