/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.gallery.ImagePagerFragment;
import com.yy.mobile.ui.widget.dialog.TitleAndMessageKnownDialog;
import com.yy.mobile.ui.widget.photopicker.CheckView;
import com.yy.mobile.ui.widget.photopicker.DataHolder;
import com.yy.mobile.ui.widget.photopicker.PhotoInfo;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoCallback;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoLoaderHelper;
import com.yy.mobile.util.FP;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PhotoPickPreviewActivity
extends BaseActivity
implements PhotoCallback,
ImagePagerFragment.OnImageChangeListener,
CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    private ArrayList<PhotoInfo> mData;
    private int mCurrentPosition;
    private int mAmount;
    private int maxSize = Integer.MAX_VALUE;
    private int mOtherSelectedCount;
    private ImagePagerFragment mImagePager;
    private CheckBox mCurrentImageCheckbox;
    private CheckView mCurrentImageCheckview;
    private ImageView mBackBtn;
    private Button mFinishBtn;
    private boolean needTouchSort;
    private ArrayList<String> recordList;
    private String mFlagOfJump = "";

    @SuppressLint(value={"SetTextI18n"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.photo_pick_preview);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        this.mCurrentImageCheckbox = (CheckBox)this.findViewById(R.id.photo_pick_preview_check);
        this.mCurrentImageCheckview = (CheckView)this.findViewById(R.id.photo_pick_preview_check_1);
        this.mBackBtn = (ImageView)this.findViewById(R.id.photo_pick_preview_back);
        this.mFinishBtn = (Button)this.findViewById(R.id.photo_pick_preview_finish);
        if (this.getIntent().hasExtra("params_picture_flag_of_jump")) {
            this.mFlagOfJump = this.getIntent().getStringExtra("params_picture_flag_of_jump");
        }
        if ("comment".equals(this.mFlagOfJump)) {
            this.mFinishBtn.setText((CharSequence)"\u786e\u5b9a(0)");
            this.mCurrentImageCheckview.setVisibility(0);
            this.mCurrentImageCheckbox.setVisibility(8);
        } else {
            this.mCurrentImageCheckbox.setVisibility(0);
            this.mCurrentImageCheckview.setVisibility(8);
        }
        this.mData = "comment".equals(this.mFlagOfJump) ? DataHolder.getInstance().getImageListData() : data.getParcelableArrayList("params_preview_photos");
        if (this.mData == null || this.mData.isEmpty()) {
            this.finish();
            return;
        }
        this.mCurrentPosition = data.getInt("params_preview_position");
        this.needTouchSort = data.getBoolean("params_touch_sort", false);
        this.recordList = new ArrayList();
        PhotoInfo info = this.mData.get(this.mCurrentPosition);
        if (info != null) {
            this.mCurrentImageCheckbox.setChecked(info.selected);
        }
        this.mCurrentImageCheckbox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mCurrentImageCheckview.setOnClickListener(this);
        this.mBackBtn.setOnClickListener((View.OnClickListener)this);
        this.mFinishBtn.setOnClickListener((View.OnClickListener)this);
        this.mFinishBtn.setEnabled(this.getSelectedData().size() > 0);
        this.mAmount = data.getInt("params_picture_amount", 0);
        this.maxSize = data.getInt("params_picture_max_size", Integer.MAX_VALUE);
        ArrayList selectedPaths = data.getStringArrayList("params_selected_paths");
        if (!FP.empty((Collection)selectedPaths)) {
            this.mOtherSelectedCount = selectedPaths.size();
            this.recordList.addAll(selectedPaths);
        }
        if ("comment".equals(this.mFlagOfJump) && this.recordList.size() > 0) {
            for (int i = 0; i < this.recordList.size(); ++i) {
                if (info == null || !info.image.equals(this.recordList.get(i)) || !info.selected) continue;
                this.mCurrentImageCheckview.setChecked(true);
                this.mCurrentImageCheckview.setCheckNum(i + 1);
                break;
            }
            if (this.recordList.size() > 0) {
                this.mFinishBtn.setEnabled(true);
                this.mFinishBtn.setText((CharSequence)("\u786e\u5b9a(" + this.recordList.size() + ")"));
            } else {
                this.mFinishBtn.setEnabled(false);
                this.mFinishBtn.setText((CharSequence)"\u786e\u5b9a(0)");
            }
        }
        if (this.mData == null || this.mData.isEmpty()) {
            String bucketId = data.getString("params_bucket_id");
            if (!TextUtils.isEmpty((CharSequence)bucketId)) {
                new PhotoLoaderHelper((FragmentActivity)this, (PhotoCallback)this).startLoad(bucketId);
            }
        } else {
            this.showGallery();
        }
    }

    @Override
    public void onPhotoInfo(List<PhotoInfo> data) {
        this.mData = new ArrayList<PhotoInfo>(data);
        this.showGallery();
    }

    private void showGallery() {
        ArrayList<String> mImagePaths = new ArrayList<String>(this.mData.size());
        for (PhotoInfo info : this.mData) {
            mImagePaths.add(info.image);
        }
        this.mImagePager = ImagePagerFragment.newInstance(mImagePaths, (int)this.mCurrentPosition);
        this.mImagePager.setOnImageChangeListener((ImagePagerFragment.OnImageChangeListener)this);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.photo_pick_preview_gallery, (Fragment)this.mImagePager).commitAllowingStateLoss();
    }

    public void onImageChange(int currentPosition, int totalCount, String currentUrl) {
        this.mCurrentImageCheckbox.setOnCheckedChangeListener(null);
        this.mCurrentImageCheckbox.setChecked(this.mData.get((int)currentPosition).selected);
        this.mCurrentImageCheckbox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        PhotoInfo info = this.mData.get(currentPosition);
        this.mCurrentImageCheckview.setChecked(false);
        if ("comment".equals(this.mFlagOfJump) && this.recordList.size() > 0) {
            for (int i = 0; i < this.recordList.size(); ++i) {
                if (info == null || !info.image.equals(this.recordList.get(i)) || !info.selected) continue;
                this.mCurrentImageCheckview.setChecked(true);
                this.mCurrentImageCheckview.setCheckNum(i + 1);
                break;
            }
        }
        this.mCurrentPosition = currentPosition;
    }

    public void onNextRequest() {
    }

    public void onPrevRequest() {
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        PhotoInfo photoInfo = this.mData.get(this.mCurrentPosition);
        if (this.needTouchSort) {
            if (isChecked) {
                if (this.recordList.size() + 1 > this.mAmount) {
                    buttonView.setChecked(false);
                    this.getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(this.getString(R.string.str_photos_dialog_limit_title), String.format(this.getString(R.string.str_photos_selected_limit), this.mAmount), true, null));
                    return;
                }
                if (!FP.empty((CharSequence)photoInfo.image) && new File(photoInfo.image).length() > (long)this.maxSize) {
                    buttonView.setChecked(false);
                    this.getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(this.getString(R.string.str_photos_dialog_limit_title), String.format(this.getString(R.string.str_photos_selected_size_limit), FP.formatSize((int)this.maxSize)), true, null));
                }
                this.recordList.add(this.mData.get((int)this.mCurrentPosition).image);
            } else {
                for (String path : this.recordList) {
                    if (!path.equals(this.mData.get((int)this.mCurrentPosition).image)) continue;
                    this.recordList.remove(path);
                }
            }
        } else if (isChecked && this.mOtherSelectedCount + this.getSelectedData().size() >= this.mAmount) {
            buttonView.setChecked(false);
            this.getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(this.getString(R.string.str_photos_dialog_limit_title), String.format(this.getString(R.string.str_photos_selected_limit), this.mAmount), true, null));
        } else if (!FP.empty((CharSequence)photoInfo.image) && new File(photoInfo.image).length() > (long)this.maxSize) {
            buttonView.setChecked(false);
            this.getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(this.getString(R.string.str_photos_dialog_limit_title), String.format(this.getString(R.string.str_photos_selected_size_limit), FP.formatSize((int)this.maxSize)), true, null));
        } else {
            this.mData.get((int)this.mCurrentPosition).selected = isChecked;
        }
        this.mFinishBtn.setEnabled(this.getSelectedData().size() > 0);
    }

    public ArrayList<PhotoInfo> getSelectedData() {
        ArrayList<PhotoInfo> selected = new ArrayList<PhotoInfo>();
        for (PhotoInfo info : this.mData) {
            if (!info.selected) continue;
            selected.add(info);
        }
        return selected;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.photo_pick_preview_back) {
            Intent data = new Intent();
            if (!"comment".equals(this.mFlagOfJump)) {
                data.putParcelableArrayListExtra("result_preview_photos", this.mData);
            }
            if (this.needTouchSort) {
                data.putStringArrayListExtra("params_preview_choice_photos", this.recordList);
            }
            this.setResult(-1, data);
            this.finish();
        } else if (id2 == R.id.photo_pick_preview_finish) {
            Intent data2 = new Intent();
            if ("comment".equals(this.mFlagOfJump)) {
                data2.putStringArrayListExtra("params_preview_choice_photos", this.recordList);
                data2.putExtra("result_preview_finish_pick", true);
                this.setResult(-1, data2);
                this.finish();
            } else {
                data2.putParcelableArrayListExtra("result_preview_photos", this.mData);
                if (this.needTouchSort) {
                    data2.putStringArrayListExtra("params_preview_choice_photos", this.recordList);
                }
                data2.putExtra("result_preview_finish_pick", true);
                this.setResult(-1, data2);
                this.finish();
            }
        } else if (id2 == R.id.photo_pick_preview_check_1) {
            this.dealWithPhotoPickCheck();
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    private void dealWithPhotoPickCheck() {
        PhotoInfo info = this.mData.get(this.mCurrentPosition);
        if (this.mCurrentImageCheckview.isChecked()) {
            for (int i = 0; i < this.recordList.size(); ++i) {
                if (info == null || !info.image.equals(this.recordList.get(i)) || !info.selected) continue;
                info.selected = false;
                this.recordList.remove(i);
                break;
            }
            this.mCurrentImageCheckview.setChecked(false);
        } else {
            if (this.recordList.size() + 1 > this.mAmount) {
                this.getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(this.getString(R.string.str_photos_dialog_limit_title), String.format(this.getString(R.string.str_photos_selected_limit), this.mAmount), true, null));
                return;
            }
            info.selected = true;
            this.recordList.add(info.image);
            this.mCurrentImageCheckview.setChecked(true);
            this.mCurrentImageCheckview.setCheckNum(this.recordList.size());
        }
        if (this.recordList.size() > 0) {
            this.mFinishBtn.setEnabled(true);
            this.mFinishBtn.setText((CharSequence)("\u786e\u5b9a(" + this.recordList.size() + ")"));
        } else {
            this.mFinishBtn.setEnabled(false);
            this.mFinishBtn.setText((CharSequence)"\u786e\u5b9a(0)");
        }
    }

    public void onBackPressed() {
        Intent data = new Intent();
        if ("comment".equals(this.mFlagOfJump)) {
            data.putStringArrayListExtra("params_preview_choice_photos", this.recordList);
        }
        this.setResult(-1, data);
        super.onBackPressed();
    }

    protected boolean handleStatusBar() {
        this.immersionBar = ImmersionBar.with((Activity)this).fitsSystemWindows(true).statusBarColor(17170444).init();
        return true;
    }
}

