/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.content.CursorLoader;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.runtime.Permission;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.policy.dialog.IPerConstantKt;
import com.yy.mobile.ui.widget.photopicker.AlbumInfo;
import com.yy.mobile.ui.widget.photopicker.IPhotoPickCallback;
import com.yy.mobile.ui.widget.photopicker.PhotoInfo;
import com.yy.mobile.util.BuildCompat;
import com.yy.mobile.util.SafeDispatchHandlerUtil;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class PhotoPickHelper {
    private static final String TAG = "PhotoPickHelper";
    private List<AlbumInfo> mAlbumInfos = new ArrayList<AlbumInfo>();
    private List<PhotoInfo> mPhotoInfos = new ArrayList<PhotoInfo>();
    private static PhotoPickHelper sInstance;

    private PhotoPickHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhotoPickHelper getInstance() {
        if (sInstance != null) return sInstance;
        Class<PhotoPickHelper> clazz = PhotoPickHelper.class;
        synchronized (PhotoPickHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PhotoPickHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void queryLocalAlbum(final Context context, final IPhotoPickCallback client) {
        if (AndPermission.hasPermissions((Context)context, (String[])Permission.Group.STORAGE)) {
            this.queryLocalAlbumInternal(context, client);
            return;
        }
        Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put("source", "-1");
        IPerConstantKt.showStoragePermissionDialog((Activity)activity2, (Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((String)PhotoPickHelper.TAG, (String)"\u76f8\u518c\u5165\u53e3\uff1a");
                PhotoPickHelper.this.queryLocalAlbumInternal(context, client);
            }
        }, null, statMap);
    }

    public void queryLocalAlbumInternal(Context context, IPhotoPickCallback client) {
        ArrayList<AlbumInfo> data = new ArrayList<AlbumInfo>();
        String[] imageColumns = new String[]{"_id", "bucket_display_name", "bucket_id", "count(_id)", "_data"};
        String groupby = " 1=1 ) group by (bucket_id";
        try {
            CursorLoader loader = new CursorLoader(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, imageColumns, groupby, null, null);
            Cursor cursor = loader.loadInBackground();
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String folderName = cursor.getString(cursor.getColumnIndexOrThrow("bucket_display_name"));
                    int count = cursor.getInt(3);
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String bucketId = cursor.getString(cursor.getColumnIndexOrThrow("bucket_id"));
                    int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                    AlbumInfo info = new AlbumInfo();
                    info.folder = folderName;
                    info.count = count;
                    info.image = image;
                    info.bucketId = bucketId;
                    info.imageId = id2;
                    data.add(info);
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)TAG, (String)("xuwakao, id = " + id2));
                    }
                    if (MLog.isLogLevelAboveVerbose()) continue;
                    MLog.verbose((String)TAG, (String)("xuwakao, AlbumInfo = " + info));
                }
                if (!cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        catch (SecurityException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        try {
            Collections.sort(data, new Comparator<AlbumInfo>(){

                @Override
                public int compare(AlbumInfo lhs, AlbumInfo rhs) {
                    if (lhs.folder.trim().equalsIgnoreCase("Camera") || lhs.folder.trim().equals("\u76f8\u673a")) {
                        return -1;
                    }
                    if (rhs.folder.trim().equalsIgnoreCase("Camera") || rhs.folder.trim().equals("\u76f8\u673a")) {
                        return 1;
                    }
                    if (lhs.folder.trim().equalsIgnoreCase("DCIM")) {
                        return -1;
                    }
                    if (rhs.folder.trim().equalsIgnoreCase("DCIM")) {
                        return 1;
                    }
                    if (lhs.folder.trim().equalsIgnoreCase("Screenshots") || lhs.folder.trim().equals("\u622a\u5c4f")) {
                        return -1;
                    }
                    if (rhs.folder.trim().equalsIgnoreCase("Screenshots") || rhs.folder.trim().equals("\u622a\u5c4f")) {
                        return 1;
                    }
                    Collator collator = Collator.getInstance();
                    CollationKey key1 = collator.getCollationKey(lhs.folder.trim().toLowerCase());
                    CollationKey key2 = collator.getCollationKey(rhs.folder.trim().toLowerCase());
                    return key1.compareTo(key2);
                }
            });
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        this.mAlbumInfos.clear();
        this.mAlbumInfos.addAll(data);
        client.onAlbumInfos(data);
    }

    public void queryAllPhotos(final Context context, final IPhotoPickCallback client) {
        if (AndPermission.hasPermissions((Context)context, (String[])Permission.Group.STORAGE)) {
            this.queryAllPhotosInternal(context, client);
            return;
        }
        Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put("source", "-1");
        IPerConstantKt.showStoragePermissionDialog((Activity)activity2, (Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((String)PhotoPickHelper.TAG, (String)"\u76f8\u518c\u5165\u53e3\uff1a");
                PhotoPickHelper.this.queryAllPhotosInternal(context, client);
            }
        }, null, statMap);
    }

    private void queryAllPhotosInternal(Context context, final IPhotoPickCallback client) {
        final ArrayList<PhotoInfo> data = new ArrayList<PhotoInfo>();
        String[] imageColumns = new String[]{"_id", "_data", "orientation"};
        CursorLoader loader = new CursorLoader(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, imageColumns, null, null, "date_modified");
        try {
            Cursor cursor = loader.loadInBackground();
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String id2 = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                    PhotoInfo info = new PhotoInfo();
                    info.image = image;
                    if (!PhotoPickHelper.isFileExisted(info.image, id2)) continue;
                    data.add(info);
                }
                if (!cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        catch (IOException | SecurityException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (data != null) {
            this.mPhotoInfos.clear();
            Collections.reverse(data);
            this.mPhotoInfos.addAll(data);
        }
        SafeDispatchHandlerUtil.runOnMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((String)PhotoPickHelper.TAG, (String)"queryAllPhotosInternal start");
                if (client instanceof LifecycleOwner) {
                    boolean isActive = ((LifecycleOwner)client).getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
                    MLog.info((String)PhotoPickHelper.TAG, (String)("queryAllPhotosInternal isActive = " + isActive));
                    if (isActive) {
                        client.onPhotoInfos(data);
                    }
                }
            }
        });
    }

    public void queryPhotos(final Context context, final String bucketId, final IPhotoPickCallback client) {
        if (AndPermission.hasPermissions((Context)context, (String[])Permission.Group.STORAGE)) {
            this.queryPhotosInternal(context, bucketId, client);
            return;
        }
        Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put("source", "-1");
        IPerConstantKt.showStoragePermissionDialog((Activity)activity2, (Runnable)new Runnable(){

            @Override
            public void run() {
                PhotoPickHelper.this.queryPhotosInternal(context, bucketId, client);
            }
        }, null, statMap);
    }

    private void queryPhotosInternal(Context context, String bucketId, IPhotoPickCallback client) {
        ArrayList<PhotoInfo> data = new ArrayList<PhotoInfo>();
        String[] imageColumns = new String[]{"_id", "_data", "orientation"};
        String selection = "bucket_id=?";
        String[] selectionArgs = new String[]{String.valueOf(bucketId)};
        CursorLoader loader = new CursorLoader(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, imageColumns, selection, selectionArgs, "date_modified");
        try {
            Cursor cursor = loader.loadInBackground();
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String id2 = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                    PhotoInfo info = new PhotoInfo();
                    info.image = image;
                    if (PhotoPickHelper.isFileExisted(info.image, id2)) {
                        data.add(info);
                    }
                    if (MLog.isLogLevelAboveVerbose()) continue;
                    MLog.verbose((String)TAG, (String)("xuwakao, PhotoInfo = " + info));
                }
                if (!cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        catch (IOException | SecurityException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (data != null) {
            this.mPhotoInfos.clear();
            Collections.reverse(data);
            this.mPhotoInfos.addAll(data);
        }
        MLog.info((String)TAG, (String)"queryPhotosInternal start");
        if (client instanceof LifecycleOwner) {
            boolean isActive = ((LifecycleOwner)client).getLifecycle().getCurrentState() != Lifecycle.State.DESTROYED;
            MLog.info((String)TAG, (String)("queryPhotosInternal isActive = " + isActive));
            if (isActive) {
                client.onPhotoInfos(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFileExisted(String image, String id2) throws IOException {
        if (BuildCompat.isIsolatedStorage()) {
            Uri uri = Uri.parse((String)(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString() + File.separator + id2));
            try (ParcelFileDescriptor descriptor = null;){
                descriptor = BasicConfig.getInstance().getAppContext().getContentResolver().openFileDescriptor(uri, "r");
            }
            MLog.debug((String)TAG, (String)("photoUri:" + uri));
            return true;
        }
        return YYFileUtils.isFileExisted((String)image);
    }

    public List<AlbumInfo> getAlbumInfos() {
        return this.mAlbumInfos;
    }

    public List<PhotoInfo> getPhotoInfos() {
        return this.mPhotoInfos;
    }
}

