/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.profile.takephoto.GetImagePathUtil;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.YYImageUtils;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.dialog.TitleAndMessageKnownDialog;
import com.yy.mobile.ui.widget.photopicker.AlbumPickActivity;
import com.yy.mobile.ui.widget.photopicker.PhotoInfo;
import com.yy.mobile.ui.widget.photopicker.PhotoPickActivity;
import com.yy.mobile.ui.widget.photopicker.PhotoPickPreviewActivity;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoCallback;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoLoaderHelper;
import com.yy.mobile.util.BuildCompat;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SandBoxCommonUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PhotoPickFragment
extends BaseLinkFragment
implements PhotoCallback {
    private static final String TAG = "PhotoPickFragment";
    private ListView mListView;
    private PhotoAdapter mAdapter;
    private List<PhotoInfo> mData = new ArrayList<PhotoInfo>();
    public static final int IMAGE_CAPTURE_REPUEST_CODE = 0;
    public static final int IMAGE_GALLERY_REPUEST_CODE = 1;
    public static final int IMAGE_CAPTURE_ID = 0;
    private static final String CAMERA_PREFIX = "pic_";
    private View mAlbums;
    private TextView mCount;
    private TextView mComplete;
    private RelativeLayout mAlbumConfirm;
    private int mItemCheckBoxStyle = 0;
    private int mAmount = 0;
    private String bucketId;
    private String mFolderName;
    private boolean isFromCover;
    private boolean isFromQrcodeScan;
    private static String keyOfQrCodePath;
    private boolean needTouchSort;
    private boolean mIsLandscape;
    private PhotoLoaderHelper mPhotoLoaderHelper;
    public DataChangedListener mChanged = new DataChangedListener(){

        @Override
        public void dataChanged() {
            int count = PhotoPickFragment.this.mAdapter.getSelectedData().size();
            int otherCount = PhotoPickFragment.this.mAdapter.getOtherSelectedPahts().size();
            int totalCount = count + otherCount;
            if (PhotoPickFragment.this.needTouchSort) {
                totalCount = PhotoPickFragment.this.mAdapter.getChoicePicList().size();
            }
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)PhotoPickFragment.TAG, (String)("xuwakao, count = " + totalCount));
            }
            String text = totalCount + "/" + PhotoPickFragment.this.mAmount;
            PhotoPickFragment.this.mCount.setText((CharSequence)text);
            PhotoPickFragment.this.mComplete.setEnabled(totalCount > 0);
        }

        @Override
        public void itemSelectted(String path) {
            ((PhotoPickActivity)PhotoPickFragment.this.getActivity()).onGetEditPhotos(path, false);
        }

        @Override
        public void capturePicSelectted() {
            ((PhotoPickActivity)PhotoPickFragment.this.getActivity()).takePhotoFromCamera();
        }
    };

    public static PhotoPickFragment newInstance(Bundle extras) {
        PhotoPickFragment fragment = new PhotoPickFragment();
        fragment.setArguments(extras);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPhotoLoaderHelper = new PhotoLoaderHelper((Fragment)this, (PhotoCallback)this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.layout_sharp_girl_pick_photos, container, false);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getArguments();
        this.mAmount = data.getInt("params_picture_amount", 1);
        this.mItemCheckBoxStyle = data.getInt("params_item_checkbox_style", 0);
        this.bucketId = data.getString("params_bucket_id");
        this.isFromCover = data.getBoolean("params_preview_cover", false);
        this.isFromQrcodeScan = data.getBoolean("params_qrcode_scan", false);
        this.needTouchSort = data.getBoolean("params_touch_sort", false);
        ArrayList selectedPaths = data.getStringArrayList("params_selected_paths");
        this.mIsLandscape = data.getBoolean("params_request_landscape", false);
        keyOfQrCodePath = data.getString("params_qrcode_pic_path", "");
        this.mListView = (ListView)view.findViewById(R.id.listview);
        this.mAlbumConfirm = (RelativeLayout)view.findViewById(R.id.albums_confirm);
        this.mAdapter = new PhotoAdapter((Fragment)this, this.mAmount, this.mItemCheckBoxStyle, this.bucketId, selectedPaths, this.needTouchSort, data.getInt("params_picture_max_size", Integer.MAX_VALUE));
        this.mAdapter.setDataChanged(this.mChanged);
        this.mAdapter.setIsFromCover(this.isFromCover);
        this.mAdapter.setIsFromQRcodeScan(this.isFromQrcodeScan);
        this.mAdapter.setLineCount(this.mIsLandscape ? 6 : 3);
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(true, true));
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mAdapter.setData(this.mData);
        this.mAlbums = view.findViewById(R.id.albums);
        this.mCount = (TextView)view.findViewById(R.id.count);
        this.mComplete = (TextView)view.findViewById(R.id.complete);
        if (this.isFromCover || this.isFromQrcodeScan) {
            this.mAlbumConfirm.setVisibility(8);
        }
        this.mCount.setText((CharSequence)((selectedPaths == null ? 0 : selectedPaths.size()) + "/" + this.mAmount));
        this.mAlbums.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPickFragment.this.continueSelection();
            }
        });
        Bundle bundle = this.getArguments();
        int backgroundResId = bundle.getInt("params_complete_button_background_res_id", -1);
        int textColorResId = bundle.getInt("params_complete_button_text_res_id", -1);
        String text = bundle.getString("params_complete_button_text");
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.mComplete.setText((CharSequence)text);
        }
        if (textColorResId != -1) {
            this.mComplete.setTextColor(this.getResources().getColorStateList(textColorResId));
        }
        if (backgroundResId != -1) {
            this.mComplete.setBackgroundResource(backgroundResId);
        }
        this.mComplete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPickFragment.this.finishSelection();
            }
        });
        if (!FP.empty((CharSequence)this.bucketId)) {
            this.mPhotoLoaderHelper.startLoad(this.bucketId);
        } else if (this.isFromCover || this.isFromQrcodeScan) {
            this.mPhotoLoaderHelper.startLoad();
        }
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        List<PhotoInfo> data = this.mPhotoLoaderHelper.getPhotos();
        if (this.mAdapter != null && this.mAdapter.getCount() == 0 && data != null && data.size() > 0) {
            if (this.isFromCover) {
                data.add(0, new PhotoInfo());
            }
            this.mAdapter.setData(data);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putAll(this.getArguments());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        MLog.info((String)TAG, (String)("onActivityResult requestCode = " + requestCode + "resultCode = " + resultCode));
        if (requestCode == 1001 && resultCode == -1) {
            if (this.needTouchSort) {
                this.mAdapter.mSelectedPaths.clear();
                if (!FP.empty((Collection)data.getStringArrayListExtra("params_preview_choice_photos"))) {
                    this.mAdapter.mSelectedPaths.addAll(data.getStringArrayListExtra("params_preview_choice_photos"));
                }
            }
            this.mAdapter.flushData(data.getParcelableArrayListExtra("result_preview_photos"));
            if (data.getBooleanExtra("result_preview_finish_pick", false)) {
                this.mComplete.performClick();
            }
        } else if (resultCode == -1 && requestCode == 0) {
            File file = YYFileUtils.getTempFile((Context)this.getActivity(), (String)((PhotoPickActivity)this.getActivity()).getCamCaptureName());
            MLog.info((String)TAG, (String)("onActivityResult, file = " + file));
            if (YYImageUtils.isImage(file)) {
                String path = null;
                if (BuildCompat.isIsolatedStorage()) {
                    String savePath = SandBoxCommonUtils.insertImageFile((Context)this.getActivity(), (String)file.getAbsolutePath(), (String)"YY_image", (boolean)true);
                    MLog.info((String)TAG, (String)("url from camera:" + savePath));
                    try {
                        path = GetImagePathUtil.getFilePathFromURI((Context)this.getActivity(), Uri.parse((String)savePath));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    path = file.getPath();
                }
                MLog.info((String)TAG, (String)("camera path to edit :" + path));
                ((PhotoPickActivity)this.getActivity()).onGetEditPhotos(path, true);
            } else {
                MLog.error((String)TAG, (String)"onActivityResult fail! file is not image.");
                ((PhotoPickActivity)this.getActivity()).displayPhotoEditUI(false);
                ((PhotoPickActivity)this.getActivity()).toast("\u62cd\u6444\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u62cd\u7167!");
            }
        } else if (resultCode == -1 && requestCode == 1 && data != null) {
            String bucketId = data.getStringExtra("params_bucket_id");
            if (!FP.empty((CharSequence)bucketId)) {
                this.mAdapter.clearData();
                if ("REQUEST_ALL_PHOTOS".equals(bucketId)) {
                    this.mPhotoLoaderHelper.startLoad();
                } else {
                    this.mPhotoLoaderHelper.startLoad(bucketId);
                }
                this.mFolderName = data.getStringExtra("params_folder_name");
                if (this.isFromCover && this.mFolderName != null && this.mFolderName.length() > 0) {
                    SimpleTitleBar bar = (SimpleTitleBar)this.getActivity().findViewById(R.id.title_photo_pick);
                    bar.setTitlte(this.mFolderName);
                }
            }
        } else {
            MLog.error((String)TAG, (String)"onActivityResult unknown fail!");
            this.getActivity().setResult(-1, null);
            this.getActivity().finish();
        }
    }

    public void finishSelection() {
        ArrayList<String> paths = this.getSelectedPaths();
        ArrayList<PhotoInfo> selected = this.mAdapter.getSelectedData();
        if (this.needTouchSort) {
            paths = this.mAdapter.getChoicePicList();
        }
        Bundle bundle = this.getActivity().getIntent().getExtras();
        bundle.putStringArrayList("params_selected_paths", paths);
        bundle.putStringArrayList("result_params_selected_paths", paths);
        bundle.putParcelableArrayList("result_params_photos", selected);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    public void continueSelection() {
        Bundle bundle = this.getActivity().getIntent().getExtras();
        ArrayList<String> paths = this.needTouchSort ? this.mAdapter.getChoicePicList() : this.getSelectedPaths();
        bundle.putStringArrayList("params_selected_paths", paths);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        this.getActivity().setResult(2, intent);
        this.getActivity().finish();
    }

    public void selectFromAlbum() {
        Intent intent = new Intent((Context)this.getActivity(), AlbumPickActivity.class);
        Bundle bundle = new Bundle();
        bundle.putBoolean("params_preview_cover", true);
        bundle.putBoolean("params_request_landscape", this.mIsLandscape);
        intent.putExtras(bundle);
        this.getActivity().startActivityForResult(intent, 1);
    }

    public ArrayList<String> getSelectedPaths() {
        ArrayList<String> selectedPaths = new ArrayList<String>();
        selectedPaths.addAll(this.mAdapter.getOtherSelectedPahts());
        ArrayList<PhotoInfo> infos = this.mAdapter.getSelectedData();
        for (PhotoInfo info : infos) {
            selectedPaths.add(info.image);
        }
        return selectedPaths;
    }

    @Override
    public void onPhotoInfo(List<PhotoInfo> data) {
        if (this.mAdapter != null && data != null && this.mAdapter.getCount() == 0) {
            if (this.isFromCover) {
                data.add(0, new PhotoInfo());
            }
            this.mAdapter.flushData(data);
        }
    }

    public static class PhotoAdapter
    extends BaseAdapter {
        private LayoutInflater mInflater;
        private Fragment mContext;
        private ArrayList<PhotoInfo> mData = new ArrayList();
        private DataChangedListener mDataChanged;
        private int mAmount = 0;
        private int mMaxSize = Integer.MAX_VALUE;
        private int mItemCheckBoxStyle;
        private String mBucketId;
        private ArrayList<String> mSelectedPaths = new ArrayList();
        private ArrayList<String> mOtherSelectedPahts = new ArrayList();
        private ArrayList<String> choicePicList;
        private boolean mNeedTouchSort = false;
        private boolean mIsFromCover = false;
        private boolean mIsFromQRCodeScan = false;
        private int mLineCount = 3;
        private View.OnClickListener mItemClick = new View.OnClickListener(){

            public void onClick(View v) {
                block10: {
                    PhotoInfo info = (PhotoInfo)v.getTag();
                    if (mIsFromCover) {
                        try {
                            if (info == null) break block10;
                            info.selected = true;
                            if (mDataChanged == null) break block10;
                            mDataChanged.dataChanged();
                            if (StringUtils.isEmpty((String)info.image).booleanValue()) {
                                info.selected = false;
                                mDataChanged.capturePicSelectted();
                                break block10;
                            }
                            mDataChanged.itemSelectted(info.image);
                        }
                        catch (Exception e) {
                            MLog.error((String)PhotoPickFragment.TAG, (String)("xuwakao, exception occurs, e = " + e));
                        }
                    } else if (mIsFromQRCodeScan) {
                        Intent intent = new Intent();
                        intent.putExtra(StringUtils.isEmpty((String)keyOfQrCodePath) != false ? "params_qrcode_pic_path" : keyOfQrCodePath, info.image == null ? "" : info.image);
                        mContext.getActivity().setResult(-1, intent);
                        mContext.getActivity().finish();
                    } else {
                        Intent intent = new Intent(v.getContext(), PhotoPickPreviewActivity.class);
                        intent.putExtra("params_bucket_id", mBucketId);
                        intent.putParcelableArrayListExtra("params_preview_photos", mData);
                        intent.putStringArrayListExtra("params_selected_paths", mSelectedPaths);
                        if (mNeedTouchSort) {
                            intent.putStringArrayListExtra("params_selected_paths", choicePicList);
                            intent.putExtra("params_touch_sort", mNeedTouchSort);
                        }
                        intent.putExtra("params_picture_amount", mAmount);
                        intent.putExtra("params_picture_max_size", mMaxSize);
                        intent.putExtra("params_preview_position", mData.indexOf(info));
                        try {
                            mContext.getActivity().startActivityForResult(intent, 1001);
                        }
                        catch (Exception e) {
                            SingleToastUtil.showToast((String)"\u56fe\u7247\u6570\u91cf\u592a\u591a\uff0c\u65e0\u6cd5\u8df3\u8f6c\uff01");
                        }
                    }
                }
            }
        };
        private CompoundButton.OnCheckedChangeListener mChecked = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                try {
                    PhotoInfo info = (PhotoInfo)buttonView.getTag();
                    if (info != null) {
                        info.selected = isChecked;
                        if (mDataChanged != null) {
                            mDataChanged.dataChanged();
                        }
                        FragmentActivity activity2 = mContext.getActivity();
                        if (isChecked && !FP.empty((CharSequence)info.image) && new File(info.image).length() > (long)mMaxSize) {
                            buttonView.setChecked(false);
                            mSelectedPaths.remove(info.image);
                            info.selected = false;
                            if (mDataChanged != null) {
                                mDataChanged.dataChanged();
                            }
                            ((BaseActivity)activity2).getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(mContext.getString(R.string.str_photos_dialog_limit_title), String.format(mContext.getString(R.string.str_photos_selected_size_limit), FP.formatSize((int)mMaxSize)), true, null));
                            return;
                        }
                        if (isChecked && this.getSelectedData().size() + this.getOtherSelectedPahts().size() > mAmount) {
                            buttonView.setChecked(false);
                            mSelectedPaths.remove(info.image);
                            info.selected = false;
                            if (mDataChanged != null) {
                                mDataChanged.dataChanged();
                            }
                            ((BaseActivity)activity2).getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(mContext.getString(R.string.str_photos_dialog_limit_title), String.format(mContext.getString(R.string.str_photos_selected_limit), mAmount), true, null));
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    MLog.error((String)PhotoPickFragment.TAG, (String)("xuwakao, exception occurs, e = " + e));
                }
            }
        };
        private CompoundButton.OnCheckedChangeListener mRecordChecked = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                try {
                    PhotoInfo info = (PhotoInfo)buttonView.getTag();
                    if (info != null) {
                        FragmentActivity activity2 = mContext.getActivity();
                        if (isChecked && choicePicList.size() <= mAmount) {
                            for (String path : choicePicList) {
                                if (!path.equals(info.image)) continue;
                                return;
                            }
                            if (!FP.empty((CharSequence)info.image) && new File(info.image).length() > (long)mMaxSize) {
                                buttonView.setChecked(false);
                                info.selected = !isChecked;
                                mSelectedPaths.remove(info.image);
                                if (mDataChanged != null) {
                                    mDataChanged.dataChanged();
                                }
                                ((BaseActivity)activity2).getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(mContext.getString(R.string.str_photos_dialog_limit_title), String.format(mContext.getString(R.string.str_photos_selected_size_limit), FP.formatSize((int)mMaxSize)), true, null));
                                return;
                            }
                            if (choicePicList.size() + 1 > mAmount) {
                                buttonView.setChecked(false);
                                info.selected = !isChecked;
                                mSelectedPaths.remove(info.image);
                                ((BaseActivity)activity2).getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(mContext.getString(R.string.str_photos_dialog_limit_title), String.format(mContext.getString(R.string.str_photos_selected_limit), mAmount), true, null));
                            } else {
                                info.selected = isChecked;
                                choicePicList.add(info.image);
                            }
                        } else if (!isChecked) {
                            for (String path : choicePicList) {
                                if (!path.equals(info.image)) continue;
                                choicePicList.remove(path);
                            }
                        }
                    }
                    if (mDataChanged != null) {
                        mDataChanged.dataChanged();
                    }
                }
                catch (Exception e) {
                    MLog.error((String)PhotoPickFragment.TAG, (String)("xuwakao, exception occurs, e = " + e));
                }
            }
        };

        public PhotoAdapter(Fragment context, int amount, int itemCheckBoxStyle, String bucketId, ArrayList<String> selectedPaths, boolean needTouchSort, int maxSize) {
            this.mContext = context;
            this.mInflater = LayoutInflater.from((Context)context.getActivity());
            this.mAmount = amount;
            this.mMaxSize = maxSize;
            this.mItemCheckBoxStyle = itemCheckBoxStyle;
            this.mBucketId = bucketId;
            if (selectedPaths != null && !selectedPaths.isEmpty()) {
                this.mSelectedPaths.addAll(selectedPaths);
            }
            this.mNeedTouchSort = needTouchSort;
            if (this.mNeedTouchSort) {
                this.choicePicList = new ArrayList();
            }
        }

        public void setData(List<PhotoInfo> data) {
            if (data != null && data.size() > 0) {
                this.applySelected(this.mSelectedPaths, data);
                this.mData.addAll(data);
                this.notifyDataSetChanged();
            }
        }

        public void clearData() {
            if (this.mData != null && this.mData.size() > 0) {
                this.mData.clear();
                this.notifyDataSetChanged();
            }
        }

        public void setIsFromCover(boolean isCover) {
            this.mIsFromCover = isCover;
        }

        public void setIsFromQRcodeScan(boolean isQrScan) {
            this.mIsFromQRCodeScan = isQrScan;
        }

        public void setLineCount(int lineCount) {
            this.mLineCount = lineCount;
        }

        public void flushData(List<PhotoInfo> data) {
            if (data != null && data.size() > 0) {
                this.mData.clear();
                this.applySelected(this.mSelectedPaths, data);
                this.mData.addAll(data);
                this.notifyDataSetChanged();
            }
        }

        private void applySelected(List<String> selected, List<PhotoInfo> data) {
            if (this.mNeedTouchSort) {
                this.choicePicList.clear();
                this.choicePicList.addAll(selected);
                for (PhotoInfo info : data) {
                    for (String path : selected) {
                        if (!path.equals(info.image)) continue;
                        info.selected = true;
                    }
                }
                return;
            }
            this.mOtherSelectedPahts.clear();
            this.mOtherSelectedPahts.addAll(selected);
            for (PhotoInfo info : data) {
                for (String path : selected) {
                    if (!path.equals(info.image)) continue;
                    info.selected = true;
                    this.mOtherSelectedPahts.remove(path);
                }
            }
        }

        public int getCount() {
            if (this.mData.size() % this.mLineCount == 0) {
                return this.mData.size() / this.mLineCount;
            }
            return this.mData.size() / this.mLineCount + 1;
        }

        public PhotoInfo getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public ArrayList<PhotoInfo> getSelectedData() {
            ArrayList<PhotoInfo> selected = new ArrayList<PhotoInfo>();
            for (PhotoInfo info : this.mData) {
                if (!info.selected) continue;
                selected.add(info);
            }
            return selected;
        }

        public ArrayList<String> getOtherSelectedPahts() {
            return this.mOtherSelectedPahts;
        }

        public ArrayList<String> getChoicePicList() {
            return this.choicePicList;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            String url;
            PhotoInfo info;
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.item_photo_pick, parent, false);
                holder = new ViewHolder();
                holder.container1 = convertView.findViewById(R.id.container1);
                holder.container1.setOnClickListener(this.mItemClick);
                holder.select1 = (CheckBox)holder.container1.findViewById(R.id.selected1);
                holder.select1.setOnCheckedChangeListener(this.mChecked);
                holder.thumb1 = (RecycleImageView)convertView.findViewById(R.id.thumb1);
                holder.container2 = convertView.findViewById(R.id.container2);
                holder.container2.setOnClickListener(this.mItemClick);
                holder.select2 = (CheckBox)holder.container2.findViewById(R.id.selected2);
                holder.select2.setOnCheckedChangeListener(this.mChecked);
                holder.thumb2 = (RecycleImageView)convertView.findViewById(R.id.thumb2);
                holder.container3 = convertView.findViewById(R.id.container3);
                holder.container3.setOnClickListener(this.mItemClick);
                holder.select3 = (CheckBox)holder.container3.findViewById(R.id.selected3);
                holder.select3.setOnCheckedChangeListener(this.mChecked);
                holder.thumb3 = (RecycleImageView)convertView.findViewById(R.id.thumb3);
                holder.container4 = convertView.findViewById(R.id.container4);
                holder.container4.setOnClickListener(this.mItemClick);
                holder.select4 = (CheckBox)holder.container4.findViewById(R.id.selected4);
                holder.select4.setOnCheckedChangeListener(this.mChecked);
                holder.thumb4 = (RecycleImageView)convertView.findViewById(R.id.thumb4);
                holder.container5 = convertView.findViewById(R.id.container5);
                holder.container5.setOnClickListener(this.mItemClick);
                holder.select5 = (CheckBox)holder.container5.findViewById(R.id.selected5);
                holder.select5.setOnCheckedChangeListener(this.mChecked);
                holder.thumb5 = (RecycleImageView)convertView.findViewById(R.id.thumb5);
                holder.container6 = convertView.findViewById(R.id.container6);
                holder.container6.setOnClickListener(this.mItemClick);
                holder.select6 = (CheckBox)holder.container6.findViewById(R.id.selected6);
                holder.select6.setOnCheckedChangeListener(this.mChecked);
                holder.thumb6 = (RecycleImageView)convertView.findViewById(R.id.thumb6);
                if (this.mIsFromCover || this.mIsFromQRCodeScan) {
                    holder.select1.setVisibility(8);
                    holder.select2.setVisibility(8);
                    holder.select3.setVisibility(8);
                    holder.select4.setVisibility(8);
                    holder.select5.setVisibility(8);
                    holder.select6.setVisibility(8);
                    holder.select1.setOnCheckedChangeListener(null);
                    holder.select2.setOnCheckedChangeListener(null);
                    holder.select3.setOnCheckedChangeListener(null);
                    holder.select4.setOnCheckedChangeListener(null);
                    holder.select5.setOnCheckedChangeListener(null);
                    holder.select6.setOnCheckedChangeListener(null);
                }
                int height = (int)(((float)ResolutionUtils.getScreenWidth((Context)this.mContext.getActivity()) - ResolutionUtils.convertDpToPixel((float)10.0f, (Context)this.mContext.getActivity())) / (float)this.mLineCount);
                holder.thumb1.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.thumb2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.thumb3.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.thumb4.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.thumb5.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.thumb6.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                if (this.mNeedTouchSort) {
                    holder.select1.setOnCheckedChangeListener(this.mRecordChecked);
                    holder.select2.setOnCheckedChangeListener(this.mRecordChecked);
                    holder.select3.setOnCheckedChangeListener(this.mRecordChecked);
                    holder.select4.setOnCheckedChangeListener(this.mRecordChecked);
                    holder.select5.setOnCheckedChangeListener(this.mRecordChecked);
                    holder.select6.setOnCheckedChangeListener(this.mRecordChecked);
                }
                if (this.mItemCheckBoxStyle != 0) {
                    holder.select1.setButtonDrawable(this.mItemCheckBoxStyle);
                    holder.select2.setButtonDrawable(this.mItemCheckBoxStyle);
                    holder.select3.setButtonDrawable(this.mItemCheckBoxStyle);
                    holder.select4.setButtonDrawable(this.mItemCheckBoxStyle);
                    holder.select5.setButtonDrawable(this.mItemCheckBoxStyle);
                    holder.select6.setButtonDrawable(this.mItemCheckBoxStyle);
                }
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            int index = position * this.mLineCount;
            if (this.mIsFromCover && index == 0) {
                holder.container1.setVisibility(0);
                RelativeLayout.LayoutParams imgParams = new RelativeLayout.LayoutParams(-2, -2);
                ImageView img = new ImageView((Context)this.mContext.getActivity());
                img.setImageResource(R.drawable.bg_mobilelive_cover_image);
                imgParams.addRule(13);
                img.setLayoutParams((ViewGroup.LayoutParams)imgParams);
                img.setId(0);
                ((RelativeLayout)holder.container1).addView((View)img);
                holder.container1.setBackgroundResource(R.drawable.bg_mobilelive_cover_take_pic);
                holder.thumb1.setVisibility(4);
                info = this.mData.get(index);
                holder.container1.setTag((Object)info);
            } else if (index < this.mData.size()) {
                int count = ((RelativeLayout)holder.container1).getChildCount();
                for (int i = 0; i < count; ++i) {
                    if (((RelativeLayout)holder.container1).getChildAt(i) == null || ((RelativeLayout)holder.container1).getChildAt(i).getId() != 0) continue;
                    ((RelativeLayout)holder.container1).removeViewAt(i);
                }
                if (holder.thumb1.getVisibility() == 4) {
                    holder.thumb1.setVisibility(0);
                }
                holder.container1.setVisibility(0);
                info = this.mData.get(index);
                holder.container1.setTag((Object)info);
                holder.select1.setTag((Object)info);
                holder.select1.setChecked(info.selected);
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                ImageLoader.loadImage((RecycleImageView)holder.thumb1, (String)url, (int)R.drawable.default_live_drawable);
            } else {
                holder.container1.setVisibility(4);
            }
            if (index + 1 < this.mData.size()) {
                holder.container2.setVisibility(0);
                info = this.mData.get(index + 1);
                holder.container2.setTag((Object)info);
                holder.select2.setTag((Object)info);
                holder.select2.setChecked(info.selected);
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                ImageLoader.loadImage((RecycleImageView)holder.thumb2, (String)url, (int)R.drawable.default_live_drawable);
            } else {
                holder.container2.setVisibility(4);
            }
            if (index + 2 < this.mData.size()) {
                holder.container3.setVisibility(0);
                info = this.mData.get(index + 2);
                holder.container3.setTag((Object)info);
                holder.select3.setTag((Object)info);
                holder.select3.setChecked(info.selected);
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                ImageLoader.loadImage((RecycleImageView)holder.thumb3, (String)url, (int)R.drawable.default_live_drawable);
            } else {
                holder.container3.setVisibility(4);
            }
            if (index + 3 < this.mData.size()) {
                holder.container4.setVisibility(0);
                info = this.mData.get(index + 3);
                holder.container4.setTag((Object)info);
                holder.select4.setTag((Object)info);
                holder.select4.setChecked(info.selected);
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                ImageLoader.loadImage((RecycleImageView)holder.thumb4, (String)url, (int)R.drawable.default_live_drawable);
            } else {
                holder.container4.setVisibility(4);
            }
            if (index + 4 < this.mData.size()) {
                holder.container5.setVisibility(0);
                info = this.mData.get(index + 4);
                holder.container5.setTag((Object)info);
                holder.select5.setTag((Object)info);
                holder.select5.setChecked(info.selected);
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                ImageLoader.loadImage((RecycleImageView)holder.thumb5, (String)url, (int)R.drawable.default_live_drawable);
            } else {
                holder.container5.setVisibility(4);
            }
            if (index + 5 < this.mData.size()) {
                holder.container6.setVisibility(0);
                info = this.mData.get(index + 5);
                holder.container6.setTag((Object)info);
                holder.select6.setTag((Object)info);
                holder.select6.setChecked(info.selected);
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                ImageLoader.loadImage((RecycleImageView)holder.thumb6, (String)url, (int)R.drawable.default_live_drawable);
            } else {
                holder.container6.setVisibility(4);
            }
            if (this.mLineCount < 6) {
                holder.container4.setVisibility(8);
                holder.container5.setVisibility(8);
                holder.container6.setVisibility(8);
            }
            return convertView;
        }

        public void setDataChanged(DataChangedListener dataChanged) {
            this.mDataChanged = dataChanged;
        }

        public DataChangedListener getDataChanged() {
            return this.mDataChanged;
        }

        private static class ViewHolder {
            private View container1;
            private RecycleImageView thumb1;
            private CheckBox select1;
            private View container2;
            private RecycleImageView thumb2;
            private CheckBox select2;
            private View container3;
            private RecycleImageView thumb3;
            private CheckBox select3;
            private View container4;
            private RecycleImageView thumb4;
            private CheckBox select4;
            private View container5;
            private RecycleImageView thumb5;
            private CheckBox select5;
            private View container6;
            private RecycleImageView thumb6;
            private CheckBox select6;

            private ViewHolder() {
            }
        }
    }

    public static interface DataChangedListener {
        public void dataChanged();

        public void itemSelectted(String var1);

        public void capturePicSelectted();
    }
}

