/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.RxBus;
import com.yy.mobile.event.GotoPhotoEditAndStopPreviewEvent;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_mobileLiveStopped_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.mobilelive.PhotoEditController;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.photopicker.PhotoPickActivity$$EventBinder;
import com.yy.mobile.ui.widget.photopicker.PhotoPickFragment;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;

@Route(path="/gallery/PhotoPickActivity", name="\u56fe\u7247\u7f16\u8f91")
@RouteDoc(desc="\u56fe\u7247\u7f16\u8f91\u9875\u9762", minVer="7.16.0", eg="yymobile://gallery/PhotoPickActivity")
public class PhotoPickActivity
extends BaseActivity {
    public static final String TAKE_PHOTO_FILE_PATH = "mobilelive_take_photo_file_path";
    private static final String TAG = "PhotoPickActivity";
    PhotoPickFragment mFragment;
    private String mCameraCapturingName;
    private String mEditConverPath;
    private PhotoEditController mEditController;
    private ViewStub mEditControllerSubView;
    private View mEditControllerView;
    private boolean isFromCover;
    private boolean mRequestLandscape;
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RxBus.getDefault().post((Object)new GotoPhotoEditAndStopPreviewEvent());
        Bundle data = null;
        data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        if (data != null) {
            this.mCameraCapturingName = data.getString(TAKE_PHOTO_FILE_PATH);
            this.mRequestLandscape = data.getBoolean("params_request_landscape", false);
            MLog.info((Object)TAG, (String)"onCreate: mRequestLandscape:%b", (Object[])new Object[]{this.mRequestLandscape});
            if (this.mRequestLandscape) {
                this.setRequestedOrientation(0);
            } else {
                this.setRequestedOrientation(1);
            }
            this.isFromCover = data.getBoolean("params_preview_cover", false);
            this.mEditConverPath = data.getString("params_request_edit_conver_path", "");
        }
        this.setContentView(R.layout.layout_photo_pick_albums);
        SimpleTitleBar bar = (SimpleTitleBar)this.findViewById(R.id.title_photo_pick);
        bar.setTitlte("\u76f8\u7247\u80f6\u5377");
        int themeColor = this.getIntent().getIntExtra("params_theme_color_res_id", 0);
        bar.setBg(themeColor);
        bar.setLeftView(LayoutInflater.from((Context)this).inflate(R.layout.layout_simple_title_left_gallery, null));
        bar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPickActivity.this.mFragment.selectFromAlbum();
            }
        });
        boolean hideRight = this.getIntent().getBooleanExtra("params_hide_title_right", false);
        if (!hideRight) {
            View rootTitleView = this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
            rootTitleView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PhotoPickActivity.this.setResult(-1);
                    PhotoPickActivity.this.finish();
                }
            });
            TextView rightView = (TextView)rootTitleView.findViewById(R.id.tv_right_button);
            rightView.setText((CharSequence)this.getString(R.string.str_my_message_cancel));
            bar.setRightView(rootTitleView);
        }
        this.mFragment = PhotoPickFragment.newInstance(this.getIntent().getExtras());
        this.getSupportFragmentManager().beginTransaction().replace(R.id.web_content, (Fragment)this.mFragment, null).commitAllowingStateLoss();
        if (this.isFromCover) {
            this.initPhotoEditUI();
        }
        if (!StringUtils.isEmpty((String)this.mEditConverPath).booleanValue() && YYFileUtils.isFileExisted((String)this.mEditConverPath)) {
            MLog.info((String)TAG, (String)("init edit conver photo :" + this.mEditConverPath));
            this.onGetEditPhotos(this.mEditConverPath, false);
            this.mEditController.setEditInit(true);
        }
    }

    public void saveCamCaptureName(String name) {
        this.mCameraCapturingName = name;
    }

    public String getCamCaptureName() {
        return this.mCameraCapturingName;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(TAKE_PHOTO_FILE_PATH, this.mCameraCapturingName);
        outState.putBoolean("params_request_landscape", this.mRequestLandscape);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        MLog.info((String)TAG, (String)("onActivityResult : requestCode=" + requestCode + " resultCode=" + resultCode));
        if (resultCode == -1) {
            this.mFragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onBackPressed() {
        if (this.isFromCover && this.mEditControllerView != null && this.mEditControllerView.isShown() && this.mEditController != null && this.mEditController.onBackPressed()) {
            MLog.info((String)TAG, (String)"EditControllerView use backKey");
            return;
        }
        this.mFragment.continueSelection();
    }

    private void initPhotoEditUI() {
        try {
            this.initController();
            this.mEditControllerSubView = (ViewStub)this.findViewById(R.id.other_content);
            if (this.mRequestLandscape) {
                this.mEditControllerSubView.setLayoutResource(R.layout.cover_photo_edit_land);
            } else {
                this.mEditControllerSubView.setLayoutResource(R.layout.cover_photo_edit);
            }
            this.mEditControllerView = this.mEditControllerSubView.inflate();
            this.mEditControllerView.setVisibility(8);
            this.mEditController.initPhotoEditContentView(this.mEditControllerView, false);
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    public void onGetEditPhotos(String path, boolean isFromCamera) {
        MLog.info((String)TAG, (String)("onGetEditPhotos/path=" + path + " isFromCamera=" + isFromCamera));
        try {
            this.initController();
            if (this.mEditControllerView == null) {
                this.initPhotoEditUI();
            }
            this.mEditController.setEditPhotoFrom(isFromCamera);
            this.mEditController.onGetPhoto(path, isFromCamera);
            this.mEditControllerView.setVisibility(0);
            if (ImmersionBar.needHandleStatusBar()) {
                this.immersionBar = ImmersionBar.with((Activity)this).statusBarDarkFont(false).navigationBarEnable(true).navigationBarColor(17170444).statusBarColor(17170444).init();
            }
        }
        catch (Throwable ex) {
            MLog.error((String)TAG, (String)("onGetEditPhotos/" + ex));
        }
    }

    private void initController() {
        if (this.mEditController == null) {
            this.mEditController = new PhotoEditController((Activity)this, new PhotoEditController.CancelCallback(){

                @Override
                public void onCancel(View view) {
                    MLog.info((String)PhotoPickActivity.TAG, (String)"PhotoEditController onCancel");
                    if (ImmersionBar.needHandleStatusBar()) {
                        PhotoPickActivity.this.initStatusBar();
                    }
                }
            });
        }
    }

    public void takePhotoFromCamera() {
        this.initController();
        this.mEditController.takePhotoFromCamera();
    }

    public void displayPhotoEditUI(boolean show2) {
        if (this.mEditControllerView != null) {
            if (show2) {
                this.mEditControllerView.setVisibility(0);
            } else {
                this.mEditControllerView.setVisibility(8);
            }
        }
    }

    @BusEvent
    public void mobileLiveStopped(IMobileLiveClient_mobileLiveStopped_EventArgs busEventArgs) {
        this.finish();
    }

    protected boolean handleStatusBar() {
        this.initStatusBar();
        return true;
    }

    private void initStatusBar() {
        this.immersionBar = ImmersionBar.with((Activity)this).statusBarColor(17170443).statusBarDarkFont(true).navigationBarColor(17170443).navigationBarEnable(true).init();
    }

    protected void configView() {
        SimpleTitleBar bar = (SimpleTitleBar)this.findViewById(R.id.title_photo_pick);
        bar.setConsiderStatusBar(true);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PhotoPickActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

