/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.photopicker.AlbumInfo;
import com.yy.mobile.ui.widget.photopicker.AlbumPickFragment;
import com.yy.mobile.ui.widget.photopicker.MomentPhotoPickActivity;
import com.yy.mobile.ui.widget.photopicker.loader.album.AlbumCallback;
import com.yy.mobile.ui.widget.photopicker.loader.album.AlbumLoaderHelper;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.log.MLog;
import java.util.List;

public class MomentAlbumPickActivity
extends BaseActivity
implements AlbumCallback {
    private static final String TAG = "MomentAlbumPickActivity";
    private ListView mListView;
    private AlbumPickFragment.AlbumAdapter mAdapter;
    private Bundle data;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_moment_album_pick);
        this.data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        this.initView();
        this.initData();
    }

    private void initView() {
        SimpleTitleBar bar = (SimpleTitleBar)this.findViewById(R.id.title_photo_pick);
        bar.setTitlte("\u76f8\u518c");
        View rootTitleView = this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        rootTitleView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent data = new Intent();
                data.putExtra("moment_album_cancal_flag", "moment_album_cancal_flag");
                MomentAlbumPickActivity.this.setResult(-1, data);
                MomentAlbumPickActivity.this.finish();
            }
        });
        TextView rightView = (TextView)rootTitleView.findViewById(R.id.tv_right_button);
        rightView.setText((CharSequence)this.getString(R.string.str_my_message_cancel));
        bar.setRightView(rootTitleView);
        this.mListView = (ListView)this.findViewById(R.id.listview);
    }

    private void initData() {
        this.mAdapter = new AlbumPickFragment.AlbumAdapter((Context)this);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (MomentAlbumPickActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                AlbumInfo info = MomentAlbumPickActivity.this.mAdapter.getItem(position);
                Intent intent = new Intent((Context)MomentAlbumPickActivity.this, MomentPhotoPickActivity.class);
                MomentAlbumPickActivity.this.data.putString("params_bucket_id", info.bucketId);
                intent.putExtras(MomentAlbumPickActivity.this.data);
                MomentAlbumPickActivity.this.startActivityForResult(intent, 4384);
            }
        });
        new AlbumLoaderHelper((FragmentActivity)this, (AlbumCallback)this).startLoad();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 4384 && resultCode == -1 && "moment_photo".equals(data.getStringExtra("moment_photo"))) {
            Intent data1 = new Intent();
            data1.putExtra("moment_album_cancal_flag", "moment_album_cancal_flag");
            this.setResult(-1, data1);
            this.finish();
        } else if (requestCode == 4384 && resultCode == -1) {
            Bundle bundle = data.getExtras();
            if (bundle == null) {
                MLog.error((String)TAG, (String)"bundle can not null");
                return;
            }
            bundle.putString("back_album", "back_album");
            Intent intent = new Intent();
            intent.putExtras(bundle);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    @Override
    public void onAlbumInfo(List<AlbumInfo> data) {
        if (this.mAdapter != null && data != null && this.mAdapter.getCount() == 0) {
            this.mAdapter.setData(data);
        }
    }
}

