/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.yy.mobile.plugin.main.R;

public class CheckView
extends View {
    public static final int UNCHECKED = Integer.MIN_VALUE;
    private static final int SIZE = 35;
    private static final float BG_RADIUS = 12.0f;
    private static final float STROKE_RADIUS = 13.0f;
    private static final int STOKE_WIDTH = 1;
    private static final float CHECK_RECT_PADDING = 6.0f;
    private static final String NOCHECK_BG_COLOR = "#11000000";
    private float mDensity;
    private boolean mChecked;
    private int mCheckNum;
    private Paint mBackgroundPaint;
    private Paint mStrokePaint;
    private TextPaint mTextPaint;
    private Drawable mNoCheckDrawable;
    private Rect mCheckRect;

    public CheckView(Context context) {
        super(context);
        this.init(context);
    }

    public CheckView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CheckView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.invalidate();
    }

    public void setCheckNum(int checkNum) {
        this.mCheckNum = checkNum;
        this.invalidate();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(35.0f * this.mDensity)), (int)0x40000000);
        super.onMeasure(sizeSpec, sizeSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mChecked) {
            if (this.mCheckNum != Integer.MIN_VALUE) {
                this.mBackgroundPaint.setColor(Color.parseColor((String)"#ffdd00"));
                canvas.drawCircle(35.0f * this.mDensity / 2.0f, 35.0f * this.mDensity / 2.0f, 13.0f * this.mDensity, this.mBackgroundPaint);
                this.initTextPaint();
                String text = String.valueOf(this.mCheckNum);
                int baseX = (int)((float)canvas.getWidth() - this.mTextPaint.measureText(text)) / 2;
                int baseY = (int)((float)canvas.getHeight() - this.mTextPaint.descent() - this.mTextPaint.ascent()) / 2;
                canvas.drawText(text, (float)baseX, (float)baseY, (Paint)this.mTextPaint);
            }
        } else {
            this.mBackgroundPaint.setColor(Color.parseColor((String)NOCHECK_BG_COLOR));
            canvas.drawCircle(35.0f * this.mDensity / 2.0f, 35.0f * this.mDensity / 2.0f, 12.0f * this.mDensity, this.mBackgroundPaint);
            this.mStrokePaint.setColor(-1);
            canvas.drawCircle(35.0f * this.mDensity / 2.0f, 35.0f * this.mDensity / 2.0f, 13.0f * this.mDensity, this.mStrokePaint);
            this.mNoCheckDrawable.setBounds(this.getCheckRect());
            this.mNoCheckDrawable.draw(canvas);
        }
    }

    private void init(Context context) {
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(1.0f * this.mDensity);
        this.mNoCheckDrawable = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.unselected_untick_selector, (Resources.Theme)context.getTheme());
    }

    private void initTextPaint() {
        if (this.mTextPaint == null) {
            this.mTextPaint = new TextPaint(1);
            this.mTextPaint.setColor(Color.parseColor((String)"#1d1d1d"));
            this.mTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
            this.mTextPaint.setTextSize(12.0f * this.mDensity);
        }
    }

    private Rect getCheckRect() {
        if (this.mCheckRect == null) {
            int rectPadding = (int)(6.0f * this.mDensity);
            this.mCheckRect = new Rect(rectPadding, rectPadding, (int)(35.0f * this.mDensity - (float)rectPadding), (int)(35.0f * this.mDensity - (float)rectPadding));
        }
        return this.mCheckRect;
    }
}

