/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.dialog.TitleAndMessageKnownDialog;
import com.yy.mobile.ui.widget.photopicker.CheckView;
import com.yy.mobile.ui.widget.photopicker.DataHolder;
import com.yy.mobile.ui.widget.photopicker.PhotoInfo;
import com.yy.mobile.ui.widget.photopicker.PhotoPickPreviewActivity;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoCallback;
import com.yy.mobile.ui.widget.photopicker.loader.photo.PhotoLoaderHelper;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class AllPhotoPickFragment
extends BaseLinkFragment
implements PhotoCallback {
    private static final String TAG = "AllPhotoPickFragment";
    private ArrayList<String> mClearDataSelected = new ArrayList();
    private List<PhotoInfo> mClearData = new ArrayList<PhotoInfo>();
    private ArrayList<String> mSelectedPaths;
    private ListView mListView;
    private TextView mTextPhotoNum;
    private Button mButtonPhotoPick;
    private PhotoAdapter mAdapter;
    private PhotoLoaderHelper mPhotoLoaderHelper;
    private int mAmount = 0;

    public static AllPhotoPickFragment newInstance(Bundle extras) {
        AllPhotoPickFragment fragment = new AllPhotoPickFragment();
        fragment.setArguments(extras);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPhotoLoaderHelper = new PhotoLoaderHelper((Fragment)this, (PhotoCallback)this);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.fragment_all_photo_pick, container, false);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getArguments();
        this.mAmount = data.getInt("params_picture_amount", 1);
        this.mSelectedPaths = data.getStringArrayList("params_selected_paths");
        this.mTextPhotoNum = (TextView)root.findViewById(R.id.text_photo_num);
        this.mButtonPhotoPick = (Button)root.findViewById(R.id.button_photo_pick);
        this.mButtonPhotoPick.setText((CharSequence)"\u786e\u5b9a(0)");
        this.mButtonPhotoPick.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AllPhotoPickFragment.this.finishSelection();
            }
        });
        this.mListView = (ListView)root.findViewById(R.id.listview);
        this.mAdapter = new PhotoAdapter((Fragment)this, this.mButtonPhotoPick, this.mAmount, this.mSelectedPaths);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        String bucketId = data.getString("params_bucket_id");
        if (bucketId != null) {
            this.mPhotoLoaderHelper.startLoad(bucketId);
        } else {
            this.mPhotoLoaderHelper.startLoad();
        }
        return root;
    }

    private void finishSelection() {
        ArrayList<String> paths;
        if (this.mSelectedPaths != null) {
            this.mSelectedPaths.addAll(this.mAdapter.mSelectedPath);
            paths = this.mSelectedPaths;
        } else {
            paths = this.mAdapter.mSelectedPath;
        }
        ArrayList<PhotoInfo> selected = this.mAdapter.getSelectedData();
        Bundle bundle = this.getActivity().getIntent().getExtras();
        if (bundle == null) {
            MLog.error((String)TAG, (String)"bundle can not null");
            return;
        }
        bundle.putStringArrayList("params_selected_paths", paths);
        bundle.putStringArrayList("result_params_selected_paths", paths);
        bundle.putParcelableArrayList("result_params_photos", selected);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    public void clearData() {
        if (this.mAdapter != null) {
            for (PhotoInfo info : this.mClearData) {
                if (!info.selected) continue;
                info.selected = false;
            }
            this.mAdapter.previewBackRefreshSelection(this.mClearDataSelected);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001 && resultCode == -1) {
            ArrayList<PhotoInfo> infos = DataHolder.getInstance().getImageListData();
            ArrayList selectedList = data.getStringArrayListExtra("params_preview_choice_photos");
            this.mAdapter.previewBackRefreshSelection(selectedList);
            if (data.getBooleanExtra("result_preview_finish_pick", false)) {
                this.mButtonPhotoPick.performClick();
            }
        } else if (resultCode == -1 && data.getExtras() != null && data.getExtras().getString("back_album") != null) {
            Bundle bundle = data.getExtras();
            if (bundle == null) {
                MLog.error((String)TAG, (String)"bundle can not null");
                return;
            }
            bundle.putString("back_album", "back_album");
            Intent intent = new Intent();
            intent.putExtras(bundle);
            this.getActivity().setResult(-1, intent);
            this.getActivity().finish();
        } else if (data != null && data.hasExtra("moment_album_cancal_flag") && resultCode == -1 && this.getActivity() != null) {
            this.getActivity().finish();
        }
    }

    @Override
    public void onPhotoInfo(List<PhotoInfo> data) {
        if (data != null) {
            this.mClearData.clear();
            this.mClearData.addAll(data);
            this.mTextPhotoNum.setText((CharSequence)(data.size() + "\u5f20\u56fe\u7247"));
            this.mAdapter.setData(data);
        }
    }

    public static class PhotoAdapter
    extends BaseAdapter {
        private Fragment mContext;
        private Button mButtonPhotoPick;
        private LayoutInflater mInflater;
        private ArrayList<PhotoInfo> mData = new ArrayList();
        private ArrayList<String> mSelectedPath = new ArrayList();
        private List<String> mPreSelectedPaths;
        private int mLineCount = 4;
        private int mAmount;
        private View.OnClickListener mItemClick = new View.OnClickListener(){

            public void onClick(View v) {
                PhotoInfo info = (PhotoInfo)v.getTag();
                Intent intent = new Intent(v.getContext(), PhotoPickPreviewActivity.class);
                intent.putExtra("params_picture_flag_of_jump", "comment");
                DataHolder.getInstance().setImageListData(mData);
                intent.putStringArrayListExtra("params_selected_paths", mSelectedPath);
                intent.putExtra("params_touch_sort", true);
                if (mPreSelectedPaths != null) {
                    intent.putExtra("params_picture_amount", mAmount - mPreSelectedPaths.size());
                } else {
                    intent.putExtra("params_picture_amount", mAmount);
                }
                intent.putExtra("params_preview_position", mData.indexOf(info));
                try {
                    mContext.getActivity().startActivityForResult(intent, 1001);
                }
                catch (Exception e) {
                    SingleToastUtil.showToast((String)"\u56fe\u7247\u6570\u91cf\u592a\u591a\uff0c\u65e0\u6cd5\u8df3\u8f6c\uff01");
                }
            }
        };
        private View.OnClickListener mCheckedListener = new View.OnClickListener(){

            @SuppressLint(value={"SetTextI18n"})
            public void onClick(View v) {
                PhotoInfo info = (PhotoInfo)v.getTag();
                if (!info.selected) {
                    if (mPreSelectedPaths == null && mSelectedPath.size() + 1 > mAmount) {
                        ((BaseActivity)mContext.getActivity()).getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(mContext.getString(R.string.str_photos_dialog_limit_title), String.format(mContext.getString(R.string.str_photos_selected_limit), mAmount), true, null));
                        return;
                    }
                    if (mPreSelectedPaths != null && mPreSelectedPaths.size() + mSelectedPath.size() + 1 > mAmount) {
                        ((BaseActivity)mContext.getActivity()).getDialogLinkManager().showDialog((IBaseDialog)new TitleAndMessageKnownDialog(mContext.getString(R.string.str_photos_dialog_limit_title), String.format(mContext.getString(R.string.str_photos_selected_limit), mAmount), true, null));
                        return;
                    }
                    if (v instanceof CheckView) {
                        ((CheckView)v).setChecked(true);
                        info.selected = true;
                        mSelectedPath.add(info.image);
                        ((CheckView)v).setCheckNum(mSelectedPath.size());
                    }
                } else if (v instanceof CheckView) {
                    ((CheckView)v).setChecked(false);
                    info.selected = false;
                    mSelectedPath.remove(info.image);
                    this.notifyDataSetChanged();
                }
                if (mButtonPhotoPick != null) {
                    if (mSelectedPath.size() == 0) {
                        mButtonPhotoPick.setEnabled(false);
                        mButtonPhotoPick.setText((CharSequence)"\u786e\u5b9a(0)");
                    } else {
                        mButtonPhotoPick.setEnabled(true);
                        mButtonPhotoPick.setText((CharSequence)("\u786e\u5b9a(" + mSelectedPath.size() + ")"));
                    }
                }
            }
        };

        PhotoAdapter(Fragment context, Button buttonPhotoPick, int amount, ArrayList<String> selectedPaths) {
            this.mContext = context;
            this.mButtonPhotoPick = buttonPhotoPick;
            this.mPreSelectedPaths = selectedPaths;
            this.mInflater = LayoutInflater.from((Context)context.getActivity());
            this.mAmount = amount;
        }

        public void setData(List<PhotoInfo> data) {
            if (data != null && data.size() > 0) {
                this.mData.addAll(data);
                this.notifyDataSetChanged();
            }
        }

        ArrayList<PhotoInfo> getSelectedData() {
            ArrayList<PhotoInfo> selected = new ArrayList<PhotoInfo>();
            for (PhotoInfo info : this.mData) {
                if (!info.selected) continue;
                selected.add(info);
            }
            return selected;
        }

        @SuppressLint(value={"SetTextI18n"})
        void previewBackRefreshSelection(List<String> selectedList) {
            if (selectedList != null) {
                this.mSelectedPath.clear();
                this.mSelectedPath.addAll(selectedList);
            }
            if (this.mButtonPhotoPick != null) {
                if (this.mSelectedPath.size() == 0) {
                    this.mButtonPhotoPick.setEnabled(false);
                    this.mButtonPhotoPick.setText((CharSequence)"\u786e\u5b9a(0)");
                } else {
                    this.mButtonPhotoPick.setEnabled(true);
                    this.mButtonPhotoPick.setText((CharSequence)("\u786e\u5b9a(" + this.mSelectedPath.size() + ")"));
                }
            }
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.mData.size() % this.mLineCount == 0) {
                return this.mData.size() / this.mLineCount;
            }
            return this.mData.size() / this.mLineCount + 1;
        }

        public PhotoInfo getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            String url;
            int i;
            PhotoInfo info;
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.item_all_photo_pick, parent, false);
                holder = new ViewHolder();
                holder.mContainer1 = convertView.findViewById(R.id.container1);
                holder.mContainer1.setOnClickListener(this.mItemClick);
                holder.mThumb1 = (ImageView)convertView.findViewById(R.id.thumb1);
                holder.mCheckBox1 = (CheckView)convertView.findViewById(R.id.selected1);
                holder.mCheckBox1.setOnClickListener(this.mCheckedListener);
                holder.mContainer2 = convertView.findViewById(R.id.container2);
                holder.mContainer2.setOnClickListener(this.mItemClick);
                holder.mThumb2 = (ImageView)convertView.findViewById(R.id.thumb2);
                holder.mCheckBox2 = (CheckView)convertView.findViewById(R.id.selected2);
                holder.mCheckBox2.setOnClickListener(this.mCheckedListener);
                holder.mContainer3 = convertView.findViewById(R.id.container3);
                holder.mContainer3.setOnClickListener(this.mItemClick);
                holder.mThumb3 = (ImageView)convertView.findViewById(R.id.thumb3);
                holder.mCheckBox3 = (CheckView)convertView.findViewById(R.id.selected3);
                holder.mCheckBox3.setOnClickListener(this.mCheckedListener);
                holder.mContainer4 = convertView.findViewById(R.id.container4);
                holder.mContainer4.setOnClickListener(this.mItemClick);
                holder.mThumb4 = (ImageView)convertView.findViewById(R.id.thumb4);
                holder.mCheckBox4 = (CheckView)convertView.findViewById(R.id.selected4);
                holder.mCheckBox4.setOnClickListener(this.mCheckedListener);
                holder.mContainer5 = convertView.findViewById(R.id.container5);
                holder.mContainer5.setOnClickListener(this.mItemClick);
                holder.mThumb5 = (ImageView)convertView.findViewById(R.id.thumb5);
                holder.mCheckBox5 = (CheckView)convertView.findViewById(R.id.selected5);
                holder.mCheckBox5.setOnClickListener(this.mCheckedListener);
                holder.mContainer6 = convertView.findViewById(R.id.container6);
                holder.mContainer6.setOnClickListener(this.mItemClick);
                holder.mThumb6 = (ImageView)convertView.findViewById(R.id.thumb6);
                holder.mCheckBox6 = (CheckView)convertView.findViewById(R.id.selected6);
                holder.mCheckBox6.setOnClickListener(this.mCheckedListener);
                int height = (int)(((float)ResolutionUtils.getScreenWidth((Context)this.mContext.getActivity()) - ResolutionUtils.convertDpToPixel((float)10.0f, (Context)this.mContext.getActivity())) / (float)this.mLineCount);
                holder.mThumb1.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.mThumb2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.mThumb3.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.mThumb4.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.mThumb5.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                holder.mThumb6.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            int index = position * this.mLineCount;
            if (index < this.mData.size()) {
                holder.mContainer1.setVisibility(0);
                info = this.mData.get(index);
                holder.mContainer1.setTag((Object)info);
                holder.mCheckBox1.setTag(info);
                if (info.selected) {
                    for (i = 0; i < this.mSelectedPath.size(); ++i) {
                        if (!info.image.equals(this.mSelectedPath.get(i))) continue;
                        if (!holder.mCheckBox1.isChecked()) {
                            holder.mCheckBox1.setChecked(true);
                        }
                        holder.mCheckBox1.setCheckNum(i + 1);
                        break;
                    }
                } else {
                    holder.mCheckBox1.setChecked(false);
                }
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                Glide.with((Fragment)this.mContext).asBitmap().apply(new RequestOptions().centerCrop().placeholder(R.drawable.default_live_drawable)).load(url).into(holder.mThumb1);
            } else {
                holder.mContainer1.setVisibility(4);
            }
            if (index + 1 < this.mData.size()) {
                holder.mContainer2.setVisibility(0);
                info = this.mData.get(index + 1);
                holder.mContainer2.setTag((Object)info);
                holder.mCheckBox2.setTag(info);
                if (info.selected) {
                    for (i = 0; i < this.mSelectedPath.size(); ++i) {
                        if (!info.image.equals(this.mSelectedPath.get(i))) continue;
                        if (!holder.mCheckBox2.isChecked()) {
                            holder.mCheckBox2.setChecked(true);
                        }
                        holder.mCheckBox2.setCheckNum(i + 1);
                        break;
                    }
                } else {
                    holder.mCheckBox2.setChecked(false);
                }
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                Glide.with((Fragment)this.mContext).asBitmap().load(url).apply(new RequestOptions().centerCrop().placeholder(R.drawable.default_live_drawable)).into(holder.mThumb2);
            } else {
                holder.mContainer2.setVisibility(4);
            }
            if (index + 2 < this.mData.size()) {
                holder.mContainer3.setVisibility(0);
                info = this.mData.get(index + 2);
                holder.mContainer3.setTag((Object)info);
                holder.mCheckBox3.setTag(info);
                if (info.selected) {
                    for (i = 0; i < this.mSelectedPath.size(); ++i) {
                        if (!info.image.equals(this.mSelectedPath.get(i))) continue;
                        if (!holder.mCheckBox3.isChecked()) {
                            holder.mCheckBox3.setChecked(true);
                        }
                        holder.mCheckBox3.setCheckNum(i + 1);
                        break;
                    }
                } else {
                    holder.mCheckBox3.setChecked(false);
                }
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                Glide.with((Fragment)this.mContext).asBitmap().load(url).apply(new RequestOptions().centerCrop().placeholder(R.drawable.default_live_drawable)).into(holder.mThumb3);
            } else {
                holder.mContainer3.setVisibility(4);
            }
            if (index + 3 < this.mData.size()) {
                holder.mContainer4.setVisibility(0);
                info = this.mData.get(index + 3);
                holder.mContainer4.setTag((Object)info);
                holder.mCheckBox4.setTag(info);
                if (info.selected) {
                    for (i = 0; i < this.mSelectedPath.size(); ++i) {
                        if (!info.image.equals(this.mSelectedPath.get(i))) continue;
                        if (!holder.mCheckBox4.isChecked()) {
                            holder.mCheckBox4.setChecked(true);
                        }
                        holder.mCheckBox4.setCheckNum(i + 1);
                        break;
                    }
                } else {
                    holder.mCheckBox4.setChecked(false);
                }
                url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
                Glide.with((Fragment)this.mContext).asBitmap().load(url).apply(new RequestOptions().centerCrop().placeholder(R.drawable.default_live_drawable)).into(holder.mThumb4);
            } else {
                holder.mContainer4.setVisibility(4);
            }
            if (this.mLineCount < 6) {
                holder.mContainer5.setVisibility(8);
                holder.mContainer6.setVisibility(8);
            }
            return convertView;
        }

        private static class ViewHolder {
            private View mContainer1;
            private ImageView mThumb1;
            private CheckView mCheckBox1;
            private View mContainer2;
            private ImageView mThumb2;
            private CheckView mCheckBox2;
            private View mContainer3;
            private ImageView mThumb3;
            private CheckView mCheckBox3;
            private View mContainer4;
            private ImageView mThumb4;
            private CheckView mCheckBox4;
            private View mContainer5;
            private ImageView mThumb5;
            private CheckView mCheckBox5;
            private View mContainer6;
            private ImageView mThumb6;
            private CheckView mCheckBox6;

            private ViewHolder() {
            }
        }
    }
}

