/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.photopicker;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.NinePatchDrawableImageViewTarget;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.widget.photopicker.AlbumInfo;
import com.yy.mobile.ui.widget.photopicker.PhotoPickActivity;
import com.yy.mobile.ui.widget.photopicker.loader.album.AlbumCallback;
import com.yy.mobile.ui.widget.photopicker.loader.album.AlbumLoaderHelper;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class AlbumPickFragment
extends BaseLinkFragment
implements AlbumCallback {
    private static final String TAG = "AlbumPickFragment";
    private AlbumAdapter mAdapter;
    private boolean isFromCover;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private AlbumLoaderHelper mAlbumLoaderHelper;
    private AdapterView.OnItemClickListener mItemClicked = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            if (AlbumPickFragment.this.mTimeSlotTool.isProcessing()) {
                return;
            }
            AlbumInfo info = AlbumPickFragment.this.mAdapter.getItem(position);
            if (info == null) {
                return;
            }
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)AlbumPickFragment.TAG, (String)("xuwakao, info = " + info));
            }
            if (AlbumPickFragment.this.isFromCover) {
                Intent intent = new Intent();
                intent.putExtra("params_folder_name", info.folder);
                intent.putExtra("params_bucket_id", info.bucketId);
                AlbumPickFragment.this.getActivity().setResult(-1, intent);
                AlbumPickFragment.this.getActivity().finish();
            } else {
                Intent intent = new Intent((Context)AlbumPickFragment.this.getActivity(), PhotoPickActivity.class);
                intent.putExtras(AlbumPickFragment.this.getArguments());
                intent.putExtra("params_bucket_id", info.bucketId);
                AlbumPickFragment.this.startActivityForResult(intent, 2003);
            }
        }
    };

    public static AlbumPickFragment newInstance(Bundle extras) {
        AlbumPickFragment fragment = new AlbumPickFragment();
        fragment.setArguments(extras);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAlbumLoaderHelper = new AlbumLoaderHelper((Fragment)this, (AlbumCallback)this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.layout_sharp_girl_pick_albums, container, false);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getArguments();
        this.isFromCover = data.getBoolean("params_preview_cover", false);
        ListView listView = (ListView)view.findViewById(R.id.listview);
        listView.setOnItemClickListener(this.mItemClicked);
        this.mAdapter = new AlbumAdapter((Context)this.getActivity());
        listView.setAdapter((ListAdapter)this.mAdapter);
        this.mAlbumLoaderHelper.startLoad();
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putAll(this.getArguments());
        outState.putBoolean("params_preview_cover", this.isFromCover);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 2003) {
            if (resultCode == -1) {
                this.getActivity().setResult(-1, data);
                this.getActivity().finish();
            } else if (resultCode == 2 && data != null) {
                this.getArguments().putAll(data.getExtras());
            }
        }
    }

    @Override
    public void onAlbumInfo(List<AlbumInfo> data) {
        if (this.mAdapter != null && data != null && this.mAdapter.getCount() == 0) {
            if (this.isFromCover) {
                try {
                    int allCount = 0;
                    for (AlbumInfo itemData : data) {
                        allCount += itemData.count;
                    }
                    AlbumInfo allInfo = new AlbumInfo();
                    allInfo.folder = "\u6240\u6709\u7167\u7247";
                    allInfo.bucketId = "REQUEST_ALL_PHOTOS";
                    allInfo.count = allCount;
                    allInfo.image = data.get((int)0).image;
                    allInfo.thumb = data.get((int)0).thumb;
                    data.add(0, allInfo);
                }
                catch (Exception ex) {
                    MLog.error((Object)TAG, (Throwable)ex);
                }
            }
            this.mAdapter.setData(data);
        }
    }

    public static class AlbumAdapter
    extends BaseAdapter {
        private LayoutInflater mInflater;
        private List<AlbumInfo> mData = new ArrayList<AlbumInfo>();

        public AlbumAdapter(Context context) {
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public void setData(List<AlbumInfo> data) {
            if (data != null && data.size() > 0) {
                this.mData.addAll(data);
            }
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.mData.size();
        }

        public AlbumInfo getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.item_sharp_albums, parent, false);
                holder = new ViewHolder();
                holder.thumb = (RecycleImageView)convertView.findViewById(R.id.thumb);
                holder.name = (TextView)convertView.findViewById(R.id.name);
                holder.count = (TextView)convertView.findViewById(R.id.count);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            AlbumInfo info = this.getItem(position);
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)AlbumPickFragment.TAG, (String)("xuwakao, LocalAlbumModel.AlbumInfo2 = " + info));
            }
            if (info == null) {
                return convertView;
            }
            String url = FP.empty((CharSequence)info.thumb) ? info.image : info.thumb;
            Glide.with((Context)holder.thumb.getContext()).load((Object)url).apply(new RequestOptions().placeholder(R.drawable.hp_mn_mobile_live_topic_default_bg).error(R.drawable.hp_mn_mobile_live_topic_default_bg)).into((Target)new NinePatchDrawableImageViewTarget((ImageView)holder.thumb));
            holder.name.setText((CharSequence)info.folder);
            holder.count.setText((CharSequence)("(" + info.count + ")"));
            return convertView;
        }

        private static class ViewHolder {
            RecycleImageView thumb;
            TextView name;
            TextView count;

            private ViewHolder() {
            }
        }
    }
}

