/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dragsortgirdview;

import java.util.Arrays;

public class ReorderArray {
    private int[] mArray;
    private int[] mCacheArray;
    private OnMoveListener mOnMoveListener;

    public ReorderArray(int capacity) {
        this.mArray = new int[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.mArray[i] = i;
        }
    }

    public int getCount() {
        return this.mArray.length;
    }

    private void set(int position, int value) {
        int length = this.mCacheArray.length;
        if (position < 0 || position > length - 1) {
            return;
        }
        this.mCacheArray[position] = value;
    }

    protected final void move(int fromPos, int toPos) {
        if (this.mOnMoveListener != null) {
            this.mOnMoveListener.onMove(fromPos, toPos);
        }
        int value = this.get(fromPos);
        this.set(toPos, value);
    }

    public final int get(int position) {
        int length = this.mArray.length;
        if (position < 0 || position > length - 1) {
            return -1;
        }
        return this.mArray[position];
    }

    public final int indexOf(int value) {
        int[] array = this.mArray;
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            index = i;
            break;
        }
        return index;
    }

    public final void reOrder(int fromPos, int toPos) {
        if (fromPos == toPos) {
            return;
        }
        this.copyArray();
        int fromValue = this.get(fromPos);
        this.onReOrder(fromPos, toPos);
        this.set(toPos, fromValue);
        this.applyArray();
    }

    public void onReOrder(int fromPos, int toPos) {
        if (fromPos > toPos) {
            for (int i = fromPos; i > toPos; --i) {
                this.move(i - 1, i);
            }
        } else {
            for (int i = fromPos; i < toPos; ++i) {
                this.move(i + 1, i);
            }
        }
    }

    private void copyArray() {
        this.mCacheArray = Arrays.copyOf(this.mArray, this.mArray.length);
    }

    private void applyArray() {
        this.mArray = this.mCacheArray;
    }

    public String toString() {
        int[] array = this.mArray;
        int length = array.length;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < length; ++i) {
            sb.append(array[i]);
            if (i < length - 1) {
                sb.append(",");
                continue;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public void setOnMoveListener(OnMoveListener listener2) {
        this.mOnMoveListener = listener2;
    }

    public static interface OnMoveListener {
        public void onMove(int var1, int var2);
    }
}

