/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dragsortgirdview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Display;
import android.view.DragEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.HorizontalScrollView;
import android.widget.ListAdapter;
import com.yy.mobile.ui.widget.dragsortgirdview.DragSortAdapter;
import com.yy.mobile.ui.widget.dragsortgirdview.ReorderArray;
import com.yy.mobile.util.log.MLog;

public class DragSortGridView
extends GridView
implements ReorderArray.OnMoveListener {
    private static final int SCROLL_DISTANCE = (int)(2.0f * Resources.getSystem().getDisplayMetrics().density);
    private static final boolean DEBUG = false;
    private static final String TAG = "DragSortGridView";
    private static SparseArray<String> DRAG_EVENT_ACTION = null;
    private int mCurrentX;
    private int mScreenWidth;
    private HorizontalScrollView mParentView;
    private static final int FLAG_DRAW_APPEARING = 1;
    private static final int FLAG_DRAW_DISAPPEARING = 2;
    private boolean mDragSortEnabled;
    private int mLastDragPosition;
    private int mLastTargetPosition;
    private int mAppearingPosition;
    private int mDisappearingPosition;
    private int mMovingChildViewsNum;
    private int mPrivateFlags;
    private Drawable mAppearingDrawable;
    private Drawable mDisappearingDrawable;
    private Animation mFadeOutAnimation;
    private ReorderArray mReorderArray;
    private Handler mHandler = new Handler();
    private OnReorderContentListener mOnReorderListener;
    private Runnable mScrollRunnable = new Runnable(){

        @Override
        public void run() {
            DragSortGridView.this.mHandler.postDelayed((Runnable)this, 30L);
            if (DragSortGridView.this.mCurrentX < DragSortGridView.this.mScreenWidth / 5 && DragSortGridView.this.mParentView.canScrollHorizontally(-1)) {
                DragSortGridView.this.mParentView.smoothScrollBy(-SCROLL_DISTANCE, 0);
            } else if (DragSortGridView.this.mCurrentX > DragSortGridView.this.mScreenWidth * 4 / 5 && DragSortGridView.this.mParentView.canScrollHorizontally(1)) {
                DragSortGridView.this.mParentView.smoothScrollBy(SCROLL_DISTANCE, 0);
            }
        }
    };

    public DragSortGridView(Context context) {
        super(context);
        this.init(context);
    }

    public DragSortGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DragSortGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public void setmParentView(HorizontalScrollView mParentView) {
        this.mParentView = mParentView;
    }

    private void init(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        this.mScreenWidth = display.getWidth();
        this.mDragSortEnabled = true;
        this.mFadeOutAnimation = new AlphaAnimation(1.0f, 0.0f);
        this.mFadeOutAnimation.setDuration(150L);
        this.mFadeOutAnimation.setFillEnabled(true);
        this.mFadeOutAnimation.setFillAfter(true);
        this.mFadeOutAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        this.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                if (DragSortGridView.this.mDragSortEnabled) {
                    view.startDrag(null, new View.DragShadowBuilder(view), (Object)position, 0);
                    return true;
                }
                return false;
            }
        });
        this.setOnDragListener(new View.OnDragListener(){

            public boolean onDrag(View v, DragEvent event) {
                int x = Math.round(event.getX());
                int y = Math.round(event.getY());
                int action = event.getAction();
                ListAdapter adapter = DragSortGridView.this.getAdapter();
                switch (action) {
                    case 1: {
                        if (DragSortGridView.this.mParentView != null) {
                            DragSortGridView.this.mHandler.post(DragSortGridView.this.mScrollRunnable);
                        }
                        if (adapter instanceof DragSortAdapter) {
                            DragSortAdapter dragSortAdapter = (DragSortAdapter)adapter;
                            DragSortGridView.this.mReorderArray = dragSortAdapter.getReorderArray();
                        }
                        if (DragSortGridView.this.mReorderArray == null) {
                            DragSortGridView.this.mReorderArray = new ReorderArray(adapter.getCount());
                        }
                        DragSortGridView.this.mReorderArray.setOnMoveListener(DragSortGridView.this);
                        int actualPos = (Integer)event.getLocalState();
                        View dragView = DragSortGridView.this.getView(actualPos);
                        dragView.startAnimation(DragSortGridView.this.mFadeOutAnimation);
                        DragSortGridView.this.mPrivateFlags = DragSortGridView.this.mPrivateFlags | 2;
                        DragSortGridView.this.mLastDragPosition = actualPos;
                        DragSortGridView.this.mDisappearingPosition = actualPos;
                        DragSortGridView.this.mLastTargetPosition = -1;
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 2: {
                        int targetPos;
                        if (DragSortGridView.this.mParentView != null) {
                            DragSortGridView.this.mCurrentX = x - DragSortGridView.this.mParentView.getScrollX();
                            if (DragSortGridView.this.mCurrentX < DragSortGridView.this.mScreenWidth / 5 || DragSortGridView.this.mCurrentX > DragSortGridView.this.mScreenWidth * 4 / 5) {
                                DragSortGridView.this.mHandler.post(DragSortGridView.this.mScrollRunnable);
                            } else {
                                DragSortGridView.this.mHandler.removeCallbacks(DragSortGridView.this.mScrollRunnable);
                            }
                        }
                        if (DragSortGridView.this.mMovingChildViewsNum > 0) break;
                        int originalPos = DragSortGridView.this.getOriginalPos(x, y);
                        int n = targetPos = originalPos == -1 ? -1 : DragSortGridView.this.mReorderArray.indexOf(originalPos);
                        if (-1 == targetPos || targetPos == DragSortGridView.this.mLastTargetPosition) break;
                        if (targetPos != DragSortGridView.this.mLastDragPosition) {
                            DragSortGridView.this.mPrivateFlags = DragSortGridView.this.mPrivateFlags & 0xFFFFFFFD;
                            DragSortGridView.this.mPrivateFlags = DragSortGridView.this.mPrivateFlags | 1;
                            DragSortGridView.this.mAppearingPosition = targetPos;
                        }
                        DragSortGridView.this.mLastTargetPosition = targetPos;
                        int dragPositon = DragSortGridView.this.mLastDragPosition;
                        DragSortGridView.this.reOrderViews(dragPositon, targetPos);
                        DragSortGridView.this.mLastDragPosition = targetPos;
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        int fromPos = DragSortGridView.this.mReorderArray.get(DragSortGridView.this.mLastTargetPosition);
                        int toPos = DragSortGridView.this.mLastTargetPosition;
                        int dragViewPos = toPos == -1 ? DragSortGridView.this.mLastDragPosition : toPos;
                        View lastDragView = DragSortGridView.this.getView(dragViewPos);
                        lastDragView.clearAnimation();
                        NotifyExecutor executor = new NotifyExecutor(fromPos, toPos);
                        DragSortGridView.this.mHandler.post((Runnable)executor);
                        DragSortGridView.this.mLastDragPosition = -1;
                        DragSortGridView.this.mLastTargetPosition = -1;
                        break;
                    }
                    case 3: {
                        if (DragSortGridView.this.mParentView == null) break;
                        DragSortGridView.this.mHandler.removeCallbacks(DragSortGridView.this.mScrollRunnable);
                        break;
                    }
                }
                return true;
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        MLog.debug((String)TAG, (String)"onDraw");
        if ((this.mPrivateFlags & 1) != 0) {
            Drawable drawable2 = this.mAppearingDrawable;
            int position = this.mAppearingPosition;
            if (position != -1 && drawable2 != null) {
                this.drawIndicator(canvas, position, drawable2);
            }
        } else if ((this.mPrivateFlags & 2) != 0) {
            Drawable drawable3 = this.mDisappearingDrawable;
            int position = this.mDisappearingPosition;
            if (position != -1 && drawable3 != null) {
                this.drawIndicator(canvas, position, drawable3);
            }
        }
    }

    protected void showAppearingAtPosition(int position) {
        this.mPrivateFlags |= 1;
        this.mAppearingPosition = position;
    }

    protected void showDisappearingAtPosition(int position) {
        this.mPrivateFlags |= 2;
        this.mDisappearingPosition = position;
    }

    protected void hideAppearing() {
        this.mPrivateFlags &= 0xFFFFFFFE;
    }

    protected void hideDisappearing() {
        this.mPrivateFlags &= 0xFFFFFFFD;
    }

    public void setDragSortEnabled(boolean enabled) {
        this.mDragSortEnabled = enabled;
    }

    protected void drawIndicator(Canvas canvas, int position, Drawable drawable2) {
        if (position == -1) {
            return;
        }
        View view = this.getView(position);
        if (view == null) {
            return;
        }
        canvas.save();
        int l = view.getLeft();
        int t = view.getTop();
        canvas.translate((float)l, (float)t);
        drawable2.setBounds(0, 0, view.getWidth(), view.getHeight());
        drawable2.draw(canvas);
        canvas.restore();
    }

    private void notifyAfterMoveView(int fromPos, int toPos) {
        if (-1 == toPos || fromPos == toPos) {
            return;
        }
        if (this.mOnReorderListener != null) {
            this.mOnReorderListener.onReOrderContent(fromPos, toPos);
        } else {
            ListAdapter adapter = this.getAdapter();
            if (adapter instanceof DragSortAdapter) {
                DragSortAdapter dragSortAdapter = (DragSortAdapter)adapter;
                dragSortAdapter.onReOrderContent(fromPos, toPos);
            }
        }
    }

    private void reOrderViews(int fromPos, int toPos) {
        MLog.debug((String)TAG, (String)("reOrder:" + fromPos + "<-->" + fromPos));
        if (fromPos == toPos) {
            return;
        }
        View fromView = this.getView(fromPos);
        View toView = this.getView(toPos);
        Rect toRect = new Rect();
        this.getRect(toView, toRect);
        this.mReorderArray.reOrder(fromPos, toPos);
        fromView.layout(toRect.left, toRect.top, toRect.right, toRect.bottom);
    }

    @Override
    public void onMove(int fromPos, int toPos) {
        this.moveView(fromPos, toPos);
    }

    private void moveView(int fromPos, int toPos) {
        View fromView = this.getView(fromPos);
        View toView = this.getView(toPos);
        Rect fromRect = new Rect();
        Rect toRect = new Rect();
        this.getRect(fromView, fromRect);
        this.getRect(toView, toRect);
        int tx = toRect.left - fromRect.left;
        int ty = toRect.top - fromRect.top;
        TranslateAnimation translate = new TranslateAnimation(0.0f, (float)tx, 0.0f, (float)ty);
        translate.setDuration(150L);
        translate.setFillEnabled(true);
        translate.setFillAfter(true);
        translate.setAnimationListener((Animation.AnimationListener)new MoveViewAnimationListener(fromView, toView.getLeft(), toView.getTop()));
        fromView.startAnimation((Animation)translate);
        ++this.mMovingChildViewsNum;
    }

    protected View getView(int actualPos) {
        int originalPos = actualPos;
        ReorderArray array = this.mReorderArray;
        if (array != null) {
            originalPos = array.get(actualPos);
        }
        return this.getChildAt(originalPos - this.getFirstVisiblePosition());
    }

    protected void getRect(View view, Rect rect) {
        rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    private int getOriginalPos(int x, int y) {
        return this.pointToPosition(x, y);
    }

    public void setOnReorderedListener(OnReorderContentListener listener2) {
        this.mOnReorderListener = listener2;
    }

    public void setAppearingDrawable(int id2) {
        this.mAppearingDrawable = this.getResources().getDrawable(id2);
    }

    public void setDisappearingDrawable(int id2) {
        this.mDisappearingDrawable = this.getResources().getDrawable(id2);
    }

    protected Drawable getAppearingDrawable() {
        return this.mAppearingDrawable;
    }

    protected Drawable getDisappearingDrawable() {
        return this.mDisappearingDrawable;
    }

    private class MoveViewAnimationListener
    implements Animation.AnimationListener {
        private View mTarget;
        private int mNewX;
        private int mNewY;

        MoveViewAnimationListener(View target, int newX, int newY) {
            this.mTarget = target;
            this.mNewX = newX;
            this.mNewY = newY;
        }

        public void onAnimationEnd(Animation animation) {
            this.mTarget.layout(this.mNewX, this.mNewY, this.mNewX + this.mTarget.getWidth(), this.mNewY + this.mTarget.getHeight());
            this.mTarget.clearAnimation();
            DragSortGridView.this.mMovingChildViewsNum--;
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    public static interface OnReorderContentListener {
        public void onReOrderContent(int var1, int var2);
    }

    private class NotifyExecutor
    implements Runnable {
        private int mFromPos;
        private int mToPos;

        NotifyExecutor(int fromPos, int toPos) {
            this.mFromPos = fromPos;
            this.mToPos = toPos;
        }

        @Override
        public void run() {
            if (DragSortGridView.this.mMovingChildViewsNum > 0) {
                DragSortGridView.this.mHandler.postDelayed((Runnable)this, 200L);
            } else {
                DragSortGridView.this.mPrivateFlags = DragSortGridView.this.mPrivateFlags & 0xFFFFFFFE;
                DragSortGridView.this.notifyAfterMoveView(this.mFromPos, this.mToPos);
            }
        }
    }
}

