/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.widget.dialog.OkCancelUpdateDialogListener;
import com.yymobile.core.update.utils.UpdateReportUtils;

public class UpdateDialog
implements IBaseDialog {
    public static final int RECOMMEND_UPDATE_DIALOG = 0;
    public static final int CANCEL_DIALOG = 1;
    public static final int ERROR_RETRY_DIALOG = 2;
    public static final int FORCE_UPDATE_DIALOG = 3;
    public static final int INSTALL_DIALOG = 4;
    private int dialogType;
    private CharSequence message;
    private CharSequence okLabel;
    private CharSequence cancelLabel;
    private boolean cancelable;
    private final OkCancelUpdateDialogListener listener;

    public UpdateDialog(int dialogType, CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, OkCancelUpdateDialogListener listener2) {
        this.dialogType = dialogType;
        this.message = message;
        this.okLabel = okLabel;
        this.cancelLabel = cancelLabel;
        this.cancelable = cancelable;
        this.listener = listener2;
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.cancelable);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView tip = (TextView)window.findViewById(R.id.message);
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            tip.setText(this.message);
        }
        tip.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UpdateDialog.this.listener != null) {
                    UpdateDialog.this.listener.onOk(dialog);
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (!TextUtils.isEmpty((CharSequence)this.cancelLabel)) {
            cancel.setText(this.cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UpdateDialog.this.listener != null) {
                    UpdateDialog.this.listener.onCancel(dialog);
                }
            }
        });
        this.reportDialogExpose();
    }

    private void reportDialogExpose() {
        if (this.dialogType == 0) {
            UpdateReportUtils.reportHiidoUpdateDialogExpose();
        }
    }

    public int getLayoutResId() {
        return R.layout.layout_update_dialog;
    }
}

