/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.util.StringUtils;

public class WebStyleSpinner
extends LinearLayout {
    private View mRootView;
    private View mSelectedItem;
    private TextView mSelectedItemInfoField;
    private TextView mSelectedItemDetailField;
    private ImageView mSelectedItemIcon;
    private ListView mList;
    private boolean mShowList = false;
    private View.OnClickListener onSelectedItemClickListener = null;
    private AdapterView.OnItemClickListener onItemClickListener = null;
    private boolean isLastItemSelect = false;
    private View.OnClickListener selectedItemClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            WebStyleSpinner.this.mShowList = !WebStyleSpinner.this.mShowList;
            WebStyleSpinner.this.showList(WebStyleSpinner.this.mShowList);
            if (WebStyleSpinner.this.mShowList) {
                InputMethodManager imm = (InputMethodManager)WebStyleSpinner.this.getContext().getSystemService("input_method");
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
            if (WebStyleSpinner.this.onSelectedItemClickListener != null) {
                WebStyleSpinner.this.onSelectedItemClickListener.onClick(view);
            }
        }
    };

    public boolean isListShown() {
        return this.mShowList;
    }

    public WebStyleSpinner(Context context) {
        super(context);
        this.init();
    }

    public WebStyleSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setOnSelectedItemClickListener(View.OnClickListener l) {
        this.onSelectedItemClickListener = l;
    }

    public void setListAdater(ListAdapter adapter) {
        this.mList.setAdapter(adapter);
    }

    public void setAdapter(BaseAdapter adapter) {
        this.mList.setAdapter((ListAdapter)adapter);
    }

    public void setListItemOnClickListener(AdapterView.OnItemClickListener l) {
        this.onItemClickListener = l;
    }

    public void updateSelectedItemInfo(final String info) {
        if (!StringUtils.isNullOrEmpty((String)info)) {
            this.mSelectedItemInfoField.post(new Runnable(){

                @Override
                public void run() {
                    WebStyleSpinner.this.mSelectedItemInfoField.setText((CharSequence)info);
                }
            });
        }
    }

    public void updateSelectedItemInfo(final String info, final int color2) {
        if (!StringUtils.isNullOrEmpty((String)info)) {
            this.mSelectedItemInfoField.post(new Runnable(){

                @Override
                public void run() {
                    WebStyleSpinner.this.mSelectedItemInfoField.setText((CharSequence)info);
                    WebStyleSpinner.this.mSelectedItemInfoField.setTextColor(color2);
                }
            });
        }
    }

    public void updateSelectedItemDetail(final String info) {
        this.mSelectedItemInfoField.post(new Runnable(){

            @Override
            public void run() {
                WebStyleSpinner.this.mSelectedItemDetailField.setText((CharSequence)info);
            }
        });
    }

    public boolean getIsLastItemSelected() {
        return this.isLastItemSelect;
    }

    private void init() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        this.mRootView = layoutInflater.inflate(R.layout.layout_web_style_spinner, (ViewGroup)this);
        this.mSelectedItem = this.mRootView.findViewById(R.id.select_info);
        this.mSelectedItemInfoField = (TextView)this.mRootView.findViewById(R.id.info);
        this.mSelectedItemDetailField = (TextView)this.mRootView.findViewById(R.id.detail);
        this.mSelectedItemIcon = (ImageView)this.mRootView.findViewById(R.id.icon);
        this.mList = (ListView)this.mRootView.findViewById(R.id.list);
        this.mSelectedItem.setOnClickListener(this.selectedItemClickListener);
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                WebStyleSpinner.this.isLastItemSelect = position == parent.getCount() - 1;
                if (WebStyleSpinner.this.onItemClickListener != null) {
                    WebStyleSpinner.this.onItemClickListener.onItemClick(parent, view, position, id2);
                }
            }
        });
    }

    public void showList(boolean showOrHide) {
        this.mShowList = showOrHide;
        int listVisibility = showOrHide ? 0 : 8;
        this.mList.setVisibility(listVisibility);
        this.mSelectedItemIcon.setEnabled(!showOrHide);
    }

    public void setSelection(int position) {
        this.mList.setSelection(position);
        this.isLastItemSelect = position == this.mList.getCount() - 1;
    }
}

